/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.webcontent;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.wcm.webui.selector.document.UIDocumentSearchForm;
import org.exoplatform.wcm.webui.selector.document.UIDocumentTabSelector;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentSearchForm;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentTabSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ChangeMetadataTypeActionListener.class})})
public class UIWCMSelectPropertyForm
extends UIForm {
    public static final String METADATA_TYPE = "metadataType";
    public static final String PROPERTY_SELECT = "property_select";
    private String fieldName = null;
    private List<SelectItemOption<String>> properties = new ArrayList<SelectItemOption<String>>();

    public UIWCMSelectPropertyForm() throws Exception {
        this.setActions(new String[]{"Add", "Cancel"});
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return super.getLabel(res, id);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public void init() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        UIFormSelectBox uiSelect = new UIFormSelectBox(METADATA_TYPE, METADATA_TYPE, options);
        uiSelect.setOnChange("ChangeMetadataType");
        this.addUIFormInput((UIFormInput)uiSelect);
        SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manRepository = repoService.getCurrentRepository();
        String workspaceName = manRepository.getConfiguration().getSystemWorkspaceName();
        Session session = sessionProvider.getSession(workspaceName, manRepository);
        String metadataPath = nodeHierarchyCreator.getJcrPath("metadataPath");
        Node homeNode = (Node)session.getItem(metadataPath);
        NodeIterator nodeIter = homeNode.getNodes();
        Node meta = nodeIter.nextNode();
        this.renderProperties(meta.getName());
        options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        while (nodeIter.hasNext()) {
            meta = nodeIter.nextNode();
            options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        }
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(PROPERTY_SELECT, null, this.properties).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
        session.logout();
        sessionProvider.close();
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void renderProperties(String metadata) throws Exception {
        PropertyDefinition[] propertieDefs;
        this.properties.clear();
        SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manRepository = repoService.getCurrentRepository();
        String workspaceName = manRepository.getConfiguration().getSystemWorkspaceName();
        Session session = sessionProvider.getSession(workspaceName, manRepository);
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(metadata);
        for (PropertyDefinition property : propertieDefs = nt.getPropertyDefinitions()) {
            String name = property.getName();
            if (name.equals("exo:internalUse")) continue;
            this.properties.add((SelectItemOption<String>)new SelectItemOption(name, (Object)name));
        }
        session.logout();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeMetadataTypeActionListener
    extends EventListener<UIWCMSelectPropertyForm> {
        public void execute(Event<UIWCMSelectPropertyForm> event) throws Exception {
            UIWCMSelectPropertyForm uiForm = (UIWCMSelectPropertyForm)((Object)event.getSource());
            uiForm.renderProperties((String)uiForm.getUIFormSelectBox(UIWCMSelectPropertyForm.METADATA_TYPE).getValue());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIWCMSelectPropertyForm> {
        public void execute(Event<UIWCMSelectPropertyForm> event) throws Exception {
            UIWCMSelectPropertyForm uiForm = (UIWCMSelectPropertyForm)((Object)event.getSource());
            String property = (String)((UIFormRadioBoxInput)uiForm.getUIInput(UIWCMSelectPropertyForm.PROPERTY_SELECT)).getValue();
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiPopupWindow.getAncestorOfType(UIWebContentTabSelector.class);
            if (uiWCTabSelector == null) {
                UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiPopupWindow.getAncestorOfType(UIDocumentTabSelector.class);
                UIDocumentSearchForm uiDocSearchForm = (UIDocumentSearchForm)uiDocTabSelector.findFirstComponentOfType(UIDocumentSearchForm.class);
                uiDocSearchForm.getUIStringInput(uiForm.getFieldName()).setValue((Object)property);
                uiDocTabSelector.removeChild(UIPopupWindow.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocTabSelector);
                uiDocTabSelector.setSelectedTab(uiDocSearchForm.getId());
            } else {
                UIWebContentSearchForm uiWCSearchForm = (UIWebContentSearchForm)uiWCTabSelector.findFirstComponentOfType(UIWebContentSearchForm.class);
                uiWCSearchForm.getUIStringInput(uiForm.getFieldName()).setValue((Object)property);
                uiWCTabSelector.removeChild(UIPopupWindow.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
                uiWCTabSelector.setSelectedTab(uiWCSearchForm.getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWCMSelectPropertyForm> {
        public void execute(Event<UIWCMSelectPropertyForm> event) throws Exception {
            UIWCMSelectPropertyForm uiForm = (UIWCMSelectPropertyForm)((Object)event.getSource());
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiPopupWindow.getAncestorOfType(UIWebContentTabSelector.class);
            if (uiWCTabSelector == null) {
                UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiPopupWindow.getAncestorOfType(UIDocumentTabSelector.class);
                UIDocumentSearchForm uiDocSearchForm = (UIDocumentSearchForm)uiDocTabSelector.findFirstComponentOfType(UIDocumentSearchForm.class);
                uiDocTabSelector.removeChild(UIPopupWindow.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocTabSelector);
                uiDocTabSelector.setSelectedTab(uiDocSearchForm.getId());
            } else {
                uiWCTabSelector.removeChild(UIPopupWindow.class);
                UIWebContentSearchForm uiWCSearchForm = (UIWebContentSearchForm)uiWCTabSelector.getChild(UIWebContentSearchForm.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
                uiWCTabSelector.setSelectedTab(uiWCSearchForm.getId());
            }
        }
    }
}

