/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.wcm.webui.scv.UISCVPreferences;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/SingleContentViewer/UISCVPreferences.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTargetPageActionListener.class}, phase=Event.Phase.DECODE)})
public class UISCVPreferences
extends UIFormTabPane
implements UISelectable {
    public static final String ITEM_PATH_FORM_INPUT_SET = "UISCVConfigItemPathFormInputSet";
    public static final String CONTENT_FORM_INPUT_SET = "UISCVConfigContentFormInputSet";
    public static final String DISPLAY_FORM_INPUT_SET = "UISCVConfigDisplayFormInputSet";
    public static final String PRINT_FORM_INPUT_SET = "UISCVConfigPrintFormInputSet";
    public static final String ADVANCED_FORM_INPUT_SET = "UISCVConfigAdvancedFormInputSet";
    public static final String CONTENT_PATH_INPUT = "UISCVContentPathConfigurationInputBox";
    public static final String SHOW_TITLE_CHECK_BOX = "UISCVShowTitleConfigurationCheckBox";
    public static final String SHOW_DATE_CHECK_BOX = "UISCVShowDateConfigurationCheckBox";
    public static final String SHOW_OPION_BAR_CHECK_BOX = "UISCVShowOptionBarConfigurationCheckBox";
    public static final String CONTEXTUAL_SELECT_RADIO_BOX = "UISCVContextualRadioBox";
    public static final String PARAMETER_INPUT_BOX = "UISCVParameterInputBox";
    public static final String CACHE_ENABLE_SELECT_RADIO_BOX = "UISCVCacheRadioBox";
    public static final String PRINT_PAGE_FORM_INPUT_SET = "UISCVConfigPrintPageFormInputSet";
    public static final String PRINT_VIEW_PAGE_INPUT = "UISCVPrintViewPageInput";
    public static final String PRINT_PAGE_SELECTOR_POPUP = "UISCVConfigPrintPageSelectorPopupWindow";
    public static final String PRINT_PAGE_PARAMETER_INPUT = "UISCVPrintPageParameter";
    public static final String ENABLE_STRING = "Enable";
    public static final String DISABLE_STRING = "Disable";
    protected PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
    protected String contentSelectorID;
    protected String selectedNodeUUID = null;
    protected String selectedNodeReporitory = null;
    protected String selectedNodeWorkspace = null;
    protected String selectedNodeDrive = null;
    protected String selectedNodePath = null;
    private UIFormStringInput txtContentPath;
    private UIFormStringInput txtPrintPage;
    private UIFormStringInput txtPrintPageParameter;
    private UICheckBoxInput chkShowTitle;
    private UICheckBoxInput chkShowDate;
    private UICheckBoxInput chkShowOptionBar;
    private UIFormRadioBoxInput contextOptionsRadioInputBox;
    private UIFormRadioBoxInput cacheOptionsRadioInputBox;
    boolean isInternal = false;

    public UISCVPreferences() throws Exception {
        super("UISCVPreferences");
        this.initComponent();
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void initComponent() throws Exception {
        String strNodeName = this.getNodeNameByPreferences();
        this.txtContentPath = new UIFormStringInput(CONTENT_PATH_INPUT, CONTENT_PATH_INPUT, strNodeName);
        this.txtContentPath.setReadOnly(true);
        UIFormInputSetWithAction itemPathInputSet = new UIFormInputSetWithAction(ITEM_PATH_FORM_INPUT_SET);
        itemPathInputSet.setActionInfo(CONTENT_PATH_INPUT, new String[]{"AddPath"});
        itemPathInputSet.addUIFormInput((UIFormInput)this.txtContentPath);
        UIFormInputSetWithAction contentInputSet = new UIFormInputSetWithAction(CONTENT_FORM_INPUT_SET);
        contentInputSet.addUIFormInput((UIFormInputSet)itemPathInputSet);
        this.setSelectedTab(CONTENT_FORM_INPUT_SET);
        boolean blnShowTitle = Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_TITLE, null));
        this.chkShowTitle = new UICheckBoxInput(SHOW_TITLE_CHECK_BOX, SHOW_TITLE_CHECK_BOX, null);
        this.chkShowTitle.setChecked(blnShowTitle);
        boolean blnShowDate = Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_DATE, null));
        this.chkShowDate = new UICheckBoxInput(SHOW_DATE_CHECK_BOX, SHOW_DATE_CHECK_BOX, null);
        this.chkShowDate.setChecked(blnShowDate);
        boolean blnShowOptionBar = Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_OPTIONBAR, null));
        this.chkShowOptionBar = new UICheckBoxInput(SHOW_OPION_BAR_CHECK_BOX, SHOW_OPION_BAR_CHECK_BOX, null);
        this.chkShowOptionBar.setChecked(blnShowOptionBar);
        UIFormInputSetWithAction displayInputSet = new UIFormInputSetWithAction(DISPLAY_FORM_INPUT_SET);
        displayInputSet.addChild((UIComponent)this.chkShowTitle);
        displayInputSet.addChild((UIComponent)this.chkShowDate);
        displayInputSet.addChild((UIComponent)this.chkShowOptionBar);
        boolean isShowContextOption = Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"));
        ArrayList<SelectItemOption> contextOptions = new ArrayList<SelectItemOption>();
        contextOptions.add(new SelectItemOption(ENABLE_STRING, (Object)ENABLE_STRING));
        contextOptions.add(new SelectItemOption(DISABLE_STRING, (Object)DISABLE_STRING));
        this.contextOptionsRadioInputBox = new UIFormRadioBoxInput(CONTEXTUAL_SELECT_RADIO_BOX, CONTEXTUAL_SELECT_RADIO_BOX, contextOptions);
        this.contextOptionsRadioInputBox.setValue((Object)(isShowContextOption ? ENABLE_STRING : DISABLE_STRING));
        String strParameterName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PARAMETER, null);
        UIFormStringInput txtParameterName = new UIFormStringInput(PARAMETER_INPUT_BOX, strParameterName);
        boolean isCacheEnabled = Boolean.parseBoolean(this.portletPreferences.getValue("sharedCache", "false"));
        ArrayList<SelectItemOption> cacheOptions = new ArrayList<SelectItemOption>();
        cacheOptions.add(new SelectItemOption(ENABLE_STRING, (Object)ENABLE_STRING));
        cacheOptions.add(new SelectItemOption(DISABLE_STRING, (Object)DISABLE_STRING));
        this.cacheOptionsRadioInputBox = new UIFormRadioBoxInput(CACHE_ENABLE_SELECT_RADIO_BOX, CACHE_ENABLE_SELECT_RADIO_BOX, cacheOptions);
        this.cacheOptionsRadioInputBox.setValue((Object)(isCacheEnabled ? ENABLE_STRING : DISABLE_STRING));
        UIFormInputSetWithAction advancedInputSet = new UIFormInputSetWithAction(ADVANCED_FORM_INPUT_SET);
        advancedInputSet.addChild((UIComponent)txtParameterName);
        advancedInputSet.addChild((UIComponent)this.cacheOptionsRadioInputBox);
        advancedInputSet.addChild((UIComponent)this.contextOptionsRadioInputBox);
        advancedInputSet.addChild((UIComponent)txtParameterName);
        String strPrintParameterName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PRINT_PARAMETER, null);
        this.txtPrintPageParameter = new UIFormStringInput(PRINT_PAGE_PARAMETER_INPUT, strPrintParameterName);
        String strPrintPageName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PRINT_PAGE, null);
        UIFormInputSetWithAction targetPageInputSet = new UIFormInputSetWithAction(PRINT_PAGE_FORM_INPUT_SET);
        this.txtPrintPage = new UIFormStringInput(PRINT_VIEW_PAGE_INPUT, PRINT_VIEW_PAGE_INPUT, strPrintPageName);
        this.txtPrintPage.setValue((Object)strPrintPageName);
        this.txtPrintPage.setReadOnly(true);
        targetPageInputSet.setActionInfo(PRINT_VIEW_PAGE_INPUT, new String[]{"SelectTargetPage"});
        targetPageInputSet.addUIFormInput((UIFormInput)this.txtPrintPage);
        UIFormInputSetWithAction printInputSet = new UIFormInputSetWithAction(PRINT_FORM_INPUT_SET);
        printInputSet.addChild((UIComponent)this.txtPrintPageParameter);
        printInputSet.addChild((UIComponent)targetPageInputSet);
        this.addChild((UIComponent)contentInputSet);
        this.addChild((UIComponent)displayInputSet);
        this.addChild((UIComponent)printInputSet);
        this.addChild((UIComponent)advancedInputSet);
    }

    public void setSelectedNodeInfo(String nodeUUID, String nodeRepo, String nodeWS, String nodeDrive) {
        this.selectedNodeUUID = nodeUUID;
        this.selectedNodeReporitory = nodeRepo;
        this.selectedNodeWorkspace = nodeWS;
        this.selectedNodeDrive = nodeDrive;
    }

    public void setSelectedNodePath(String path) {
        this.selectedNodePath = path;
    }

    public String getSelectedNodePath() {
        return this.selectedNodePath;
    }

    public String getSelectedNodeUUID() {
        return this.selectedNodeUUID;
    }

    public String getSelectedNodeRepository() {
        return this.selectedNodeReporitory;
    }

    public String getSelectedNodeWorkspace() {
        return this.selectedNodeWorkspace;
    }

    public String getSelectedNodeDrive() {
        return this.selectedNodeDrive;
    }

    protected String getNodeNameByPreferences() {
        String repository = this.portletPreferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspace = this.portletPreferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String nodeIdentifier = this.portletPreferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        String nodeDrive = this.portletPreferences.getValue(UISingleContentViewerPortlet.DRIVE, null);
        try {
            Node savedNode = Utils.getRealNode((String)repository, (String)workspace, (String)nodeIdentifier, (boolean)false);
            if (savedNode == null) {
                return null;
            }
            this.setSelectedNodeInfo(savedNode.getUUID(), repository, workspace, nodeDrive);
            this.setSelectedNodePath(savedNode.getPath());
            return this.getTitle(savedNode);
        }
        catch (RepositoryException re) {
            return null;
        }
    }

    private String getTitle(Node node) throws RepositoryException {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception e) {
                title = null;
            }
        }
        if (title == null) {
            title = node.getName();
        }
        return ContentReader.getXSSCompatibilityContent((String)title);
    }

    public void setContentSelectorID(String id) {
        this.contentSelectorID = id;
    }

    public String getContetSelectorID() {
        return this.contentSelectorID;
    }

    public boolean isContextualEnable() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"));
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String strPath = (String)value;
        if (CONTENT_PATH_INPUT.equals(selectField)) {
            String[] splits = strPath.split(":");
            int driveIndex = splits.length == 4 ? 1 : 0;
            String strRepository = splits[driveIndex];
            String strWorkspace = splits[driveIndex + 1];
            String strIdentifier = splits[driveIndex + 2];
            String strDrive = driveIndex == 1 ? splits[0] : "";
            Node selectedNode = Utils.getRealNode((String)strRepository, (String)strWorkspace, (String)(strIdentifier = Text.escapeIllegalJcrChars((String)strIdentifier)), (boolean)false);
            if (selectedNode == null) {
                return;
            }
            String strNodeUUID = selectedNode.getUUID();
            this.setSelectedNodeInfo(strNodeUUID, strRepository, strWorkspace, strDrive);
            this.setSelectedNodePath(selectedNode.getPath());
            this.getUIStringInput(selectField).setValue((Object)ContentReader.getXSSCompatibilityContent((String)this.getTitle(selectedNode)));
        } else if (PRINT_VIEW_PAGE_INPUT.equals(selectField)) {
            this.getUIStringInput(selectField).setValue((Object)strPath);
        }
        Utils.closePopupWindow((UIContainer)this, (String)this.contentSelectorID);
    }

    public void setInternalPreferencesMode(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public boolean getInternalPreferencesMode() {
        return this.isInternal;
    }
}

