/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.authoring;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.authoring.UIDashBoardColumn;
import org.exoplatform.wcm.webui.authoring.UIDashboardForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/authoring/UIDashboardForm.gtmpl", events={@EventConfig(listeners={ShowDocumentActionListener.class}), @EventConfig(listeners={RefreshActionListener.class})})
public class UIDashboardForm
extends UIContainer {
    private int pageSize_ = 10;

    public UIDashboardForm() throws Exception {
        ((UIDashBoardColumn)this.addChild(UIDashBoardColumn.class, null, "UIDashboardDraft")).setLabel("UIDashboardForm.label.mydraft");
        ((UIDashBoardColumn)this.addChild(UIDashBoardColumn.class, null, "UIDashboardWaiting")).setLabel("UIDashboardForm.label.waitingapproval");
        ((UIDashBoardColumn)this.addChild(UIDashBoardColumn.class, null, "UIDashboardPublish")).setLabel("UIDashboardForm.label.publishedtomorrow");
        this.refreshData();
    }

    public List<Node> getContents(String fromstate) {
        return this.getContents(fromstate, null, null);
    }

    public List<Node> getContents(String fromstate, String tostate) {
        return this.getContents(fromstate, tostate, null);
    }

    public List<Node> getContents(String fromstate, String tostate, String date) {
        PublicationManager manager = (PublicationManager)WCMCoreUtils.getService(PublicationManager.class);
        String user = PortalRequestContext.getCurrentInstance().getRemoteUser();
        String lang = Util.getPortalRequestContext().getLocale().getLanguage();
        List nodes = new ArrayList();
        ArrayList<Node> temp = new ArrayList<Node>();
        try {
            nodes = manager.getContents(fromstate, tostate, date, user, lang, WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName());
            HashSet<CallSite> uuidList = new HashSet<CallSite>();
            for (Node node : nodes) {
                String currentState = null;
                if (node.hasProperty("publication:currentState")) {
                    currentState = node.getProperty("publication:currentState").getString();
                }
                if (currentState != null && currentState.equals("published") || Utils.isInTrash((Node)node) || uuidList.contains(node.getSession().getWorkspace().getName() + node.getUUID())) continue;
                uuidList.add((CallSite)((Object)(node.getSession().getWorkspace().getName() + node.getUUID())));
                temp.add(node);
            }
        }
        catch (Exception e) {
            temp = new ArrayList();
        }
        return temp;
    }

    private void refreshData() {
        ArrayList<UIDashBoardColumn> children = new ArrayList<UIDashBoardColumn>();
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIDashBoardColumn)) continue;
            children.add((UIDashBoardColumn)component);
        }
        ListAccessImpl draftNodes = new ListAccessImpl(NodeLocation.class, NodeLocation.getLocationsByNodeList((List)this.getContents("draft")));
        ((UIDashBoardColumn)children.get(0)).getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)draftNodes, this.pageSize_));
        ListAccessImpl waitingNodes = new ListAccessImpl(NodeLocation.class, NodeLocation.getLocationsByNodeList((List)this.getContents("pending")));
        ((UIDashBoardColumn)children.get(1)).getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)waitingNodes, this.pageSize_));
        ListAccessImpl publishedNodes = new ListAccessImpl(NodeLocation.class, NodeLocation.getLocationsByNodeList((List)this.getContents("staged", null, "2")));
        ((UIDashBoardColumn)children.get(2)).getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)publishedNodes, this.pageSize_));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.refreshData();
        super.processRender(context);
    }
}

