/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui;

import java.util.Calendar;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationPanel;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UIPublicationSchedule.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class})})
public class UIPublicationSchedule
extends UIForm {
    public static final String START_PUBLICATION = "UIPublicationPanelStartDateInput";
    public static final String END_PUBLICATION = "UIPublicationPanelEndDateInput";
    private static final Log LOG = LogFactory.getLog((String)UIPublicationSchedule.class.getName());

    public UIPublicationSchedule() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION, START_PUBLICATION, null));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION, END_PUBLICATION, null));
        this.setActions(new String[]{"Save", "Reset"});
    }

    public void init(Node node) throws Exception {
        Calendar startDate = null;
        Calendar endDate = null;
        if (node.hasProperty("publication:endPublishedDate")) {
            endDate = node.getProperty("publication:endPublishedDate").getDate();
        }
        if (node.hasProperty("publication:startPublishedDate")) {
            startDate = node.getProperty("publication:startPublishedDate").getDate();
        }
        if (startDate != null) {
            ((UIFormDateTimeInput)this.getChildById(START_PUBLICATION)).setCalendar(startDate);
        }
        if (endDate != null) {
            ((UIFormDateTimeInput)this.getChildById(END_PUBLICATION)).setCalendar(endDate);
        }
    }

    public static class ResetActionListener
    extends EventListener<UIPublicationSchedule> {
        public void execute(Event<UIPublicationSchedule> event) throws Exception {
            UIPublicationSchedule publicationSchedule = (UIPublicationSchedule)((Object)event.getSource());
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((UIPublicationContainer)publicationSchedule.getAncestorOfType(UIPublicationContainer.class)).getChild(UIPublicationPanel.class);
            Node node = publicationPanel.getCurrentNode();
            UIFormDateTimeInput startPublication = (UIFormDateTimeInput)publicationSchedule.getChildById(UIPublicationSchedule.START_PUBLICATION);
            startPublication.setCalendar(null);
            if (node.hasProperty("publication:startPublishedDate")) {
                node.getProperty("publication:startPublishedDate").remove();
                node.save();
            }
            UIFormDateTimeInput endPublication = (UIFormDateTimeInput)publicationSchedule.getChildById(UIPublicationSchedule.END_PUBLICATION);
            endPublication.setCalendar(null);
            if (node.hasProperty("publication:endPublishedDate")) {
                node.getProperty("publication:endPublishedDate").remove();
                node.save();
            }
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPublicationSchedule> {
        public void execute(Event<UIPublicationSchedule> event) throws Exception {
            UIPublicationSchedule publicationSchedule;
            block8: {
                publicationSchedule = (UIPublicationSchedule)((Object)event.getSource());
                UIPublicationPanel publicationPanel = (UIPublicationPanel)((UIPublicationContainer)publicationSchedule.getAncestorOfType(UIPublicationContainer.class)).getChild(UIPublicationPanel.class);
                UIFormDateTimeInput startPublication = (UIFormDateTimeInput)publicationSchedule.getChildById(UIPublicationSchedule.START_PUBLICATION);
                UIFormDateTimeInput endPublication = (UIFormDateTimeInput)publicationSchedule.getChildById(UIPublicationSchedule.END_PUBLICATION);
                String startValue = (String)startPublication.getValue();
                String endValue = (String)endPublication.getValue();
                Calendar startDate = startPublication.getCalendar();
                Calendar endDate = endPublication.getCalendar();
                Node node = publicationPanel.getCurrentNode();
                try {
                    if (startDate == null && StringUtils.isNotEmpty((String)startValue) || endDate == null && StringUtils.isNotEmpty((String)endValue)) {
                        UIApplication uiApp = (UIApplication)publicationSchedule.getAncestorOfType(UIApplication.class);
                        uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.invalid-format", null));
                        return;
                    }
                    if (startDate != null && endDate != null && startDate.after(endDate)) {
                        UIApplication uiApp = (UIApplication)publicationSchedule.getAncestorOfType(UIApplication.class);
                        uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.fromDate-after-toDate", null));
                        return;
                    }
                    if (node.isLocked()) {
                        node.getSession().addLockToken(LockUtil.getLockToken((Node)node));
                    }
                    if (StringUtils.isNotEmpty((String)startValue) || StringUtils.isNotEmpty((String)endValue)) {
                        if (StringUtils.isNotEmpty((String)startValue)) {
                            node.setProperty("publication:startPublishedDate", startDate);
                        }
                        if (StringUtils.isNotEmpty((String)endValue)) {
                            node.setProperty("publication:endPublishedDate", endDate);
                        }
                        node.getSession().save();
                    }
                }
                catch (ItemExistsException iee) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)"Error when adding properties to node");
                }
            }
            UIPopupContainer uiPopupContainer = (UIPopupContainer)publicationSchedule.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

