/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.deployment.PublicationDeploymentDescriptor;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PublicationUtils {
    private static final Log LOG = ExoLogger.getLogger((String)PublicationUtils.class.getName());

    public static void deployPublicationToPortal(InitParams initParams, RepositoryService repositoryService, WCMPublicationService wcmPublicationService, SessionProvider sessionProvider, String portalName) throws Exception {
        Iterator iterator = initParams.getObjectParamIterator();
        PublicationDeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (PublicationDeploymentDescriptor)objectParameter.getObject();
                List<String> contents = deploymentDescriptor.getContents();
                HashMap<String, String> context_ = new HashMap<String, String>();
                PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
                PortalContainerInfo containerInfo = (PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class);
                String containerName = containerInfo.getContainerName();
                context_.put("containerName", containerName);
                for (String sourcePath : contents) {
                    try {
                        String[] src;
                        if (portalName != null && portalName.length() > 0) {
                            sourcePath = StringUtils.replace((String)sourcePath, (String)"{portalName}", (String)portalName);
                        }
                        if ((src = sourcePath.split(":")).length == 2) {
                            ManageableRepository repository = repositoryService.getCurrentRepository();
                            Session session = sessionProvider.getSession(src[0], repository);
                            Node nodeSrc = session.getRootNode().getNode(src[1].substring(1));
                            if (publicationService.isNodeEnrolledInLifecycle(nodeSrc)) {
                                publicationService.unsubcribeLifecycle(nodeSrc);
                            }
                            wcmPublicationService.updateLifecyleOnChangeContent(nodeSrc, "default", "__system", "published");
                            nodeSrc.save();
                        }
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)(sourcePath + " has been published."));
                    }
                    catch (Exception ex) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("publication for " + sourcePath + " FAILED at " + new Date().toString() + "\n"), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("publication plugin FAILED at " + new Date().toString() + "\n"), (Throwable)ex);
            }
            throw ex;
        }
    }
}

