/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import javax.portlet.PortletMode;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.extensions.publication.impl.PublicationManagerImpl;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

public class AuthoringPublicationPlugin
extends WebpagePublicationPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)AuthoringPublicationPlugin.class.getName());
    private ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
    private ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        String versionName;
        if (node.canAddMixin("mix:versionable")) {
            node.addMixin("mix:versionable");
            node.save();
        }
        if (node.hasProperty("publication:currentState") && node.getProperty("publication:currentState").getString().equals("unpublished") && node.hasProperty("exo:titlePublished")) {
            node.setProperty("exo:titlePublished", (Value)null);
        }
        String logItemName = versionName = context.get("Publication.context.currentVersion");
        String userId = "";
        try {
            userId = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            userId = node.getSession().getUserID();
        }
        Node selectedRevision = null;
        if (node.getName().equals(versionName) || versionName == null) {
            selectedRevision = node;
            logItemName = node.getName();
        } else {
            selectedRevision = node.getVersionHistory().getVersion(versionName);
        }
        Map<String, VersionData> revisionsMap = this.getRevisionData(node);
        VersionLog versionLog = null;
        ValueFactory valueFactory = node.getSession().getValueFactory();
        String containerName = context.get("containerName");
        if (containerName == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
        }
        if ("pending".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.pending");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("approved".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.approved");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("staged".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.staged");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("enrolled".equalsIgnoreCase(newState)) {
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "Publication.log.description.enrolled");
            node.setProperty("publication:currentState", newState);
            VersionData revisionData = new VersionData(node.getUUID(), newState, userId);
            revisionsMap.put(node.getUUID(), revisionData);
            this.addRevisionData(node, revisionsMap.values());
            this.addLog(node, versionLog);
        } else if ("unpublished".equalsIgnoreCase(newState)) {
            versionLog = new VersionLog(selectedRevision.getName(), "unpublished", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.unpublished");
            VersionData selectedVersionData = revisionsMap.get(selectedRevision.getUUID());
            if (selectedVersionData != null) {
                selectedVersionData.setAuthor(userId);
                selectedVersionData.setState("unpublished");
            } else {
                selectedVersionData = new VersionData(selectedRevision.getUUID(), "unpublished", userId);
            }
            VersionData versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState("unpublished");
            } else {
                versionData = new VersionData(selectedRevision.getUUID(), "unpublished", userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            revisionsMap.put(selectedRevision.getUUID(), selectedVersionData);
            this.addLog(node, versionLog);
            if (node.hasProperty("exo:titlePublished")) {
                node.setProperty("exo:titlePublished", (Value)null);
            }
            node.setProperty("publication:currentState", "unpublished");
            Value value = valueFactory.createValue(selectedRevision);
            Value liveRevision = null;
            if (node.hasProperty("publication:liveRevision")) {
                liveRevision = node.getProperty("publication:liveRevision").getValue();
            }
            if (liveRevision != null && value.getString().equals(liveRevision.getString())) {
                node.setProperty("publication:liveRevision", (Value)null);
            }
            this.addRevisionData(node, revisionsMap.values());
        } else if ("obsolete".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(selectedRevision.getName(), newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.obsoleted");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(selectedRevision.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(selectedRevision.getUUID(), newState, userId);
            }
            revisionsMap.put(selectedRevision.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("archived".equalsIgnoreCase(newState)) {
            Value value = valueFactory.createValue(selectedRevision);
            Value liveRevision = null;
            if (node.hasProperty("publication:liveRevision")) {
                liveRevision = node.getProperty("publication:liveRevision").getValue();
            }
            if (liveRevision != null && value.getString().equals(liveRevision.getString())) {
                node.setProperty("publication:liveRevision", (Value)null);
            }
            versionLog = new VersionLog(selectedRevision.getName(), "archived", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.archived");
            VersionData versionData = revisionsMap.get(selectedRevision.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState("archived");
            } else {
                versionData = new VersionData(selectedRevision.getUUID(), "archived", userId);
            }
            revisionsMap.put(selectedRevision.getUUID(), versionData);
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "archived");
            this.addRevisionData(node, revisionsMap.values());
        } else if ("draft".equalsIgnoreCase(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.draft");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("published".equals(newState)) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            node.setProperty("publication:liveDate", (Calendar)new GregorianCalendar());
            node.save();
            Version liveVersion = node.checkin();
            node.checkout();
            Node oldLiveRevision = this.getLiveRevision(node);
            if (oldLiveRevision != null) {
                VersionData versionData = revisionsMap.get(oldLiveRevision.getUUID());
                if (versionData != null) {
                    versionData.setAuthor(userId);
                    versionData.setState("unpublished");
                } else {
                    versionData = new VersionData(oldLiveRevision.getUUID(), "unpublished", userId);
                }
                revisionsMap.put(oldLiveRevision.getUUID(), versionData);
                versionLog = new VersionLog(oldLiveRevision.getName(), "unpublished", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.unpublished");
                this.addLog(node, versionLog);
            }
            versionLog = new VersionLog(liveVersion.getName(), newState, userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.published");
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "published");
            VersionData editableRevision = revisionsMap.get(node.getUUID());
            if (editableRevision != null) {
                String lifecycleName;
                PublicationManagerImpl publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class, (String)containerName);
                LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(lifecycleName = node.getProperty("publication:lifecycle").getString());
                List<LifecyclesConfig.State> states = lifecycle.getStates();
                if (states == null || states.size() <= 0) {
                    editableRevision.setState("enrolled");
                } else {
                    editableRevision.setState(states.get(0).getState());
                }
                editableRevision.setAuthor(userId);
            } else {
                editableRevision = new VersionData(node.getUUID(), "enrolled", userId);
            }
            revisionsMap.put(node.getUUID(), editableRevision);
            versionLog = new VersionLog(node.getBaseVersion().getName(), "draft", userId, (Calendar)new GregorianCalendar(), "Publication.log.description.enrolled");
            Value liveVersionValue = valueFactory.createValue((Node)liveVersion);
            node.setProperty("publication:liveRevision", liveVersionValue);
            VersionData liveRevisionData = new VersionData(liveVersion.getUUID(), "published", userId);
            revisionsMap.put(liveVersion.getUUID(), liveRevisionData);
            this.addRevisionData(node, revisionsMap.values());
        }
        if (!IdentityConstants.SYSTEM.equals(userId)) {
            node.setProperty("publication:lastUser", userId);
        }
        if (!node.isNew()) {
            node.save();
        }
        if (!"enrolled".equalsIgnoreCase(newState)) {
            CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
            if ("true".equalsIgnoreCase(context.get("Publication.context.isInitialPhase"))) {
                this.listenerService.broadcast("PublicationService.event.postInitState", (Object)cmsService, (Object)node);
            } else {
                this.listenerService.broadcast("PublicationService.event.postChangeState", (Object)cmsService, (Object)node);
                if (this.activityService.isAcceptedNode(node)) {
                    this.listenerService.broadcast(ActivityCommonService.STATE_CHANGED_ACTIVITY, (Object)node, (Object)newState);
                }
            }
        }
        this.listenerService.broadcast("PublicationService.event.postUpdateState", null, (Object)node);
    }

    public String[] getPossibleStates() {
        return new String[]{"enrolled", "draft", "pending", "published", "obsolete"};
    }

    public String getLifecycleName() {
        return "Authoring publication";
    }

    public String getLifecycleType() {
        return "publication:authoringPublication";
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublicationContainer publicationContainer = (UIPublicationContainer)component.createUIComponent(UIPublicationContainer.class, null, null);
        publicationContainer.initContainer(node);
        return publicationContainer;
    }

    public void addMixin(Node node) throws Exception {
        node.addMixin("publication:authoringPublication");
        String nodetypes = System.getProperty("wcm.nodetypes.ignoreversion");
        if (nodetypes == null || nodetypes.length() == 0) {
            nodetypes = "exo:webContent";
        }
        if (!("nt:file".equals(node.getPrimaryNodeType().getName()) && !Utils.isMakeVersionable((Node)node, (String[])nodetypes.split(",")) || node.isNodeType("mix:versionable"))) {
            node.addMixin("mix:versionable");
        }
    }

    public boolean canAddMixin(Node node) throws Exception {
        return node.canAddMixin("publication:authoringPublication");
    }

    private void addLog(Node node, VersionLog versionLog) throws Exception {
        Value[] values = node.getProperty("publication:history").getValues();
        ValueFactory valueFactory = node.getSession().getValueFactory();
        ArrayList<Value> list = new ArrayList<Value>(Arrays.asList(values));
        list.add(valueFactory.createValue(versionLog.toString()));
        node.setProperty("publication:history", list.toArray(new Value[0]));
    }

    private void addRevisionData(Node node, Collection<VersionData> list) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        ValueFactory factory = node.getSession().getValueFactory();
        for (VersionData versionData : list) {
            valueList.add(factory.createValue(versionData.toStringValue()));
        }
        node.setProperty("publication:revisionData", valueList.toArray(new Value[0]));
    }

    private Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty("publication:revisionData").getValues()) {
                VersionData versionData = VersionData.toVersionData((String)v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser, String newState) throws Exception {
        PublicationManagerImpl publicationManagerImpl;
        LifecyclesConfig.Lifecycle lifecycle;
        List<LifecyclesConfig.State> states;
        String state = node.getProperty("publication:currentState").getString();
        if (newState == null && (states = (lifecycle = (publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class)).getLifecycle(node.getProperty("publication:lifecycle").getString())).getStates()) != null && states.size() > 0) {
            newState = states.get(0).getState();
        }
        if (state.equals(newState)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        this.changeState(node, newState, context);
    }

    private Node getLiveRevision(Node node) {
        try {
            String nodeVersionUUID;
            String string = nodeVersionUUID = node.hasProperty("publication:liveRevision") ? node.getProperty("publication:liveRevision").getString() : null;
            if (StringUtils.isEmpty((String)nodeVersionUUID) && "published".equals(node.getProperty("publication:currentState").getString())) {
                return node;
            }
            return node.getVersionHistory().getSession().getNodeByUUID(nodeVersionUUID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        String currentState = wcmPublicationService.getContentState(node);
        if ("enrolled".equals(currentState) || "unpublished".equals(currentState)) {
            return null;
        }
        if (context == null || "Edit".equals(context.get("filter-mode")) || PortletMode.EDIT.toString().equals(context.get("portlet-mode"))) {
            return node;
        }
        Node liveNode = this.getLiveRevision(node);
        if (liveNode != null) {
            if (liveNode.hasNode("jcr:frozenNode")) {
                return liveNode.getNode("jcr:frozenNode");
            }
            return liveNode;
        }
        return null;
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, remoteUser, "draft");
    }

    public List<String> getListUserNavigationUri(Page page, String remoteUser) throws Exception {
        ArrayList<String> listPageNavigationUri = new ArrayList<String>();
        for (String portalName : this.getRunningPortals(remoteUser)) {
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
            UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, remoteUser, PortalRequestContext.USER_PORTAL_CONTEXT);
            UserPortal userPortal = userPortalCfg.getUserPortal();
            List navigationList = userPortal.getNavigations();
            for (UserNavigation nav : navigationList) {
                UserNode root = userPortal.getNode(nav, Scope.ALL, null, null);
                List userNodeList = PublicationUtil.findUserNodeByPageId((UserNode)root, (String)page.getPageId());
                for (UserNode node : userNodeList) {
                    listPageNavigationUri.add(PublicationUtil.setMixedNavigationUri((String)portalName, (String)node.getURI()));
                }
            }
        }
        return listPageNavigationUri;
    }

    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        return null;
    }

    public String getUserInfo(Node node, Locale locale) throws Exception {
        return null;
    }

    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundleService bundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = bundleService.getResourceBundle("artifacts.lifecycle.stageversion.StageAndVersionPublication", locale, cl);
        String result = "";
        try {
            result = resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = key;
        }
        if (values != null) {
            return String.format(result, values);
        }
        return result;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        LazyPageList pageList = service.find(query);
        UserACL userACL = (UserACL)WCMCoreUtils.getService(UserACL.class);
        for (Object object : pageList.getAll()) {
            PortalConfig portalConfig = (PortalConfig)object;
            if (!userACL.hasPermission(portalConfig)) continue;
            listPortalName.add(portalConfig.getName());
        }
        return listPortalName;
    }
}

