/*
 * Decompiled with CFR 0.152.
 */
package exo.exoplatform.services.wcm.extensions.publication;

import exo.exoplatform.services.wcm.extensions.publication.BasePublicationTestCase;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.publication.WCMPublicationService;

public class TestPublicationManager
extends BasePublicationTestCase {
    private static final String SITE_NODE_NAME = "test";
    private static final String USER = "root";
    private static final String WORKSPACE = "collaboration";
    private static final String LANG = "en";
    private PublicationManager publicationManager;
    private WCMPublicationService publicationService;
    private Node siteNode;

    public void setUp() throws Exception {
        super.setUp();
        this.publicationManager = (PublicationManager)this.getService(PublicationManager.class);
        this.publicationService = (WCMPublicationService)this.getService(WCMPublicationService.class);
        RequestLifeCycle.begin((ExoContainer)this.getContainer());
        this.applyUserSession(USER, "gtn", WORKSPACE);
        this.startSessionAs(USER);
        Node rootSite = (Node)this.session.getItem("/sites content/live");
        this.siteNode = rootSite.addNode(SITE_NODE_NAME);
        this.siteNode.addNode("documents");
        this.session.save();
    }

    public void tearDown() throws Exception {
        if (this.siteNode != null && this.session.itemExists(this.siteNode.getPath())) {
            this.session.getItem(this.siteNode.getPath()).remove();
            this.session.save();
        }
        RequestLifeCycle.end();
        super.tearDown();
    }

    public void testFromStateParamJCRSQLInjection() throws Exception {
        String user = USER;
        Node webContentNode = this.createWebcontentNode(this.siteNode.getNode("documents"), "testcontent", "Test html", "Test css", "test js");
        this.publicationService.updateLifecyleOnChangeContent(webContentNode, SITE_NODE_NAME, user);
        TestPublicationManager.assertEquals((String)"draft", (String)this.publicationService.getContentState(webContentNode));
        String fromstate = "draft";
        List contents = this.publicationManager.getContents(fromstate, null, null, user, LANG, WORKSPACE);
        TestPublicationManager.assertNotNull((Object)contents);
        TestPublicationManager.assertEquals((int)1, (int)contents.size());
        fromstate = "draft' OR publication:currentState IS NULL OR publication:currentState = 'enrolled";
        contents = this.publicationManager.getContents(fromstate, null, null, user, LANG, WORKSPACE);
        TestPublicationManager.assertNotNull((Object)contents);
        TestPublicationManager.assertTrue((boolean)contents.isEmpty());
    }

    public void testUserParamJCRSQLInjection() throws Exception {
        String user = USER;
        Node webContentNode = this.createWebcontentNode(this.siteNode.getNode("documents"), "testcontent", "Test html", "Test css", "test js");
        this.publicationService.updateLifecyleOnChangeContent(webContentNode, SITE_NODE_NAME, user);
        TestPublicationManager.assertEquals((String)"draft", (String)this.publicationService.getContentState(webContentNode));
        String fromstate = "draft";
        List contents = this.publicationManager.getContents(fromstate, null, null, user, LANG, WORKSPACE);
        TestPublicationManager.assertNotNull((Object)contents);
        TestPublicationManager.assertEquals((int)1, (int)contents.size());
        user = "root' OR publication:lastUser IS NULL OR publication:lastUser = 'any";
        contents = this.publicationManager.getContents(fromstate, null, null, user, LANG, WORKSPACE);
        TestPublicationManager.assertNotNull((Object)contents);
        TestPublicationManager.assertTrue((boolean)contents.isEmpty());
    }

    private void startSessionAs(String user) {
        try {
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            Identity userIdentity = authenticator.createIdentity(user);
            ConversationState.setCurrent((ConversationState)new ConversationState(userIdentity));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

