/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.apache;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.LowLevelHttpRequest;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.LowLevelHttpResponse;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.apache.ApacheHttpResponse;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.apache.ContentEntity;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.util.Preconditions;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;
    private RequestConfig.Builder requestConfig;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestConfig = RequestConfig.custom().setRedirectsEnabled(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        this.requestConfig.setConnectionRequestTimeout(connectTimeout).setSocketTimeout(readTimeout);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkArgument(this.request instanceof HttpEntityEnclosingRequest, "Apache HTTP client does not support %s requests with content.", this.request.getRequestLine().getMethod());
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        }
        this.request.setConfig(this.requestConfig.build());
        return new ApacheHttpResponse(this.request, this.httpClient.execute((HttpUriRequest)this.request));
    }
}

