/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class CalendarSerializer {
    private CalendarSerializer() {
    }

    public static Calendar deserialize(String strVal) throws ParseException {
        String datePattern;
        boolean hasOffset;
        String modifiedStrVal;
        String zSuffix;
        boolean hasDot;
        boolean hasZ = strVal.indexOf(90) != -1;
        boolean bl = hasDot = strVal.indexOf(46) != -1;
        if (hasZ && hasDot) {
            zSuffix = "";
            modifiedStrVal = strVal.replace("Z", "+00:00");
        } else if (hasZ && !hasDot) {
            zSuffix = "Z";
            modifiedStrVal = strVal.replace("Z", "+0000");
        } else {
            zSuffix = "";
            modifiedStrVal = strVal;
        }
        boolean bl2 = modifiedStrVal.contains("T") ? modifiedStrVal.substring(modifiedStrVal.indexOf(84) + 1).contains("+") || modifiedStrVal.substring(modifiedStrVal.indexOf(84) + 1).contains("-") : (hasOffset = false);
        if (hasDot) {
            String offsetSuffix = modifiedStrVal.substring(modifiedStrVal.indexOf(".") + 1);
            int offsetIndex = -1;
            if (hasOffset) {
                offsetIndex = offsetSuffix.indexOf(43) != -1 ? offsetSuffix.indexOf(43) : offsetSuffix.indexOf(45);
                offsetIndex = modifiedStrVal.indexOf(46) + 1 + offsetIndex;
            }
            String milliSeconds = hasOffset ? modifiedStrVal.substring(modifiedStrVal.indexOf(46) + 1, offsetIndex) : modifiedStrVal.substring(modifiedStrVal.indexOf(46) + 1);
            int MILLIS_SEGMENT_LENGTH = 3;
            if (milliSeconds.length() > 3) {
                milliSeconds = milliSeconds.substring(0, 3);
            }
            if (hasOffset) {
                modifiedStrVal = modifiedStrVal.substring(0, modifiedStrVal.indexOf(46) + 1) + milliSeconds + modifiedStrVal.substring(offsetIndex);
                datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
            } else {
                modifiedStrVal = modifiedStrVal.substring(0, modifiedStrVal.indexOf(46) + 1) + milliSeconds;
                datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS" + zSuffix;
            }
        } else {
            datePattern = zSuffix != "" ? "yyyy-MM-dd'T'HH:mm:ss" + zSuffix : (hasOffset ? "yyyy-MM-dd'T'HH:mm:ssX" : "yyyy-MM-dd'T'HH:mm:ss");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        dateFormat.setTimeZone(TimeZone.getDefault());
        Date date = dateFormat.parse(modifiedStrVal);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String serialize(Calendar src) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.ROOT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(src.getTime());
    }
}

