/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DeviceComplianceSettingState;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceSettingStateRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionRequest;

public class DeviceComplianceSettingStateCollectionRequest
extends BaseCollectionRequest<DeviceComplianceSettingStateCollectionResponse, IDeviceComplianceSettingStateCollectionPage>
implements IDeviceComplianceSettingStateCollectionRequest {
    public DeviceComplianceSettingStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceSettingStateCollectionResponse.class, IDeviceComplianceSettingStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceSettingStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceSettingStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceSettingStateCollectionPage get() throws ClientException {
        DeviceComplianceSettingStateCollectionResponse response = (DeviceComplianceSettingStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceSettingState newDeviceComplianceSettingState, ICallback<DeviceComplianceSettingState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceSettingState, callback);
    }

    @Override
    public DeviceComplianceSettingState post(DeviceComplianceSettingState newDeviceComplianceSettingState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceSettingState);
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceComplianceSettingStateCollectionPage buildFromResponse(DeviceComplianceSettingStateCollectionResponse response) {
        DeviceComplianceSettingStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceSettingStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceSettingStateCollectionPage page = new DeviceComplianceSettingStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

