/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SecureScore;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISecureScoreCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISecureScoreCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreRequestBuilder;

public class SecureScoreCollectionRequest
extends BaseCollectionRequest<SecureScoreCollectionResponse, ISecureScoreCollectionPage>
implements ISecureScoreCollectionRequest {
    public SecureScoreCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreCollectionResponse.class, ISecureScoreCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISecureScoreCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SecureScoreCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISecureScoreCollectionPage get() throws ClientException {
        SecureScoreCollectionResponse response = (SecureScoreCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SecureScore newSecureScore, ICallback<SecureScore> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScore, callback);
    }

    @Override
    public SecureScore post(SecureScore newSecureScore) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScore);
    }

    @Override
    public ISecureScoreCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISecureScoreCollectionPage buildFromResponse(SecureScoreCollectionResponse response) {
        SecureScoreCollectionRequestBuilder builder = response.nextLink != null ? new SecureScoreCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SecureScoreCollectionPage page = new SecureScoreCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

