/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.IosManagedAppProtection;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IosManagedAppProtectionRequestBuilder;

public class IosManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<IosManagedAppProtectionCollectionResponse, IIosManagedAppProtectionCollectionPage>
implements IIosManagedAppProtectionCollectionRequest {
    public IosManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosManagedAppProtectionCollectionResponse.class, IIosManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IIosManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(IosManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIosManagedAppProtectionCollectionPage get() throws ClientException {
        IosManagedAppProtectionCollectionResponse response = (IosManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IosManagedAppProtection newIosManagedAppProtection, ICallback<IosManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIosManagedAppProtection, callback);
    }

    @Override
    public IosManagedAppProtection post(IosManagedAppProtection newIosManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIosManagedAppProtection);
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IIosManagedAppProtectionCollectionPage buildFromResponse(IosManagedAppProtectionCollectionResponse response) {
        IosManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new IosManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IosManagedAppProtectionCollectionPage page = new IosManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

