/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import java.io.IOException;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveConnector;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.ConfigurationException;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.clouddrives.onedrive.JCRLocalOneDrive;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveAPI;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveUser;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.User;
import org.exoplatform.services.cms.clouddrives.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OneDriveConnector
extends CloudDriveConnector {
    protected static final Log LOG = ExoLogger.getLogger(OneDriveConnector.class);

    public OneDriveConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
    }

    protected CloudProvider createProvider() throws ConfigurationException {
        StringBuilder authUrl = new StringBuilder("https://login.microsoftonline.com/common/oauth2/v2.0/authorize?");
        authUrl.append("response_type=code").append("&redirect_uri=").append(this.getConnectorSchema()).append("://").append(this.getConnectorHost()).append("/portal/rest/clouddrive/connect/onedrive").append("&response_mode=query").append("&prompt=select_account").append("&client_id=").append(this.getClientId()).append("&scope=").append(OneDriveAPI.SCOPES);
        return new OneDriveProvider(this.getProviderId(), this.getProviderName(), authUrl.toString(), this.getConnectorSchema() + "://" + this.getConnectorHost() + "/portal/rest/clouddrive/connect/onedrive");
    }

    protected CloudUser authenticate(Map<String, String> params) throws CloudDriveException {
        String code = params.get("code");
        String serverUrl = params.get("server-url");
        if (code != null && code.length() > 0) {
            OneDriveAPI driveAPI;
            try {
                driveAPI = new API().auth(code).serverUrl(serverUrl).build();
            }
            catch (IOException e) {
                throw new CloudDriveException("Unnable to build OneDriveAPI", (Throwable)e);
            }
            User driveAPIUser = driveAPI.getUser();
            if (driveAPIUser != null) {
                String userId = driveAPIUser.id;
                String username = driveAPIUser.userPrincipalName;
                String email = driveAPIUser.userPrincipalName;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(">> Authenticate user: {}[{}]", new Object[]{userId, username});
                }
                OneDriveUser user = new OneDriveUser(userId, username, email, this.provider, driveAPI);
                return user;
            }
            throw new CloudDriveException("API user cannot be found to authenticate with " + code);
        }
        throw new CloudDriveException("Access code should not be null or empty");
    }

    protected JCRLocalOneDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> createDrive user: {}[{}, {}] ", new Object[]{user.getId(), user.getEmail(), user.getUsername()});
        }
        return new JCRLocalOneDrive(user, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
    }

    protected OneDriveProvider getProvider() {
        return (OneDriveProvider)super.getProvider();
    }

    protected CloudDrive loadDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        try {
            return new JCRLocalOneDrive(new API(), this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable load locally connected drive at node {}", new Object[]{driveNode, e});
            }
            throw new CloudDriveException("Unable load locally connected drive");
        }
    }

    class API {
        String code;
        String refreshToken;
        String accessToken;
        long expirationTime;
        String serverUrl;

        API() {
        }

        API auth(String code) {
            this.code = code;
            return this;
        }

        API load(String refreshToken, String accessToken, long expirationTime) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
            return this;
        }

        API serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        OneDriveAPI build() throws CloudDriveException, IOException {
            if (this.code != null && this.code.length() > 0) {
                return new OneDriveAPI(OneDriveConnector.this.getClientId(), OneDriveConnector.this.getClientSecret(), this.code, OneDriveConnector.this.getConnectorSchema() + "://" + OneDriveConnector.this.getConnectorHost() + "/portal/rest/clouddrive/connect/onedrive");
            }
            return new OneDriveAPI(OneDriveConnector.this.getClientId(), OneDriveConnector.this.getClientSecret(), this.accessToken, this.refreshToken, this.expirationTime, OneDriveConnector.this.getConnectorSchema() + "://" + OneDriveConnector.this.getConnectorHost() + "/portal/rest/clouddrive/connect/onedrive");
        }
    }
}

