/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.httpcore;

import java.io.IOException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Interceptor;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Request;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Response;

public class TelemetryHandler
implements Interceptor {
    public static final String SDK_VERSION = "SdkVersion";
    public static final String VERSION = "v1.0.0";
    public static final String GRAPH_VERSION_PREFIX = "graph-java-core";
    public static final String CLIENT_REQUEST_ID = "client-request-id";

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder telemetryAddedBuilder = request.newBuilder();
        TelemetryOptions telemetryOptions = request.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
        }
        String featureUsage = "(featureUsage=" + telemetryOptions.getFeatureUsage() + ")";
        String sdkversion_value = "graph-java-core/v1.0.0 " + featureUsage;
        telemetryAddedBuilder.addHeader(SDK_VERSION, sdkversion_value);
        if (request.header(CLIENT_REQUEST_ID) == null) {
            telemetryAddedBuilder.addHeader(CLIENT_REQUEST_ID, telemetryOptions.getClientRequestId());
        }
        return chain.proceed(telemetryAddedBuilder.build());
    }
}

