/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DeviceConfigurationState;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceConfigurationStateRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceConfigurationStateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceConfigurationStateCollectionRequest;

public class DeviceConfigurationStateCollectionRequest
extends BaseCollectionRequest<DeviceConfigurationStateCollectionResponse, IDeviceConfigurationStateCollectionPage>
implements IDeviceConfigurationStateCollectionRequest {
    public DeviceConfigurationStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationStateCollectionResponse.class, IDeviceConfigurationStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceConfigurationStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceConfigurationStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationStateCollectionPage get() throws ClientException {
        DeviceConfigurationStateCollectionResponse response = (DeviceConfigurationStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationState newDeviceConfigurationState, ICallback<DeviceConfigurationState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationState, callback);
    }

    @Override
    public DeviceConfigurationState post(DeviceConfigurationState newDeviceConfigurationState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationState);
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceConfigurationStateCollectionPage buildFromResponse(DeviceConfigurationStateCollectionResponse response) {
        DeviceConfigurationStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationStateCollectionPage page = new DeviceConfigurationStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

