/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SchemaExtension;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISchemaExtensionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISchemaExtensionCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SchemaExtensionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SchemaExtensionCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SchemaExtensionCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SchemaExtensionRequestBuilder;

public class SchemaExtensionCollectionRequest
extends BaseCollectionRequest<SchemaExtensionCollectionResponse, ISchemaExtensionCollectionPage>
implements ISchemaExtensionCollectionRequest {
    public SchemaExtensionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SchemaExtensionCollectionResponse.class, ISchemaExtensionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISchemaExtensionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SchemaExtensionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISchemaExtensionCollectionPage get() throws ClientException {
        SchemaExtensionCollectionResponse response = (SchemaExtensionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SchemaExtension newSchemaExtension, ICallback<SchemaExtension> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSchemaExtension, callback);
    }

    @Override
    public SchemaExtension post(SchemaExtension newSchemaExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSchemaExtension);
    }

    @Override
    public ISchemaExtensionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISchemaExtensionCollectionPage buildFromResponse(SchemaExtensionCollectionResponse response) {
        SchemaExtensionCollectionRequestBuilder builder = response.nextLink != null ? new SchemaExtensionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SchemaExtensionCollectionPage page = new SchemaExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

