/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.pdfviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.icepdf.core.pobjects.Document;

public class PDFViewerService {
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerService.class.getName());
    private static final int MAX_NAME_LENGTH = 150;
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    public static final long DEFAULT_MAX_PAGES = 99L;
    public static final String MAX_FILE_SIZE_PARAM_NAME = "maxFileSize";
    public static final String MAX_PAGES_PARAM_NAME = "maxPages";
    private static final String CACHE_NAME = "ecms.PDFViewerService";
    private JodConverterService jodConverter_;
    private ExoCache<Serializable, Object> pdfCache;
    private long maxFileSize;
    private long maxPages;

    public PDFViewerService(RepositoryService repositoryService, CacheService caService, JodConverterService jodConverter, InitParams initParams) throws Exception {
        this.jodConverter_ = jodConverter;
        this.pdfCache = caService.getCacheInstance(CACHE_NAME);
        this.maxFileSize = 0xA00000L;
        this.maxPages = 99L;
        if (initParams != null) {
            ValueParam maxPagesValueParam;
            ValueParam maxFileSizeValueParam = initParams.getValueParam(MAX_FILE_SIZE_PARAM_NAME);
            if (maxFileSizeValueParam != null) {
                try {
                    this.maxFileSize = Long.parseLong(maxFileSizeValueParam.getValue()) * 1024L * 1024L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Parameter maxFileSize for document preview is not a valid number (" + maxFileSizeValueParam.getValue() + "), default value will be used (" + 0xA00000L + ")"));
                }
            }
            if ((maxPagesValueParam = initParams.getValueParam(MAX_PAGES_PARAM_NAME)) != null) {
                try {
                    this.maxPages = Long.parseLong(maxPagesValueParam.getValue());
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Parameter maxPages for document preview is not a valid number (" + maxPagesValueParam.getValue() + "), default value will be used (" + MAX_PAGES_PARAM_NAME + ")"));
                }
            }
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxPages() {
        return this.maxPages;
    }

    public ExoCache<Serializable, Object> getCache() {
        return this.pdfCache;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    public Document buildDocumentImage(File input, String name) {
        Document document = new Document();
        Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
        if (input == null) {
            return null;
        }
        try {
            name = this.reduceFileNameSize(name);
            FileInputStream fis = new FileInputStream(input);
            document.setInputStream((InputStream)new BufferedInputStream(fis), name);
            return document;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to build Document image from pdf file " + name));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        wsName = currentNode.getSession().getWorkspace().getName();
        uuid = currentNode.getUUID();
        bd = new StringBuilder();
        bd1 = new StringBuilder();
        bd2 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        bd1.append((CharSequence)bd).append("/jcr:lastModified");
        bd2.append((CharSequence)bd).append("/jcr:baseVersion");
        path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        lastModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        cachedBaseVersion = (String)this.pdfCache.get((Serializable)new ObjectKey(bd2.toString()));
        content = null;
        name = currentNode.getName().replaceAll(":", "_");
        contentNode = currentNode.getNode("jcr:content");
        lastModified = Utils.getJcrContentLastModified(currentNode);
        baseVersion = Utils.getJcrContentBaseVersion(currentNode);
        if (!(path != null && (content = new File(path)).exists() && lastModified.equals(lastModifiedTime) && StringUtils.equals((String)baseVersion, (String)cachedBaseVersion))) {
            mimeType = contentNode.getProperty("jcr:mimeType").getString();
            input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = this.reduceFileNameSize(name);
            content = File.createTempFile(name + "_tmp", ".pdf");
            extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            } else {
                in = File.createTempFile(name + "_tmp", "." + extension);
                this.read(input, new BufferedOutputStream(new FileOutputStream(in)));
                fileSize = in.length();
                if (PDFViewerService.LOG.isDebugEnabled()) {
                    PDFViewerService.LOG.debug((Object)("File '" + currentNode.getPath() + "' of " + fileSize + " B. Size limit for preview: " + this.getMaxFileSize() / 0x100000L + " MB"));
                }
                if (fileSize <= this.getMaxFileSize()) {
                    try {
                        success = this.jodConverter_.convert(in, content, "pdf");
                        if (success) ** GOTO lbl61
                        content.delete();
                        content = null;
                    }
                    catch (OfficeException connection) {
                        content.delete();
                        content = null;
                        if (!PDFViewerService.LOG.isErrorEnabled()) ** GOTO lbl61
                        PDFViewerService.LOG.error((Object)"Exception when using Office Service", (Throwable)connection);
                    }
                    finally {
                        in.delete();
                    }
                } else {
                    PDFViewerService.LOG.info((Object)("File '" + currentNode.getPath() + "' is too big for preview."));
                    content.delete();
                    content = null;
                    in.delete();
                }
            }
lbl61:
            // 6 sources

            if (content != null && content.exists()) {
                if (contentNode.hasProperty("jcr:lastModified")) {
                    this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                    this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
                }
                this.pdfCache.put((Serializable)new ObjectKey(bd2.toString()), (Object)baseVersion);
            }
        }
        return content;
    }

    private String reduceFileNameSize(String name) {
        return name != null && name.length() > 150 ? name.substring(0, 150) : name;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }
}

