/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.clouddrives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.ecm.connector.clouddrives.AcceptedCloudFile;
import org.exoplatform.ecm.connector.clouddrives.DriveInfo;
import org.exoplatform.ecm.connector.clouddrives.ErrorEntiry;
import org.exoplatform.ecm.connector.clouddrives.LinkedCloudFile;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveMessage;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.LocalCloudFile;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotConnectedException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/drive")
@Produces(value={"application/json"})
public class DriveService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(DriveService.class);
    protected static final String CONTENT_SUFIX = "/jcr:content";
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;

    public DriveService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @GET
    @RolesAllowed(value={"users"})
    public Response getDrive(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                Locale locale = request.getLocale();
                return this.readDrive(workspace, path, locale, false);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null path")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null workspace")).build();
    }

    @POST
    @Path(value="/synchronize/")
    @RolesAllowed(value={"users"})
    public Response synchronize(@Context HttpServletRequest request, @Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                Locale locale = request.getLocale();
                return this.readDrive(workspace, path, locale, true);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    protected Response readDrive(String workspace, String path, Locale locale, boolean synchronize) {
        try {
            CloudDrive local = this.cloudDrives.findDrive(workspace, path);
            if (local != null) {
                List<CloudDriveMessage> messages;
                List<String> removed;
                ArrayList<CloudFile> files;
                block27: {
                    if (synchronize) {
                        try {
                            CloudDrive.Command sync = local.synchronize();
                            sync.await();
                            files = sync.getFiles();
                            this.initModified(files, locale);
                            removed = sync.getRemoved();
                            messages = sync.getMessages();
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)"Caller of synchronization command interrupted.", (Throwable)e);
                            Thread.currentThread().interrupt();
                            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)ErrorEntiry.message("Synchrinization interrupted. Try again later.")).build();
                        }
                        catch (ExecutionException e) {
                            Throwable err = e.getCause();
                            if (err instanceof RefreshAccessException) {
                                LOG.warn("Synchronization failed, need refresh access to cloud drive for {}. {}", new Object[]{local.getUser().getId(), err.getMessage() + (err.getCause() != null ? ". " + err.getCause().getMessage() : "")});
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                            }
                            if (err instanceof NotConnectedException) {
                                LOG.warn((Object)("Cannot synchronize not connected drive. " + err.getMessage()), err);
                                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.notCloudDrive("Drive not connected", workspace, path)).build();
                            }
                            if (err instanceof CloudDriveException) {
                                LOG.error((Object)("Error synchrinizing the drive. " + err.getMessage()), err);
                                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error synchrinizing the drive. Try again later.")).build();
                            }
                            if (err instanceof AccessDeniedException) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Not sufficient permissions. " + err.getMessage()));
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorEntiry.acessDenied("Access denied. Synchronization canceled.")).build();
                            }
                            if (err instanceof RepositoryException) {
                                LOG.error((Object)("Storage error. " + err.getMessage()), err);
                                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Storage error. Synchronization canceled.")).build();
                            }
                            if (err instanceof RuntimeException) {
                                LOG.error((Object)("Runtime error. " + err.getMessage()), err);
                                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Internal server error. Synchronization canceled. Try again later.")).build();
                            }
                            LOG.error((Object)("Unexpected error. " + err.getMessage()), err);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Unexpected server error. Synchronization canceled. Try again later.")).build();
                        }
                        catch (RefreshAccessException e) {
                            LOG.warn("Synchronization cannot start, need refresh access to cloud drive for {}. {}", new Object[]{local.getUser().getId(), e.getMessage() + (e.getCause() != null ? ". " + e.getCause().getMessage() : "")});
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        catch (CloudDriveException e) {
                            LOG.error((Object)("Error synchronizing drive " + workspace + ":" + path), (Throwable)e);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error synchronizing drive. " + e.getMessage())).build();
                        }
                    }
                    files = new ArrayList();
                    removed = Collections.emptyList();
                    messages = Collections.emptyList();
                    try {
                        if (!local.getPath().equals(path)) {
                            CloudFile file = local.getFile(path);
                            files.add(file);
                            if (!file.getPath().equals(path)) {
                                files.add((CloudFile)new LinkedCloudFile(file, path));
                            }
                            this.initModified(file, locale);
                        }
                    }
                    catch (NotYetCloudFileException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Item " + workspace + ":" + path + " not yet a cloud file : " + e.getMessage()));
                        }
                        files.add(new AcceptedCloudFile(path));
                    }
                    catch (NotCloudFileException e) {
                        if (!LOG.isDebugEnabled()) break block27;
                        LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file : " + e.getMessage()));
                    }
                }
                return Response.ok().entity((Object)DriveInfo.create(workspace, local, files, removed, messages)).build();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudDrive("Not connected", workspace, path)).build();
        }
        catch (LoginException e) {
            LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorEntiry.message("Authentication error")).build();
        }
        catch (DriveRemovedException e) {
            LOG.error((Object)("Drive removed " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.driveRemoved("Drive removed", workspace, path)).build();
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)("Error reading file " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.nodeNotFound("File was removed or renamed", workspace, path)).build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error reading drive: storage error")).build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error reading drive: runtime error")).build();
        }
    }

    @GET
    @Path(value="/file/")
    @RolesAllowed(value={"users"})
    public Response getFile(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    Locale locale = request.getLocale();
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            Object file = local.getFile(path);
                            if (!file.getPath().equals(path)) {
                                file = new LinkedCloudFile((CloudFile)file, path);
                            }
                            this.initModified((CloudFile)file, locale);
                            return Response.ok().entity(file).build();
                        }
                        catch (NotYetCloudFileException e) {
                            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new AcceptedCloudFile(path)).build();
                        }
                        catch (NotCloudFileException e) {
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudFile(e.getMessage(), workspace, path)).build();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudDrive("Not a cloud file or drive not connected", workspace, path)).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive file " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorEntiry.message("Authentication error")).build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Error reading file. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error reading file: storage error.")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntiry.message("Error reading file: runtime error.")).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null path")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null workspace")).build();
    }

    @GET
    @Path(value="/files/")
    @RolesAllowed(value={"users"})
    public Response getFiles(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    Locale locale = request.getLocale();
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        String parentPath;
                        if (local.getPath().equals(path)) {
                            parentPath = path;
                        } else {
                            try {
                                parentPath = local.getFile(path).getPath();
                            }
                            catch (NotYetCloudFileException e) {
                                parentPath = path;
                            }
                        }
                        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
                        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
                        Node parentNode = (Node)userSession.getItem(parentPath);
                        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
                        boolean hasAccepted = false;
                        NodeIterator childs = parentNode.getNodes();
                        while (childs.hasNext()) {
                            Node fileNode = childs.nextNode();
                            String filePath = fileNode.getPath();
                            try {
                                Object file = local.getFile(filePath);
                                if (file == null) continue;
                                if (!file.getPath().equals(filePath)) {
                                    file = new LinkedCloudFile((CloudFile)file, filePath);
                                }
                                this.initModified((CloudFile)file, locale);
                                files.add((CloudFile)file);
                            }
                            catch (NotYetCloudFileException e) {
                                hasAccepted = true;
                                files.add(new AcceptedCloudFile(filePath));
                            }
                        }
                        Response.ResponseBuilder resp = hasAccepted ? Response.status((Response.Status)Response.Status.ACCEPTED) : Response.ok();
                        return resp.entity(files).build();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudDrive("Not connected", workspace, path)).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive files in " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading files in " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading files. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading files in " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading files: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading files in " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null path")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null workspace")).build();
    }

    @GET
    @Path(value="/state/")
    @RolesAllowed(value={"users"})
    public Response getState(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        try {
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)local.getState()).build();
                        }
                        catch (RefreshAccessException e) {
                            Throwable cause = e.getCause();
                            LOG.warn((Object)("Access to cloud drive expired, forbidden or revoked. " + e.getMessage() + (cause != null ? ". " + cause.getMessage() : "")));
                            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                        }
                        catch (CloudDriveException e) {
                            LOG.error((Object)("Error getting changes link for drive " + workspace + ":" + path), (Throwable)e);
                            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting changes link. " + e.getMessage())).build();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorEntiry.notCloudDrive("Not connected", workspace, path)).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null path")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorEntiry.message("Null workspace")).build();
    }

    private void initModified(Collection<CloudFile> files, Locale locale) {
        for (CloudFile file : files) {
            this.initModified(file, locale);
        }
    }

    private void initModified(CloudFile file, Locale locale) {
        if (file.isConnected()) {
            try {
                ((LocalCloudFile)LocalCloudFile.class.cast(file)).initModified(locale);
            }
            catch (ClassCastException e) {
                LOG.warn("Cannot initialize cloud file modified field for {} due to error: {}", new Object[]{file.getPath(), e.getMessage()});
            }
        }
    }
}

