/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.views.UITabForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewList;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

public class UIViewForm
extends UIForm
implements UISelectable {
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_NAME = "viewName";
    public static final String FIELD_TABS = "tabs";
    public static final String FIELD_TEMPLATE = "template";
    public static final String FIELD_ENABLEVERSION = "enableVersion";
    public static final String FIELD_PERMISSION = "permission";
    public static final String FIELD_HIDE_EXPLORER_PANEL = "hideExplorerPanel";
    private boolean isView_ = true;
    private NodeLocation views_;
    private HashMap<String, ViewConfig.Tab> tabMap_ = new HashMap();
    private ManageViewService vservice_ = null;
    private String viewName_ = null;
    private String permission = "";
    private List<String> listVersion = new ArrayList<String>();
    private String baseVersionName_;
    private VersionNode selectedVersion_;
    private VersionNode rootVersionNode;
    Map<String, String> templateMap = new HashMap<String, String>();
    Map<String, String> tempMap = new HashMap<String, String>();

    public String getViewName() {
        return this.viewName_;
    }

    public void setViewName(String viewName) {
        this.viewName_ = viewName;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getActions() {
        return new String[0];
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public UIViewForm() throws Exception {
        this("UIViewForm");
    }

    public UIViewForm(String name) throws Exception {
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_VERSION, FIELD_VERSION, options);
        versions.setOnChange("ChangeVersion");
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        this.vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        Node ecmTemplateHome = this.vservice_.getTemplateHome("ecmExplorerTemplates", WCMCoreUtils.getSystemSessionProvider());
        ArrayList<SelectItemOption> temp = new ArrayList<SelectItemOption>();
        if (ecmTemplateHome != null) {
            NodeIterator iter = ecmTemplateHome.getNodes();
            while (iter.hasNext()) {
                Node tempNode = iter.nextNode();
                temp.add(new SelectItemOption(tempNode.getName(), (Object)tempNode.getName()));
                this.templateMap.put(tempNode.getName(), tempNode.getPath());
                this.tempMap.put(tempNode.getPath(), tempNode.getName());
            }
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TEMPLATE, FIELD_TEMPLATE, temp));
        UICheckBoxInput enableVersion = new UICheckBoxInput(FIELD_ENABLEVERSION, FIELD_ENABLEVERSION, null);
        enableVersion.setRendered(true);
        this.addUIFormInput((UIFormInput)enableVersion);
        UICheckBoxInput hideExplorerPanel = new UICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL, FIELD_HIDE_EXPLORER_PANEL, Boolean.valueOf(false));
        hideExplorerPanel.setRendered(false);
        this.addUIFormInput((UIFormInput)hideExplorerPanel);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void doSelect(String selectField, Object value) {
        UIFormStringInput uiStringInput = this.getUIStringInput(selectField);
        uiStringInput.setValue((Object)value.toString());
    }

    public boolean isView() {
        return this.isView_;
    }

    public Node getViews() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.views_);
    }

    public boolean canEnableVersionning(Node node) throws Exception {
        return node.canAddMixin("mix:versionable");
    }

    private boolean isVersioned(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        if (vH != null) {
            return new VersionNode((Node)vH.getRootVersion(), node.getSession());
        }
        return null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (VersionNode vNode : children) {
            this.listVersion.add(vNode.getName());
            child = vNode.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List<String> versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt(versionList.get(j)) >= Integer.parseInt(versionList.get(i))) continue;
                String temp = versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(versionList.get(i), (Object)versionList.get(i)));
        }
        return options;
    }

    public HashMap<String, ViewConfig.Tab> getTabMap() {
        return this.tabMap_;
    }

    public void addTab(String tabName, String buttons) {
        ViewConfig.Tab tab = new ViewConfig.Tab();
        tab.setTabName(tabName);
        tab.setButtons(buttons);
        tab.setLocalizeButtons(this.getLocalizationButtons(buttons));
        this.tabMap_.put(tabName, tab);
    }

    public String getLocalizationButtons(String buttons) {
        StringBuilder localizationButtons = new StringBuilder();
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        if (buttons.contains(";")) {
            String[] arrButtons = buttons.split(";");
            for (int i = 0; i < arrButtons.length; ++i) {
                try {
                    localizationButtons.append(res.getString("UITabForm.label." + arrButtons[i].trim()));
                }
                catch (MissingResourceException mre) {
                    localizationButtons.append(arrButtons[i]);
                }
                if (i >= arrButtons.length - 1) continue;
                localizationButtons.append(", ");
            }
        } else {
            try {
                localizationButtons.append(res.getString("UITabForm.label." + buttons.trim()));
            }
            catch (MissingResourceException mre) {
                localizationButtons.append(buttons.trim());
            }
        }
        return localizationButtons.toString();
    }

    public String getTabList() throws Exception {
        StringBuilder result = new StringBuilder();
        ArrayList<ViewConfig.Tab> tabList = new ArrayList<ViewConfig.Tab>(this.tabMap_.values());
        if (result != null) {
            for (ViewConfig.Tab tab : tabList) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(tab.getTabName());
            }
        }
        return result.toString();
    }

    public List<ViewConfig.Tab> getTabs() throws Exception {
        return new ArrayList<ViewConfig.Tab>(this.tabMap_.values());
    }

    public void refresh(boolean isAddNew) throws Exception {
        this.getUIFormSelectBox(FIELD_VERSION).setRendered(!isAddNew);
        this.getUIFormSelectBox(FIELD_VERSION).setDisabled(!isAddNew);
        this.getUIStringInput(FIELD_NAME).setDisabled(!isAddNew).setValue(null);
        this.getUIFormSelectBox(FIELD_TEMPLATE).setValue(null);
        this.getUIFormSelectBox(FIELD_TEMPLATE).setDisabled(!isAddNew);
        this.getUICheckBoxInput(FIELD_ENABLEVERSION).setRendered(!isAddNew);
        this.getUICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL).setRendered(!isAddNew);
        this.setViewName("");
        if (isAddNew) {
            this.tabMap_.clear();
            this.views_ = null;
            this.getUICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL).setValue(Boolean.valueOf(false));
        }
        this.selectedVersion_ = null;
        this.baseVersionName_ = null;
    }

    public void update(Node viewNode, boolean isView, VersionNode selectedVersion) throws Exception {
        this.isView_ = isView;
        if (viewNode != null) {
            this.setPermission(viewNode.getProperty("exo:accessPermissions").getString());
            this.views_ = NodeLocation.getNodeLocationByNode((Node)viewNode);
            if (this.isVersioned(viewNode)) {
                this.baseVersionName_ = viewNode.getBaseVersion().getName();
            }
            this.tabMap_.clear();
            NodeIterator iter = viewNode.getNodes();
            while (iter.hasNext()) {
                Node tab = iter.nextNode();
                String buttons = tab.getProperty("exo:buttons").getString();
                ViewConfig.Tab tabObj = new ViewConfig.Tab();
                tabObj.setTabName(tab.getName());
                tabObj.setButtons(buttons);
                tabObj.setLocalizeButtons(this.getLocalizationButtons(buttons));
                this.tabMap_.put(tab.getName(), tabObj);
            }
            this.getUICheckBoxInput(FIELD_ENABLEVERSION).setRendered(true);
            if (this.isVersioned(viewNode)) {
                this.rootVersionNode = this.getRootVersion(viewNode);
                this.getUIFormSelectBox(FIELD_VERSION).setOptions(this.getVersionValues(viewNode)).setRendered(true);
                this.getUIFormSelectBox(FIELD_VERSION).setValue(this.baseVersionName_);
                this.getUICheckBoxInput(FIELD_ENABLEVERSION).setChecked(true);
                this.getUICheckBoxInput(FIELD_ENABLEVERSION).setDisabled(false);
            } else if (!this.isVersioned(viewNode)) {
                this.getUIFormSelectBox(FIELD_VERSION).setRendered(false);
                this.getUICheckBoxInput(FIELD_ENABLEVERSION).setChecked(false);
                this.getUICheckBoxInput(FIELD_ENABLEVERSION).setDisabled(false);
            }
            this.getUICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL).setRendered(true);
            this.getUICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL).setValue(Boolean.valueOf(viewNode.getProperty("exo:hideExplorerPanel").getBoolean()));
        }
        Node viewsNode = NodeLocation.getNodeByLocation((NodeLocation)this.views_);
        if (selectedVersion != null) {
            viewsNode.restore(selectedVersion.getName(), false);
            viewsNode.checkout();
            this.tabMap_.clear();
            NodeIterator iter = viewsNode.getNodes();
            while (iter.hasNext()) {
                Node tab = iter.nextNode();
                String buttons = tab.getProperty("exo:buttons").getString();
                ViewConfig.Tab tabObj = new ViewConfig.Tab();
                tabObj.setTabName(tab.getName());
                tabObj.setButtons(buttons);
                this.tabMap_.put(tab.getName(), tabObj);
            }
            this.selectedVersion_ = selectedVersion;
        }
        if (viewsNode != null) {
            this.getUIStringInput(FIELD_NAME).setDisabled(true).setValue((Object)viewsNode.getName());
            this.getUIFormSelectBox(FIELD_TEMPLATE).setValue(this.tempMap.get(viewsNode.getProperty("exo:template").getString()));
        }
    }

    public void save() throws Exception {
        NodeIterator iter;
        String viewName = (String)this.getUIStringInput(FIELD_NAME).getValue();
        if (viewName == null || viewName.trim().length() == 0) {
            throw new MessageException(new ApplicationMessage("UIViewForm.msg.view-name-invalid", null, 1));
        }
        viewName = viewName.trim();
        boolean isEnableVersioning = this.getUICheckBoxInput(FIELD_ENABLEVERSION).isChecked();
        boolean hideExplorerPanel = this.getUICheckBoxInput(FIELD_HIDE_EXPLORER_PANEL).isChecked();
        List viewList = this.vservice_.getAllViews();
        UIPopupWindow uiPopup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
        uiPopup.setShowMask(true);
        if (uiPopup.getId().equals("AddPopup")) {
            for (ViewConfig view : viewList) {
                if (!view.getName().equals(viewName) || isEnableVersioning) continue;
                ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.view-exist", null, 1);
                throw new MessageException(message);
            }
        }
        if (this.tabMap_.size() < 1) {
            ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.mustbe-add-tab", null, 1);
            throw new MessageException(message);
        }
        if (this.permission == null || this.permission.length() == 0) {
            ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.mustbe-add-permission", null, 1);
            throw new MessageException(message);
        }
        String template = this.templateMap.get(this.getUIFormSelectBox(FIELD_TEMPLATE).getValue());
        ArrayList<ViewConfig.Tab> tabList = new ArrayList<ViewConfig.Tab>(this.tabMap_.values());
        Node viewNode = NodeLocation.getNodeByLocation((NodeLocation)this.views_);
        if (this.views_ == null || !isEnableVersioning) {
            this.vservice_.addView(viewName, this.permission, hideExplorerPanel, template, tabList);
            if (viewNode != null) {
                iter = viewNode.getNodes();
                while (iter.hasNext()) {
                    Node tab = iter.nextNode();
                    if (this.tabMap_.containsKey(tab.getName())) continue;
                    tab.remove();
                }
                viewNode.save();
            }
        } else {
            if (!this.isVersioned(viewNode)) {
                viewNode.addMixin("mix:versionable");
                viewNode.save();
            } else {
                viewNode.checkout();
            }
            iter = viewNode.getNodes();
            while (iter.hasNext()) {
                Node tab = iter.nextNode();
                if (this.tabMap_.containsKey(tab.getName())) continue;
                tab.remove();
            }
            this.vservice_.addView(viewName, this.permission, hideExplorerPanel, template, tabList);
            try {
                viewNode.save();
                viewNode.checkin();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
        UIViewList uiViewList = (UIViewList)((UIViewContainer)this.getAncestorOfType(UIViewContainer.class)).getChild(UIViewList.class);
        uiViewList.refresh(uiViewList.getUIPageIterator().getCurrentPage());
        this.refresh(true);
    }

    public void editTab(String tabName) throws Exception {
        UIViewFormTabPane viewTabPane = (UIViewFormTabPane)this.getParent();
        UITabForm tabForm = (UITabForm)viewTabPane.getChild(UITabForm.class);
        tabForm.update(this.tabMap_.get(tabName), this.isView_);
        viewTabPane.setSelectedTab(tabForm.getId());
    }

    public void deleteTab(String tabName) throws Exception {
        UIViewFormTabPane viewTabPane = (UIViewFormTabPane)this.getParent();
        this.tabMap_.remove(tabName);
        this.update(null, false, null);
        UIViewContainer uiViewContainer = (UIViewContainer)this.getAncestorOfType(UIViewContainer.class);
        UIViewList uiViewList = (UIViewList)uiViewContainer.getChild(UIViewList.class);
        uiViewList.refresh(uiViewList.getUIPageIterator().getCurrentPage());
        UIViewForm uiViewForm = (UIViewForm)viewTabPane.getChild(UIViewForm.class);
        viewTabPane.setSelectedTab(uiViewForm.getId());
    }

    public void changeVersion() throws Exception {
        String path = NodeLocation.getNodeByLocation((NodeLocation)this.views_).getVersionHistory().getVersion((String)this.getUIFormSelectBox(FIELD_VERSION).getValue()).getPath();
        VersionNode selectedVesion = this.rootVersionNode.findVersionNode(path);
        this.update(null, false, selectedVesion);
    }

    public void revertVersion() throws Exception {
        if (this.selectedVersion_ != null && !this.selectedVersion_.getName().equals(this.baseVersionName_)) {
            NodeLocation.getNodeByLocation((NodeLocation)this.views_).restore(this.baseVersionName_, true);
        }
    }

    public static class ChangeVersionActionListener
    extends EventListener<UIViewForm> {
        public void execute(Event<UIViewForm> event) throws Exception {
            UIViewFormTabPane uiFormTab = (UIViewFormTabPane)((UIViewForm)((Object)event.getSource())).getParent();
            UIViewForm uiForm = (UIViewForm)uiFormTab.getChild(UIViewForm.class);
            uiForm.changeVersion();
            UIViewContainer uiViewContainer = (UIViewContainer)uiFormTab.getAncestorOfType(UIViewContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }
}

