/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.admin.script.UIECMFilterForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIECMScripts
extends UIContainer {
    public static String SCRIPTLIST_NAME = "ecmScriptList";
    public static String SCRIPTFORM_NAME = "ecmScriptForm";
    public static String SCRIPT_PAGE = "PageIterator";

    public UIECMScripts() throws Exception {
        this.addChild(UIECMFilterForm.class, null, null);
        UIScriptList list = (UIScriptList)this.addChild(UIScriptList.class, null, SCRIPTLIST_NAME);
        list.getUIPageIterator().setId(SCRIPTLIST_NAME + SCRIPT_PAGE);
    }

    private List<SelectItemOption<String>> getECMCategoryOptions() throws Exception {
        ArrayList<SelectItemOption<String>> ecmOptions = new ArrayList<SelectItemOption<String>>();
        Node ecmScriptHome = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMScriptHome(WCMCoreUtils.getSystemSessionProvider());
        NodeIterator categories = ecmScriptHome.getNodes();
        while (categories.hasNext()) {
            Node script = categories.nextNode();
            ecmOptions.add((SelectItemOption<String>)new SelectItemOption(script.getName(), (Object)script.getName()));
        }
        return ecmOptions;
    }

    public void refresh(int currentPage) throws Exception {
        UIECMFilterForm ecmFilterForm = (UIECMFilterForm)this.getChild(UIECMFilterForm.class);
        String categoryName = (String)ecmFilterForm.getUIFormSelectBox("selectScript").getValue();
        if (categoryName == null) {
            ecmFilterForm.setOptions(this.getECMCategoryOptions());
            categoryName = (String)ecmFilterForm.getUIFormSelectBox("selectScript").getValue();
        }
        UIScriptList uiScriptList = (UIScriptList)this.getChildById(SCRIPTLIST_NAME);
        uiScriptList.updateGrid(this.getECMScript(categoryName), currentPage);
    }

    public List<UIScriptList.ScriptData> getECMScript(String name) throws Exception {
        ArrayList<UIScriptList.ScriptData> scriptData = new ArrayList<UIScriptList.ScriptData>();
        List scripts = new ArrayList();
        if (name.equals("action")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMActionScripts(WCMCoreUtils.getSystemSessionProvider());
        } else if (name.equals("widget")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMWidgetScripts(WCMCoreUtils.getSystemSessionProvider());
        } else if (name.equals("interceptor")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMInterceptorScripts(WCMCoreUtils.getSystemSessionProvider());
        }
        for (Node scriptNode : scripts) {
            String version = "";
            if (scriptNode.isNodeType("mix:versionable") && !scriptNode.isNodeType("nt:frozenNode")) {
                version = scriptNode.getBaseVersion().getName();
            }
            scriptData.add(new UIScriptList.ScriptData(scriptNode.getName(), scriptNode.getPath(), version));
        }
        return scriptData;
    }

    public void initFormPopup(String id) throws Exception {
        this.removeChildById(id);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 250);
        UIScriptForm uiForm = (UIScriptForm)this.createUIComponent(UIScriptForm.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }
}

