/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.document.service;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.picocontainer.Startable;

public class ShareDocumentService
implements IShareDocumentService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ShareDocumentService.class);
    public static final String MIX_PRIVILEGEABLE = "exo:privilegeable";
    private static final boolean POST_ACTIVITY = true;
    private RepositoryService repoService;
    private SessionProviderService sessionProviderService;
    private LinkManager linkManager;

    public ShareDocumentService(RepositoryService _repoService, LinkManager _linkManager, SessionProviderService _sessionProviderService) {
        this.repoService = _repoService;
        this.sessionProviderService = _sessionProviderService;
        this.linkManager = _linkManager;
    }

    @Override
    public String publishDocumentToSpace(String space, Node currentNode, String comment, String perm) {
        return this.publishDocumentToSpace(space, currentNode, comment, perm, true);
    }

    @Override
    public String publishDocumentToSpace(String space, Node currentNode, String comment, String perm, Boolean postActivity) {
        block13: {
            Node rootSpace = null;
            Node shared = null;
            try {
                String tempPerms;
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                nodeCreator.getJcrPath("groupsPath");
                rootSpace = (Node)session.getItem(nodeCreator.getJcrPath("groupsPath") + space);
                rootSpace = rootSpace.getNode("Documents");
                shared = !rootSpace.hasNode("Shared") ? rootSpace.addNode("Shared") : rootSpace.getNode("Shared");
                if (currentNode.isNodeType("exo:symlink")) {
                    currentNode = this.linkManager.getTarget(currentNode);
                }
                if (!(tempPerms = perm.toString()).equals("read")) {
                    tempPerms = "read,add_node,set_property,remove";
                }
                if (PermissionUtil.canChangePermission((Node)currentNode)) {
                    this.setSpacePermission(currentNode, space, tempPerms.split(","));
                } else if (PermissionUtil.canRead((Node)currentNode)) {
                    SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                    Node _node = (Node)systemSession.getItem(currentNode.getPath());
                    this.setSpacePermission(_node, space, tempPerms.split(","));
                }
                currentNode.getSession().save();
                Node link = this.linkManager.createLink(shared, currentNode);
                String nodeMimeType = Utils.getMimeType(currentNode);
                link.addMixin("mix:fileType");
                link.setProperty("exo:fileType", nodeMimeType);
                rootSpace.save();
                if (postActivity.booleanValue()) {
                    try {
                        ExoSocialActivity activity = null;
                        activity = currentNode.getPrimaryNodeType().getName().equals("nt:file") ? Utils.createShareActivity(link, "", "sharefiles:spaces", comment, perm) : Utils.createShareActivity(link, "", "sharecontents:spaces", comment, perm);
                        link.save();
                        return activity.getId();
                    }
                    catch (Exception e1) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public void publishDocumentToUser(String user, Node currentNode, String comment, String perm) {
        block9: {
            Node userPrivateNode = null;
            Node shared = null;
            try {
                String tempPerms;
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                userPrivateNode = this.getPrivateUserNode(sessionProvider, user);
                userPrivateNode = userPrivateNode.getNode("Documents");
                shared = !userPrivateNode.hasNode("Shared") ? userPrivateNode.addNode("Shared") : userPrivateNode.getNode("Shared");
                if (currentNode.isNodeType("exo:symlink")) {
                    currentNode = this.linkManager.getTarget(currentNode);
                }
                if (!(tempPerms = perm.toString()).equals("read")) {
                    tempPerms = "read,add_node,set_property,remove";
                }
                if (PermissionUtil.canChangePermission((Node)currentNode)) {
                    this.setUserPermission(currentNode, user, tempPerms.split(","));
                } else if (PermissionUtil.canRead((Node)currentNode)) {
                    SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                    Node _node = (Node)systemSession.getItem(currentNode.getPath());
                    this.setUserPermission(_node, user, tempPerms.split(","));
                }
                currentNode.getSession().save();
                Node link = this.linkManager.createLink(shared, currentNode);
                String nodeMimeType = Utils.getMimeType(currentNode);
                link.addMixin("mix:fileType");
                link.setProperty("exo:fileType", nodeMimeType);
                userPrivateNode.save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Node getPrivateUserNode(SessionProvider sessionProvider, String user) throws Exception, PathNotFoundException, RepositoryException {
        NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        String privateRelativePath = nodeCreator.getJcrPath("userPrivate");
        Node userNode = nodeCreator.getUserNode(sessionProvider, user);
        return userNode.getNode(privateRelativePath);
    }

    @Override
    public void unpublishDocumentToUser(String user, ExtendedNode node) {
        block4: {
            Node userPrivateNode = null;
            Node sharedNode = null;
            try {
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                userPrivateNode = this.getPrivateUserNode(sessionProvider, user);
                userPrivateNode = userPrivateNode.getNode("Documents");
                sharedNode = userPrivateNode.getNode("Shared");
                sharedNode.getNode(node.getName()).remove();
                this.removeUserPermission(node, user);
                node.getSession().save();
                userPrivateNode.save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void unpublishDocumentToSpace(String space, ExtendedNode node) {
        block5: {
            Node rootSpace = null;
            Node sharedNode = null;
            try {
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                rootSpace = (Node)session.getItem(nodeCreator.getJcrPath("groupsPath") + space);
                rootSpace = rootSpace.getNode("Documents");
                if (rootSpace.hasNode("Shared")) {
                    sharedNode = rootSpace.getNode("Shared");
                    sharedNode.getNode(node.getName()).remove();
                    rootSpace.save();
                }
                this.removeSpacePermission(node, space);
                node.getSession().save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeSpacePermission(ExtendedNode node, String space) {
        block2: {
            try {
                node.removePermission("*:" + space);
                node.save();
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeUserPermission(ExtendedNode node, String user) {
        block2: {
            try {
                node.removePermission(user);
                node.save();
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getMimeType(Node node) {
        block3: {
            try {
                if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                    return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    private void setSpacePermission(Node currentNode, String memberShip, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
            node.addMixin(MIX_PRIVILEGEABLE);
        }
        node.setPermission("*:" + memberShip, permissions);
        node.save();
    }

    private void setUserPermission(Node currentNode, String username, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
            node.addMixin(MIX_PRIVILEGEABLE);
        }
        node.setPermission(username, permissions);
        node.save();
    }

    public void start() {
    }

    public void stop() {
    }
}

