/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.selector.content.UIContentSearchResult;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/selector/content/UIContentSearchForm.gtmpl", events={@EventConfig(listeners={SearchWebContentActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class})})
public class UIContentSearchForm
extends UIForm {
    public static final String LOCATION = "location";
    public static final String SEARCH_BY_NAME = "name";
    public static final String SEARCH_BY_CONTENT = "content";
    public static final String RADIO_NAME = "WcmRadio";
    public static final String TIME_OPTION = "timeOpt";
    public static final String PROPERTY = "property";
    public static final String CONTAIN = "contain";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String DOC_TYPE = "docType";
    public static final String CATEGORY = "category";
    public static final String CREATED_DATE = "CREATED";
    public static final String MODIFIED_DATE = "MODIFIED";
    public static final String EXACTLY_PROPERTY = "exactlyPro";
    public static final String CONTAIN_PROPERTY = "containPro";
    public static final String NOT_CONTAIN_PROPERTY = "notContainPro";
    public static final String DATE_PROPERTY = "datePro";
    public static final String NODETYPE_PROPERTY = "nodetypePro";
    public static final String CHECKED_RADIO_ID = "checkedRadioId";
    private String checkedRadioId;

    public void init() throws Exception {
        ArrayList<SelectItemOption> portalNameOptions = new ArrayList<SelectItemOption>();
        List<String> portalNames = this.getPortalNames();
        for (String portalName : portalNames) {
            portalNameOptions.add(new SelectItemOption(portalName, (Object)portalName));
        }
        UIFormSelectBox portalNameSelectBox = new UIFormSelectBox(LOCATION, LOCATION, portalNameOptions);
        portalNameSelectBox.setDefaultValue((Object)portalNames.get(0));
        this.addChild((UIComponent)portalNameSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_NAME, SEARCH_BY_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_CONTENT, SEARCH_BY_CONTENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY, PROPERTY, null).setDisabled(true));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTAIN, CONTAIN, null));
        ArrayList<SelectItemOption> dateOptions = new ArrayList<SelectItemOption>();
        dateOptions.add(new SelectItemOption(CREATED_DATE, (Object)CREATED_DATE));
        dateOptions.add(new SelectItemOption(MODIFIED_DATE, (Object)MODIFIED_DATE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_OPTION, TIME_OPTION, dateOptions));
        UIFormDateTimeInput startTime = new UIFormDateTimeInput(START_TIME, START_TIME, null, true);
        this.addUIFormInput((UIFormInput)startTime);
        UIFormDateTimeInput endTime = new UIFormDateTimeInput(END_TIME, END_TIME, null, true);
        this.addUIFormInput((UIFormInput)endTime);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOC_TYPE, DOC_TYPE, null).setDisabled(true));
        this.setActions(new String[]{"SearchWebContent"});
    }

    private List<String> getPortalNames() throws Exception {
        ArrayList<String> portalNames = new ArrayList<String>();
        String currentPortalName = Util.getPortalRequestContext().getPortalOwner();
        WCMConfigurationService configService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String sharedPortalName = configService.getSharedPortalName();
        portalNames.add(currentPortalName);
        portalNames.add(sharedPortalName);
        return portalNames;
    }

    private QueryCriteria getInitialQueryCriteria(String siteName) throws Exception {
        QueryCriteria qCriteria = new QueryCriteria();
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        String[] allContentType = templateService.getDocumentTemplates().toArray(new String[0]);
        qCriteria.setContentTypes(allContentType);
        qCriteria.setSearchWebpage(false);
        qCriteria.setSiteName(siteName);
        qCriteria.setLiveMode(false);
        return qCriteria;
    }

    private boolean haveEmptyField(UIApplication uiApp, Event<UIContentSearchForm> event, String field, String messageKey) throws Exception {
        if (field == null || "".equals(field) || field.toString().trim().length() <= 0) {
            uiApp.addMessage(new ApplicationMessage(messageKey, null, 1));
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)this);
            return true;
        }
        return false;
    }

    private AbstractPageList<ResultNode> searchContentByName(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(false);
        qCriteria.setKeyword(keyword);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), qCriteria, requestContext.getLocale(), pageSize, true);
    }

    private AbstractPageList<ResultNode> searchContentByFulltext(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(new String[]{"."});
        qCriteria.setKeyword(keyword);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), qCriteria, requestContext.getLocale(), pageSize, true);
    }

    private AbstractPageList<ResultNode> searchContentByProperty(String property, String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(new String[]{property});
        qCriteria.setKeyword(keyword);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearchService.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), qCriteria, requestContext.getLocale(), pageSize, true);
    }

    private AbstractPageList<ResultNode> searchContentByDate(QueryCriteria.DATE_RANGE_SELECTED dateRangeSelected, Calendar fromDate, Calendar endDate, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setDateRangeSelected(dateRangeSelected);
        QueryCriteria.DatetimeRange dateTimeRange = new QueryCriteria.DatetimeRange(fromDate, endDate);
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED.equals((Object)dateRangeSelected)) {
            qCriteria.setCreatedDateRange(dateTimeRange);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED.equals((Object)dateRangeSelected)) {
            qCriteria.setLastModifiedDateRange(dateTimeRange);
        }
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), qCriteria, requestContext.getLocale(), pageSize, true);
    }

    private AbstractPageList<ResultNode> searchContentByType(String documentType, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        qCriteria.setContentTypes(documentType.split(","));
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), qCriteria, requestContext.getLocale(), pageSize, true);
    }

    public String getCheckedRadioId() {
        return this.checkedRadioId;
    }

    public void setCheckedRadioId(String checkedRadioId) {
        this.checkedRadioId = checkedRadioId;
    }

    public static class SearchWebContentActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            AbstractPageList pagResult;
            UIContentSelector uiWCTabSelector;
            block25: {
                WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                UIContentSearchForm uiWCSearch = (UIContentSearchForm)((Object)event.getSource());
                int pageSize = 5;
                String radioValue = event.getRequestContext().getRequestParameter(UIContentSearchForm.RADIO_NAME);
                uiWCSearch.setCheckedRadioId(event.getRequestContext().getRequestParameter(UIContentSearchForm.CHECKED_RADIO_ID));
                String siteName = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.LOCATION).getValue();
                uiWCTabSelector = (UIContentSelector)uiWCSearch.getParent();
                UIApplication uiApp = (UIApplication)uiWCSearch.getAncestorOfType(UIApplication.class);
                QueryCriteria qCriteria = uiWCSearch.getInitialQueryCriteria(siteName);
                pagResult = null;
                ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
                try {
                    String keyword;
                    if (UIContentSearchForm.SEARCH_BY_NAME.equals(radioValue)) {
                        keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                        if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, keyword, "UIContentSearchForm.msg.empty-name")) {
                            return;
                        }
                        pagResult = uiWCSearch.searchContentByName(keyword.trim(), qCriteria, pageSize);
                        break block25;
                    }
                    if (UIContentSearchForm.SEARCH_BY_CONTENT.equals(radioValue)) {
                        keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                        if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, keyword, "UIContentSearchForm.msg.empty-content")) {
                            return;
                        }
                        pagResult = uiWCSearch.searchContentByFulltext(keyword, qCriteria, pageSize);
                        break block25;
                    }
                    if (UIContentSearchForm.PROPERTY.equals(radioValue)) {
                        String property = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.PROPERTY).getValue();
                        if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, property, "UIContentSearchForm.msg.empty-property")) {
                            return;
                        }
                        String keyword2 = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.CONTAIN).getValue();
                        if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, keyword2, "UIContentSearchForm.msg.empty-property-keyword")) {
                            return;
                        }
                        pagResult = uiWCSearch.searchContentByProperty(property, keyword2, qCriteria, pageSize);
                        break block25;
                    }
                    if (UIContentSearchForm.TIME_OPTION.equals(radioValue)) {
                        UIFormDateTimeInput startDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.START_TIME);
                        UIFormDateTimeInput endDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.END_TIME);
                        String strStartDate = (String)startDateInput.getValue();
                        if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, strStartDate, "UIContentSearchForm.msg.empty-startDate")) {
                            return;
                        }
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(startDateInput.getDatePattern_().trim());
                            dateFormat.setLenient(false);
                            dateFormat.parse((String)startDateInput.getValue());
                        }
                        catch (ParseException e) {
                            uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-format", new Object[]{resourceBundle.getString("UIContentSearchForm.title.FromDate")}, 1));
                            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                            return;
                        }
                        Calendar startDate = startDateInput.getCalendar();
                        Calendar endDate = null;
                        if (endDateInput.getValue() == null || ((String)endDateInput.getValue()).length() == 0) {
                            endDate = startDate.getTimeInMillis() > Calendar.getInstance().getTimeInMillis() ? startDate : Calendar.getInstance();
                        } else {
                            try {
                                SimpleDateFormat dateFormat = new SimpleDateFormat(endDateInput.getDatePattern_().trim());
                                dateFormat.setLenient(false);
                                dateFormat.parse((String)endDateInput.getValue());
                            }
                            catch (ParseException e) {
                                uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-format", new Object[]{resourceBundle.getString("UIContentSearchForm.title.ToDate")}, 1));
                                requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                                return;
                            }
                            endDate = endDateInput.getCalendar();
                        }
                        if (startDate.getTimeInMillis() > endDate.getTimeInMillis()) {
                            uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-date", null, 1));
                            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                            return;
                        }
                        if (startDate.getTimeInMillis() > Calendar.getInstance().getTimeInMillis()) {
                            uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-startDate", null, 1));
                            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                            return;
                        }
                        try {
                            String dateRangeSelected = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.TIME_OPTION).getValue();
                            pagResult = UIContentSearchForm.CREATED_DATE.equals(dateRangeSelected) ? uiWCSearch.searchContentByDate(QueryCriteria.DATE_RANGE_SELECTED.CREATED, startDate, endDate, qCriteria, pageSize) : uiWCSearch.searchContentByDate(QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED, startDate, endDate, qCriteria, pageSize);
                            break block25;
                        }
                        catch (IllegalArgumentException iaEx) {
                            uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.time-to-late", null, 1));
                            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                            return;
                        }
                    }
                    if (!UIContentSearchForm.DOC_TYPE.equals(radioValue)) break block25;
                    String documentType = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.DOC_TYPE).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, documentType, "UIContentSearchForm.msg.empty-doctype")) {
                        return;
                    }
                    try {
                        pagResult = uiWCSearch.searchContentByType(documentType, qCriteria, pageSize);
                    }
                    catch (Exception ex) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-nodeType", new Object[]{documentType}, 0));
                        requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                        return;
                    }
                }
                catch (InvalidQueryException iqe) {
                    uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-keyword", null, 1));
                    requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                    return;
                }
                catch (RepositoryException re) {
                    uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-keyword", null, 1));
                    requestContext.addUIComponentToUpdateByAjax((UIComponent)uiWCSearch);
                    return;
                }
            }
            UIContentSearchResult uiWCSearchResult = (UIContentSearchResult)uiWCTabSelector.getChild(UIContentSearchResult.class);
            uiWCSearchResult.updateGrid((AbstractPageList<ResultNode>)pagResult);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
            uiWCTabSelector.setSelectedTab(uiWCSearchResult.getId());
        }
    }

    public static class AddNodeTypeActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)((Object)event.getSource());
            UIContentSelector contentSelector = (UIContentSelector)contentSearchForm.getParent();
            contentSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(UIContentSearchForm.CHECKED_RADIO_ID));
            UIContainer uiContainer = (UIContainer)((UIContentSelector)contentSearchForm.getAncestorOfType(UIContentSelector.class)).getAncestorOfType(UIContainer.class);
            contentSelector.initNodeTypePopup(uiContainer);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class AddMetadataTypeActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)((Object)event.getSource());
            UIContentSelector contentSelector = (UIContentSelector)contentSearchForm.getParent();
            contentSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(UIContentSearchForm.CHECKED_RADIO_ID));
            UIContainer uiContainer = (UIContainer)((UIContentSelector)contentSearchForm.getAncestorOfType(UIContentSelector.class)).getAncestorOfType(UIContainer.class);
            contentSelector.initMetadataPopup(uiContainer);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }
}

