/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import com.ibm.icu.text.Transliterator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.jcr.util.VersionHistoryImporter;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodetypeConstant;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger((String)Utils.class.getName());
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!^()+{}[]:\"-";
    private static final String SEPARATOR = "/";
    public static final String MAPPING_FILE = "mapping.properties";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String PRIVATE = "Private";
    public static final String PUBLIC = "Public";
    public static final String SPACES_NODE_PATH = "/Groups/spaces";
    public static final String SPACE_GROUP = "/spaces";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:folksonomyFolder", "exo:documentFolder", "exo:favoriteFolder", "exo:pictureFolder", "exo:musicFolder", "exo:videoFolder", "exo:searchFolder"};
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split(SEPARATOR);
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.length() <= 0) continue;
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            node = node.addNode(token, nodetype);
            node.getSession().save();
            node = (Node)node.getSession().getItem(node.getPath());
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        rootNode.save();
        return node;
    }

    public static void processImportHistory(Node currentNode, InputStream versionHistorySourceStream, Map<String, String> mapHistoryValue) throws Exception {
        Map<String, byte[]> mapVersionHistoryData = Utils.getVersionHistoryData(versionHistorySourceStream);
        block3: for (String uuid : mapHistoryValue.keySet()) {
            for (String name : mapVersionHistoryData.keySet()) {
                if (!name.equals(uuid + ".xml")) continue;
                try {
                    byte[] versionHistoryData = mapVersionHistoryData.get(name);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(versionHistoryData);
                    String value = mapHistoryValue.get(uuid);
                    Node versionableNode = currentNode.getSession().getNodeByUUID(uuid);
                    Utils.importHistory((NodeImpl)versionableNode, inputStream, Utils.getBaseVersionUUID(value), Utils.getPredecessors(value), Utils.getVersionHistory(value));
                    currentNode.getSession().save();
                    continue block3;
                }
                catch (ItemNotFoundException item) {
                    currentNode.getSession().refresh(false);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Can not found versionable node" + (Object)((Object)item)), (Throwable)item);
                }
                catch (Exception e) {
                    currentNode.getSession().refresh(false);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Import version history failed " + e), (Throwable)e);
                }
            }
        }
    }

    private static Map<String, byte[]> getVersionHistoryData(InputStream versionHistorySourceStream) throws IOException {
        HashMap<String, byte[]> mapVersionHistoryData = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(versionHistorySourceStream));
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int available = -1;
            while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            mapVersionHistoryData.put(entry.getName(), out.toByteArray());
            out.close();
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return mapVersionHistoryData;
    }

    private static void importHistory(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException, IOException {
        VersionHistoryImporter versionHistoryImporter = new VersionHistoryImporter(versionableNode, versionHistoryStream, baseVersionUuid, predecessors, versionHistory);
        versionHistoryImporter.doImport();
    }

    public static Map<String, String> getMapImportHistory(InputStream importHistorySourceStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(importHistorySourceStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        HashMap<String, String> mapHistoryValue = new HashMap<String, String>();
        while (entry != null) {
            int available = -1;
            if (entry.getName().equals(MAPPING_FILE)) {
                String strLine;
                while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                    out.write(data, 0, available);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((strLine = br.readLine()) != null) {
                    if (strLine.indexOf("=") <= -1) continue;
                    mapHistoryValue.put(strLine.split("=")[0], strLine.split("=")[1]);
                }
                ((InputStream)inputStream).close();
                zipInputStream.closeEntry();
                break;
            }
            entry = zipInputStream.getNextEntry();
        }
        out.close();
        zipInputStream.close();
        return mapHistoryValue;
    }

    private static String getBaseVersionUUID(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[1];
    }

    private static String[] getPredecessors(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        String strPredecessors = arrHistoryValue[1];
        if (strPredecessors.indexOf(",") > -1) {
            return strPredecessors.split(",");
        }
        return new String[]{strPredecessors};
    }

    private static String getVersionHistory(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPersonalDrivePath(String parameterizedDrivePath, String userId) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userId);
            String string = StringUtils.replaceOnce((String)parameterizedDrivePath, (String)(nodeHierarchyCreator.getJcrPath("usersPath") + "/${userId}"), (String)userNode.getPath());
            return string;
        }
    }

    public static List<PropertyDefinition> getProperties(Node node) throws Exception {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        NodeType nodetype = node.getPrimaryNodeType();
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        types.add(nodetype);
        NodeType[] mixins = node.getMixinNodeTypes();
        if (mixins != null) {
            types.addAll(Arrays.asList(mixins));
        }
        for (NodeType nodeType : types) {
            for (PropertyDefinition property : nodeType.getPropertyDefinitions()) {
                String name = property.getName();
                if (name.equals("exo:internalUse") || property.isProtected() || node.hasProperty(name)) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (PathNotFoundException ex) {
                title = null;
            }
            catch (ValueFormatException ex) {
                title = null;
            }
            catch (RepositoryException ex) {
                title = null;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                title = null;
            }
        }
        if (StringUtils.isBlank((String)title)) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return StringEscapeUtils.escapeHtml((String)Text.unescapeIllegalJcrChars((String)title));
    }

    public static String escapeIllegalCharacterInQuery(String query) {
        String ret = query;
        if (ret != null) {
            for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
                ret = ret.replace(c + "", "\\" + c);
            }
        }
        ret = ret.replace("'", "''");
        return ret;
    }

    public static void removeSymlinks(Node node) throws Exception {
        LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
        List<Node> symlinks = linkManager.getAllLinks(node, EXO_SYMLINK);
        for (Node symlink : symlinks) {
            symlink.remove();
        }
    }

    private static void removeDeadSymlinksFromTrash(Node node) throws Exception {
        LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
        List<Node> symlinks = linkManager.getAllLinks(node, EXO_SYMLINK);
        ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
        for (Node symlink : symlinks) {
            symlink.remove();
            listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, null, (Object)symlink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeDeadSymlinks(Node node, boolean keepInTrash) throws Exception {
        if (Utils.isInTrash(node)) {
            Utils.removeDeadSymlinksFromTrash(node);
            return;
        }
        linkManager = WCMCoreUtils.getService(LinkManager.class);
        trashService = WCMCoreUtils.getService(TrashService.class);
        sessionProvider = SessionProvider.createSystemProvider();
        queue = new LinkedList<Node>();
        queue.add(node);
        try {
            block9: while (true) {
                block15: {
                    if (queue.isEmpty() != false) return;
                    node = (Node)queue.poll();
                    if (node.isNodeType("exo:symlink")) continue;
                    try {
                        symlinks = linkManager.getAllLinks(node, "exo:symlink", sessionProvider);
                        Collections.sort(symlinks, new Comparator<Node>(){

                            @Override
                            public int compare(Node node1, Node node2) {
                                try {
                                    String name1 = node1.getName();
                                    String name2 = node2.getName();
                                    if (name1.equals(name2)) {
                                        int index1 = node1.getIndex();
                                        int index2 = node2.getIndex();
                                        return -1 * Integer.valueOf(index1).compareTo(index2);
                                    }
                                    return -1 * name1.compareTo(name2);
                                }
                                catch (RepositoryException e) {
                                    return 0;
                                }
                            }
                        });
                        var7_9 = symlinks.iterator();
                        while (var7_9.hasNext()) {
                            var9_11 = symlink = var7_9.next();
                            synchronized (var9_11) {
                                if (keepInTrash) {
                                    trashService.moveToTrash(symlink, sessionProvider, 1);
                                } else {
                                    symlink.remove();
                                }
                                listenerService = WCMCoreUtils.getService(ListenerService.class);
                                listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, null, (Object)symlink);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!Utils.LOG.isWarnEnabled()) break block15;
                        Utils.LOG.warn((Object)e.getMessage());
                    }
                }
                iter = node.getNodes();
                while (true) {
                    if (iter.hasNext()) ** break;
                    continue block9;
                    queue.add(iter.nextNode());
                }
                break;
            }
        }
        catch (Exception e) {
            if (Utils.LOG.isWarnEnabled() == false) return;
            Utils.LOG.warn((Object)e.getMessage());
            return;
        }
        finally {
            sessionProvider.close();
        }
    }

    public static void removeDeadSymlinks(Node node) throws Exception {
        Utils.removeDeadSymlinks(node, true);
    }

    public static Node getChildOfType(Node node, String childType) throws Exception {
        if (node == null) {
            return null;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType(childType)) continue;
            return child;
        }
        return null;
    }

    public static boolean hasChild(Node node, String childType) throws Exception {
        return Utils.getChildOfType(node, childType) != null;
    }

    private static Node getServiceLogContentNode(SessionProvider systemProvider, String serviceName, String logType) throws Exception {
        ManageableRepository repository = WCMCoreUtils.getRepository();
        Session session = systemProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        Node serviceLogContentNode = null;
        try {
            Node serviceLogNode;
            Node serviceFolder = (Node)session.getItem("/exo:services");
            Node serviceNode = serviceFolder.hasNode(serviceName) ? serviceFolder.getNode(serviceName) : serviceFolder.addNode(serviceName, "nt:unstructured");
            String serviceLogName = serviceName + "_" + logType;
            Node node = serviceLogNode = serviceNode.hasNode(serviceLogName) ? serviceNode.getNode(serviceLogName) : serviceNode.addNode(serviceLogName, "nt:file");
            if (serviceLogNode.hasNode("jcr:content")) {
                serviceLogContentNode = serviceLogNode.getNode("jcr:content");
            } else {
                serviceLogContentNode = serviceLogNode.addNode("jcr:content", "nt:resource");
                serviceLogContentNode.setProperty("jcr:encoding", "UTF-8");
                serviceLogContentNode.setProperty("jcr:mimeType", "text/plain");
                serviceLogContentNode.setProperty("jcr:data", "");
                serviceLogContentNode.setProperty("jcr:lastModified", new Date().getTime());
            }
            session.save();
        }
        catch (PathNotFoundException ex) {
            LOG.warn((Object)"Could not find /exo:services node");
        }
        return serviceLogContentNode;
    }

    public static Node getServiceLogContentNode(String serviceName, String logType) throws Exception {
        return Utils.getServiceLogContentNode(WCMCoreUtils.getSystemSessionProvider(), serviceName, logType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllEditedConfiguredData(String className, String id, boolean skipActivities) throws Exception {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", skipActivities);
            HashSet<String> editedConfigTemplates = new HashSet<String>();
            Node serviceLogContentNode = Utils.getServiceLogContentNode(systemProvider, className, id);
            if (serviceLogContentNode != null) {
                String logData = serviceLogContentNode.getProperty("jcr:data").getString();
                editedConfigTemplates.addAll(Arrays.asList(logData.split(";")));
            }
            HashSet<String> hashSet = editedConfigTemplates;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEditedConfiguredData(String template, String className, String id, boolean skipActivities) throws Exception {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", skipActivities);
            Node serviceLogContentNode = Utils.getServiceLogContentNode(systemProvider, className, id);
            if (serviceLogContentNode != null) {
                String logData = serviceLogContentNode.getProperty("jcr:data").getString();
                if (StringUtils.isEmpty((String)logData)) {
                    logData = template;
                } else if (logData.indexOf(template) == -1) {
                    logData = logData.concat(";").concat(template);
                }
                serviceLogContentNode.setProperty("jcr:data", logData);
                serviceLogContentNode.getSession().save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEditedConfiguredData(String template, String className, String id, boolean skipActivities) throws Exception {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", skipActivities);
            Node serviceLogContentNode = Utils.getServiceLogContentNode(systemProvider, className, id);
            if (serviceLogContentNode == null) {
                return;
            }
            String logData = serviceLogContentNode.getProperty("jcr:data").getString();
            if (StringUtils.isNotBlank((String)logData)) {
                logData = ";".concat(logData).replace(";".concat(template), "");
                logData = StringUtils.substring((String)logData, (int)1);
                serviceLogContentNode.setProperty("jcr:data", logData);
                serviceLogContentNode.getSession().save();
            }
        }
    }

    public static String getObjectId(String nodePath) throws UnsupportedEncodingException {
        return URLEncoder.encode(nodePath.replaceAll("'", "\\\\'"), "utf-8");
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        int strLength = cleanedStr.length();
        int i = 0;
        while (i < strLength) {
            char c = cleanedStr.charAt(i);
            if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|' || c == '\u02bf' || c == '\u02c7') {
                cleanedStr.deleteCharAt(i);
                cleanedStr.insert(i, '_');
            } else if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && c != '.' && c != '-' && c != '_') {
                cleanedStr.deleteCharAt(i);
                strLength = cleanedStr.length();
                continue;
            }
            ++i;
        }
        while (StringUtils.isNotEmpty((String)cleanedStr.toString()) && !Character.isLetterOrDigit(cleanedStr.charAt(0))) {
            cleanedStr.deleteCharAt(0);
        }
        String clean = cleanedStr.toString().toLowerCase();
        if (clean.endsWith("-")) {
            clean = clean.substring(0, clean.length() - 1);
        }
        return clean;
    }

    public static String cleanName(String oldName) {
        if (StringUtils.isEmpty((String)oldName)) {
            return oldName;
        }
        String specialChar = "&#*@'\"\t\r\n$\\><:;[]/%|";
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < oldName.length(); ++i) {
            char currentChar = oldName.charAt(i);
            if (specialChar.indexOf(currentChar) > -1) {
                ret.append('-');
                continue;
            }
            ret.append(currentChar);
        }
        return ret.toString();
    }

    public static String cleanNameWithAccents(String fileName) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        if (fileName.indexOf(46) > 0) {
            String ext = fileName.substring(fileName.lastIndexOf(46));
            fileName = accentsconverter.transliterate(fileName.substring(0, fileName.lastIndexOf(46))).concat(ext);
        } else {
            fileName = accentsconverter.transliterate(fileName);
        }
        return Text.escapeIllegalJcrChars((String)fileName);
    }

    public static List<String> getMemberships() throws Exception {
        ArrayList<String> userMemberships = new ArrayList<String>();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (StringUtils.isNotEmpty((String)userId)) {
            userMemberships.add(userId);
            Collection<MembershipEntry> memberships = Utils.getUserMembershipsFromIdentityRegistry(userId);
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private static Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        IdentityRegistry identityRegistry = WCMCoreUtils.getService(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        if (currentUserIdentity == null) {
            return Collections.emptySet();
        }
        return currentUserIdentity.getMemberships();
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        if (node == null) {
            return "";
        }
        String nodeType = node.getPrimaryNodeType().getName();
        LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
        if (linkManager.isLink((Item)node)) {
            try {
                nodeType = node.getProperty("exo:primaryType").getString();
                node = linkManager.getTarget(node, IdentityConstants.SYSTEM.equals(node.getSession().getUserID()));
                if (node == null) {
                    return "";
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        if (node.isNodeType("exo:trashFolder")) {
            nodeType = "exo:trashFolder";
        } else if (node.isNodeType("exo:favoriteFolder")) {
            nodeType = "exo:favoriteFolder";
        } else if (nodeType.equals("nt:unstructured") || nodeType.equals("nt:folder")) {
            if (PRIVATE.equals(node.getName()) || PUBLIC.equals(node.getName())) {
                nodeType = String.format("exo:%sFolder", node.getName().toLowerCase());
            } else {
                for (String specificFolder : NodetypeConstant.SPECIFIC_FOLDERS) {
                    if (!node.isNodeType(specificFolder)) continue;
                    nodeType = specificFolder;
                    break;
                }
            }
        }
        nodeType = nodeType.replace(':', '_');
        String defaultCssClass = node.isNodeType("nt:unstructured") || node.isNodeType("nt:folder") ? "Folder" : (node.isNodeType("nt:file") ? "File" : nodeType);
        defaultCssClass = defaultCssClass.concat("Default");
        StringBuilder str = new StringBuilder();
        str.append(appended);
        str.append(defaultCssClass);
        str.append(" ");
        str.append(appended);
        str.append(nodeType);
        if (mode != null && mode.equalsIgnoreCase("Collapse")) {
            str.append(' ').append(mode).append(appended).append(nodeType);
        }
        if (node.isNodeType("nt:file") && node.hasNode("jcr:content")) {
            Node jcrContentNode = node.getNode("jcr:content");
            str.append(' ').append(appended).append(jcrContentNode.getProperty("jcr:mimeType").getString().toLowerCase().replaceAll("/|\\.", ""));
        }
        return str.toString();
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return Utils.getNodeTypeIcon(node, appended, null);
    }

    public static String getFileType(Node node) throws Exception {
        return Utils.getNodeTypeIcon(node, "").replace(".", "").replace(SEPARATOR, "").replace("\\", "").replace(".", "");
    }

    public static String getFileType(NodeImpl node) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, "").replace(".", "").replace(SEPARATOR, "").replace("\\", "").replace(".", "");
    }

    public static boolean isDocument(Node node) throws Exception {
        TemplateService templateService = WCMCoreUtils.getService(TemplateService.class);
        if (templateService == null) {
            return false;
        }
        List<String> documentTypeList = templateService.getDocumentTemplates();
        if (documentTypeList == null) {
            return false;
        }
        for (String documentType : documentTypeList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }

    public static String getJcrContentLastModified(Node node) throws Exception {
        String lastModified = "";
        if (node.hasProperty("jcr:content/jcr:lastModified")) {
            lastModified = node.getProperty("jcr:content/jcr:lastModified").getString();
        } else if (node.hasProperty("jcr:content/exo:dateModified")) {
            lastModified = node.getProperty("jcr:content/exo:dateModified").getString();
        } else if (node.hasProperty("jcr:content/exo:lastModifiedDate")) {
            lastModified = node.getProperty("jcr:content/exo:lastModifiedDate").getString();
        }
        return lastModified;
    }

    public static String getJcrContentBaseVersion(Node node) throws Exception {
        return node.hasProperty("jcr:baseVersion") ? node.getProperty("jcr:baseVersion").getString() : null;
    }

    public static Calendar getDate(Node node) throws Exception {
        return node.hasProperty("exo:lastModifiedDate") ? node.getProperty("exo:lastModifiedDate").getDate() : node.getProperty("exo:dateCreated").getDate();
    }

    public static String getOwner(Node node) throws Exception {
        return node.hasProperty("exo:owner") ? node.getProperty("exo:owner").getString() : "";
    }

    public static String fileSize(Node node) throws Exception {
        if (node == null || !node.isNodeType("nt:file")) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(" - ");
        long size = 0L;
        try {
            size = node.getProperty("jcr:content/jcr:data").getLength();
        }
        catch (PathNotFoundException pne) {
            LOG.error((Object)("Unable to read binary content from disk for node " + node.getPath() + ". The binary content is not accessible, it was removed, or may have been quarantined by an antivirus."), (Throwable)pne);
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get file size", (Throwable)e);
        }
        ret.append(Utils.formatSize(size));
        return ret.toString();
    }

    public static String formatSize(long size) {
        StringBuilder ret = new StringBuilder();
        long byteSize = size % 1024L;
        long kbSize = size % 0x100000L / 1024L;
        long mbSize = size % 0x40000000L / 0x100000L;
        long gbSize = size / 0x40000000L;
        if (gbSize >= 1L) {
            ret.append(gbSize).append(Utils.refine(mbSize)).append(" GB");
        } else if (mbSize >= 1L) {
            ret.append(mbSize).append(Utils.refine(kbSize)).append(" MB");
        } else if (kbSize > 1L) {
            ret.append(kbSize).append(Utils.refine(byteSize)).append(" KB");
        } else {
            ret.append("1 KB");
        }
        return ret.toString();
    }

    public static boolean isSupportThumbnailView(String mimeType) {
        ArrayList<String> thumbnailMimeTypes = new ArrayList<String>();
        List<ComponentPlugin> componentPlugins = WCMCoreUtils.getService(ThumbnailService.class).getComponentPlugins();
        for (ComponentPlugin plugin : componentPlugins) {
            if (!(plugin instanceof ThumbnailPlugin)) continue;
            thumbnailMimeTypes.addAll(((ThumbnailPlugin)plugin).getMimeTypes());
        }
        return thumbnailMimeTypes.contains(mimeType);
    }

    private static String refine(long size) {
        if (size == 0L) {
            return "";
        }
        String strSize = String.valueOf(size);
        while (strSize.length() < 3) {
            strSize = "0" + strSize;
        }
        return "," + Math.round((double)Integer.valueOf(strSize).intValue() / 100.0);
    }

    public static boolean isFolder(Node node) throws RepositoryException {
        return node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured");
    }

    public static boolean isPersonalDefaultFolder(Node node) throws Exception {
        String nodeType;
        if (node.hasProperty("jcr:primaryType") && ((nodeType = node.getProperty("jcr:primaryType").getString()).equals("nt:unstructured") || nodeType.equals("nt:folder"))) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                String relativePath;
                if (!node.isNodeType(specificFolder)) continue;
                NodeHierarchyCreator nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
                String relativePathAlias = null;
                switch (specificFolder) {
                    case "exo:folksonomyFolder": {
                        relativePathAlias = "userPrivateFolksonomy";
                        break;
                    }
                    case "exo:documentFolder": {
                        relativePathAlias = "userPrivateDocuments";
                        break;
                    }
                    case "exo:favoriteFolder": {
                        relativePathAlias = "userPrivateFavorites";
                        break;
                    }
                    case "exo:pictureFolder": {
                        relativePathAlias = "userPrivatePicture";
                        break;
                    }
                    case "exo:musicFolder": {
                        relativePathAlias = "userPrivateAudio";
                        break;
                    }
                    case "exo:videoFolder": {
                        relativePathAlias = "userPrivateVideo";
                        break;
                    }
                    case "exo:searchFolder": {
                        relativePathAlias = "userPrivateSearches";
                        break;
                    }
                }
                if (relativePathAlias == null || (relativePath = nodeHierarchyCreator.getJcrPath(relativePathAlias)) == null || !node.getPath().endsWith(relativePath)) continue;
                return true;
            }
        }
        String path = node.getPath();
        String owner = ((ExtendedNode)node).getACL().getOwner();
        if (StringUtils.isNotBlank((String)path) && StringUtils.isNotBlank((String)owner)) {
            return path.endsWith("Private/Public") && "__system".equals(owner);
        }
        return false;
    }

    public static String getSearchDocumentDrive(Node documentNode) throws Exception {
        SpaceService spaceService;
        Space space;
        String nodePath = documentNode.getPath();
        if (!nodePath.startsWith(SPACES_NODE_PATH)) {
            return documentNode.getParent().getName();
        }
        String[] splittedNodePath = nodePath.split(SEPARATOR);
        if (splittedNodePath.length > 3 && (space = (spaceService = WCMCoreUtils.getService(SpaceService.class)).getSpaceByGroupId("/spaces/" + splittedNodePath[3])) != null) {
            return space.getDisplayName();
        }
        return "";
    }
}

