/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.storage;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import org.exoplatform.services.attachments.dao.AttachmentDAO;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.model.AttachmentContextEntity;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.attachments.utils.EntityBuilder;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class AttachmentStorageImpl
implements AttachmentStorage {
    AttachmentDAO attachmentDAO;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private DocumentService documentService;
    private LinkManager linkManager;

    public AttachmentStorageImpl(AttachmentDAO attachmentDAO, RepositoryService repositoryService, SessionProviderService sessionProviderService, DocumentService documentService, LinkManager linkManager) {
        this.attachmentDAO = attachmentDAO;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.documentService = documentService;
        this.linkManager = linkManager;
    }

    @Override
    public void linkAttachmentToEntity(long entityId, String entityType, String attachmentId) {
        AttachmentContextEntity attachmentContextEntity = new AttachmentContextEntity();
        attachmentContextEntity.setEntityId(entityId);
        attachmentContextEntity.setEntityType(entityType.toUpperCase());
        attachmentContextEntity.setAttachmentId(attachmentId);
        attachmentContextEntity.setAttachedDate(System.currentTimeMillis());
        this.attachmentDAO.create(attachmentContextEntity);
    }

    @Override
    public List<Attachment> getAttachmentsByEntity(Session session, String workspace, long entityId, String entityType) throws Exception {
        List<AttachmentContextEntity> attachmentsContextEntity = this.attachmentDAO.getAttachmentContextByEntity(entityId, entityType.toUpperCase());
        Utils.sortAttachmentsByDate(attachmentsContextEntity);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (!attachmentsContextEntity.isEmpty()) {
            for (AttachmentContextEntity attachmentContextEntity : attachmentsContextEntity) {
                Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, workspace, session, attachmentContextEntity.getAttachmentId());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    @Override
    public Attachment getAttachmentItemByEntity(Session session, String workspace, long entityId, String entityType, String attachmentId) throws Exception {
        AttachmentContextEntity attachmentEntity = this.attachmentDAO.getAttachmentItemByEntity(entityId, entityType.toUpperCase(), attachmentId);
        return EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, workspace, session, attachmentEntity.getAttachmentId());
    }

    @Override
    public void deleteAllEntityAttachments(AttachmentContextEntity attachmentContextEntity) {
        this.attachmentDAO.delete(attachmentContextEntity);
    }

    @Override
    public void deleteAttachmentItemByIdByEntity(long entityId, String entityType, String attachmentId) {
        AttachmentContextEntity attachmentEntity = this.attachmentDAO.getAttachmentItemByEntity(entityId, entityType.toUpperCase(), attachmentId);
        this.attachmentDAO.delete(attachmentEntity);
    }
}

