/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.clouddrives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveMessage;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudProvider;

public class DriveInfo {
    final CloudProvider provider;
    final Map<String, CloudFile> files;
    final Collection<String> removed;
    final Collection<CloudDriveMessage> messages;
    final String workspace;
    final String path;
    final String title;
    final Object state;
    final boolean connected;

    DriveInfo(String title, String workspace, String path, Object state, boolean connected, CloudProvider provider, Map<String, CloudFile> files, Collection<String> removed, Collection<CloudDriveMessage> messages) {
        this.title = title;
        this.workspace = workspace;
        this.path = path;
        this.state = state;
        this.connected = connected;
        this.provider = provider;
        this.files = files;
        this.messages = messages;
        this.removed = removed;
    }

    static DriveInfo create(String workspaces, CloudDrive drive, Collection<CloudFile> files, Collection<String> removed, Collection<CloudDriveMessage> messages) throws RepositoryException, CloudDriveException {
        HashMap<String, CloudFile> driveFiles = new HashMap<String, CloudFile>();
        for (CloudFile cf : files) {
            driveFiles.put(cf.getPath(), cf);
        }
        return new DriveInfo(drive.getTitle(), workspaces, drive.getPath(), drive.getState(), drive.isConnected(), drive.getUser().getProvider(), driveFiles, removed, messages);
    }

    static DriveInfo create(String workspaces, CloudDrive drive, Collection<CloudFile> files, Collection<CloudDriveMessage> messages) throws RepositoryException, CloudDriveException {
        return DriveInfo.create(workspaces, drive, files, new HashSet<String>(), messages);
    }

    static DriveInfo create(String workspaces, CloudDrive drive) throws RepositoryException, CloudDriveException {
        return DriveInfo.create(workspaces, drive, new ArrayList<CloudFile>(), new HashSet<String>(), new ArrayList<CloudDriveMessage>());
    }

    public CloudProvider getProvider() {
        return this.provider;
    }

    public Map<String, CloudFile> getFiles() {
        return this.files;
    }

    public Collection<String> getRemoved() {
        return this.removed;
    }

    public Collection<CloudDriveMessage> getMessages() {
        return this.messages;
    }

    public String getPath() {
        return this.path;
    }

    public Object getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

