/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DirectoryAudit;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DirectoryAuditCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DirectoryAuditCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DirectoryAuditCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DirectoryAuditRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDirectoryAuditCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDirectoryAuditCollectionRequest;

public class DirectoryAuditCollectionRequest
extends BaseCollectionRequest<DirectoryAuditCollectionResponse, IDirectoryAuditCollectionPage>
implements IDirectoryAuditCollectionRequest {
    public DirectoryAuditCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryAuditCollectionResponse.class, IDirectoryAuditCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDirectoryAuditCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryAuditCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryAuditCollectionPage get() throws ClientException {
        DirectoryAuditCollectionResponse response = (DirectoryAuditCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DirectoryAudit newDirectoryAudit, ICallback<DirectoryAudit> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DirectoryAuditRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDirectoryAudit, callback);
    }

    @Override
    public DirectoryAudit post(DirectoryAudit newDirectoryAudit) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryAuditRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDirectoryAudit);
    }

    @Override
    public IDirectoryAuditCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDirectoryAuditCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryAuditCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDirectoryAuditCollectionPage buildFromResponse(DirectoryAuditCollectionResponse response) {
        DirectoryAuditCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryAuditCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryAuditCollectionPage page = new DirectoryAuditCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

