/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DeviceComplianceUserStatus;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceUserStatusCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceUserStatusCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceUserStatusCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceComplianceUserStatusRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceComplianceUserStatusCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceComplianceUserStatusCollectionRequest;

public class DeviceComplianceUserStatusCollectionRequest
extends BaseCollectionRequest<DeviceComplianceUserStatusCollectionResponse, IDeviceComplianceUserStatusCollectionPage>
implements IDeviceComplianceUserStatusCollectionRequest {
    public DeviceComplianceUserStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceUserStatusCollectionResponse.class, IDeviceComplianceUserStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceUserStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceUserStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceUserStatusCollectionPage get() throws ClientException {
        DeviceComplianceUserStatusCollectionResponse response = (DeviceComplianceUserStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceUserStatus newDeviceComplianceUserStatus, ICallback<DeviceComplianceUserStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceUserStatus, callback);
    }

    @Override
    public DeviceComplianceUserStatus post(DeviceComplianceUserStatus newDeviceComplianceUserStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceUserStatus);
    }

    @Override
    public IDeviceComplianceUserStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceUserStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceUserStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceComplianceUserStatusCollectionPage buildFromResponse(DeviceComplianceUserStatusCollectionResponse response) {
        DeviceComplianceUserStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceUserStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceUserStatusCollectionPage page = new DeviceComplianceUserStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

