/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.documents.CommonEditorPlugin;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentMetadataPlugin;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.NewDocumentTemplatePlugin;
import org.exoplatform.services.cms.documents.NewDocumentTemplateProvider;
import org.exoplatform.services.cms.documents.VersionHistoryUtils;
import org.exoplatform.services.cms.documents.exception.DocumentEditorProviderNotFoundException;
import org.exoplatform.services.cms.documents.exception.DocumentExtensionNotSupportedException;
import org.exoplatform.services.cms.documents.impl.DocumentEditorProviderImpl;
import org.exoplatform.services.cms.documents.impl.EditorProvidersHelper;
import org.exoplatform.services.cms.documents.impl.NewDocumentTemplateProviderImpl;
import org.exoplatform.services.cms.documents.model.Document;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.utils.RepositoryConsumer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.gatein.api.Portal;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;

public class DocumentServiceImpl
implements DocumentService {
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String EXO_LAST_MODIFIER_PROP = "exo:lastModifier";
    public static final String EXO_DATE_CREATED_PROP = "exo:dateCreated";
    public static final String EXO_RSS_ENABLE_PROP = "exo:rss-enable";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String JCR_LAST_MODIFIED_PROP = "jcr:lastModified";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_MIME_TYPE = "jcr:mimeType";
    public static final String EXO_OWNER_PROP = "exo:owner";
    public static final String EXO_TITLE_PROP = "exo:title";
    private static final String EXO_DOCUMENT = "exo:document";
    private static final String EXO_USER_PREFFERENCES = "exo:userPrefferences";
    private static final String EXO_PREFFERED_EDITOR = "exo:prefferedEditor";
    private static final String EXO_CURRENT_PROVIDER = "exo:currentProvider";
    private static final String EXO_EDITORS_RUNTIME_ID = "exo:editorsId";
    public static final String CURRENT_STATE_PROP = "publication:currentState";
    public static final String DOCUMENTS_APP_NAVIGATION_NODE_NAME = "documents";
    public static final String DOCUMENT_NOT_FOUND = "?path=doc-not-found";
    private static final String DOCUMENTS_NODE = "Documents";
    private static final String ACTIVITY_STREAM_NODE = "Activity Stream Documents";
    private static final String SHARED_NODE = "Shared";
    private static final String COLLABORATION = "collaboration";
    private static final long DEFAULT_EDITORS_IDLE_TIMEOUT = 1800000L;
    private static final Log LOG = ExoLogger.getLogger(DocumentServiceImpl.class);
    private final List<NewDocumentTemplateProvider> templateProviders = new ArrayList<NewDocumentTemplateProvider>();
    private final List<DocumentEditorProvider> editorProviders = new ArrayList<DocumentEditorProvider>();
    private final List<NewDocumentTemplateProvider> unmodifiebleTemplateProviders = Collections.unmodifiableList(this.templateProviders);
    private final List<DocumentEditorProvider> unmodifiebleEditorProviders = Collections.unmodifiableList(this.editorProviders);
    private final ManageDriveService manageDriveService;
    private final Portal portal;
    private final SessionProviderService sessionProviderService;
    private final RepositoryService repoService;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final LinkManager linkManager;
    private final PortalContainerInfo portalContainerInfo;
    private final Map<String, DocumentMetadataPlugin> metadataPlugins = new HashMap<String, DocumentMetadataPlugin>();
    private final OrganizationService organizationService;
    private final SettingService settingService;
    private final IdentityManager identityManager;
    private final ConfigurationManager configurationManager;
    private final String editorsRuntimeId;
    private CommonEditorPlugin commonEditorPlugin;
    private FavoriteService favoriteService;
    private Authenticator authenticator;
    private final IdentityRegistry identityRegistry;

    public DocumentServiceImpl(ManageDriveService manageDriveService, ConfigurationManager configurationManager, Portal portal, SessionProviderService sessionProviderService, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager, PortalContainerInfo portalContainerInfo, OrganizationService organizationService, SettingService settingService, IdentityManager identityManager, IDGeneratorService idGenerator, FavoriteService favoriteService, IdentityRegistry identityRegistry, Authenticator authenticator) {
        this.configurationManager = configurationManager;
        this.manageDriveService = manageDriveService;
        this.sessionProviderService = sessionProviderService;
        this.repoService = repoService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.portal = portal;
        this.linkManager = linkManager;
        this.portalContainerInfo = portalContainerInfo;
        this.organizationService = organizationService;
        this.settingService = settingService;
        this.identityManager = identityManager;
        this.favoriteService = favoriteService;
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
        this.editorsRuntimeId = idGenerator.generateStringID((Object)this);
        EditorProvidersHelper.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document findDocById(String documentId) throws RepositoryException {
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = repositoryService.getCurrentRepository();
        try (SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();){
            Document doc;
            String ws = documentId.split(":/")[0];
            String uuid = documentId.split(":/")[1];
            Node node = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            String title = node.hasProperty(EXO_TITLE_PROP) ? node.getProperty(EXO_TITLE_PROP).getString() : "";
            String id = node.isNodeType(MIX_REFERENCEABLE) ? node.getUUID() : "";
            String state = node.hasProperty(CURRENT_STATE_PROP) ? node.getProperty(CURRENT_STATE_PROP).getValue().getString() : "";
            String author = node.hasProperty(EXO_OWNER_PROP) ? node.getProperty(EXO_OWNER_PROP).getString() : "";
            Calendar lastModified = node.hasNode(JCR_CONTENT) ? node.getNode(JCR_CONTENT).getProperty(JCR_LAST_MODIFIED_PROP).getValue().getDate() : null;
            Calendar dateCreated = node.hasProperty(EXO_DATE_CREATED_PROP) ? node.getProperty(EXO_DATE_CREATED_PROP).getValue().getDate() : null;
            String lastEditor = node.hasProperty(EXO_LAST_MODIFIER_PROP) ? node.getProperty(EXO_LAST_MODIFIER_PROP).getValue().getString() : "";
            Document document = doc = new Document(id, node.getName(), title, node.getPath(), ws, state, author, lastEditor, lastModified, dateCreated);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDocumentUrlInPersonalDocuments(Node currentNode, String username) throws Exception {
        Node rootNode = null;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = null;
        try {
            String sharedLink;
            ManageableRepository repository = this.repoService.getCurrentRepository();
            session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            this.nodeHierarchyCreator.getJcrPath("usersPath");
            rootNode = (Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("usersPath") + this.getPrivatePath(username));
            String string = sharedLink = this.getSharedLink(currentNode, rootNode);
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public String getDocumentUrlInSpaceDocuments(Node currentNode, String spaceId) throws Exception {
        Node rootNode = null;
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            ManageableRepository repository = this.repoService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            this.nodeHierarchyCreator.getJcrPath("groupsPath");
            rootNode = (Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("groupsPath") + spaceId);
            String sharedLink = this.getSharedLink(currentNode, rootNode);
            return sharedLink;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getShortLinkInDocumentsApp(String workspaceName, String nodeId) throws Exception {
        StringBuilder url = new StringBuilder();
        String containerName = this.portalContainerInfo.getContainerName();
        url.append("/").append(containerName).append("/private/").append(CommonsUtils.getRestContextName()).append("/documents/view/").append(workspaceName).append("/").append(nodeId);
        return url.toString();
    }

    @Override
    public String getLinkInDocumentsApp(String nodePath) throws Exception {
        boolean isAnonymous;
        String userId = ConversationState.getCurrent() != null ? ConversationState.getCurrent().getIdentity().getUserId() : null;
        boolean bl = isAnonymous = userId == null || userId.isEmpty() || userId.equals(IdentityConstants.ANONIM);
        if (nodePath == null || isAnonymous) {
            return null;
        }
        DriveData drive = this.getDriveOfNode(nodePath);
        return this.getLinkInDocumentsApp(nodePath, drive);
    }

    @Override
    public String getLinkInDocumentsAppByIdentifier(String nodeIdentifier) throws Exception {
        boolean isAnonymous;
        String userId = ConversationState.getCurrent() != null ? ConversationState.getCurrent().getIdentity().getUserId() : null;
        boolean bl = isAnonymous = userId == null || userId.isEmpty() || userId.equals(IdentityConstants.ANONIM);
        if (nodeIdentifier == null || isAnonymous) {
            return null;
        }
        DriveData drive = this.getDriveOfNodeByIdentifier(nodeIdentifier);
        return this.getLinkInDocumentsAppByIdentifier(nodeIdentifier, drive);
    }

    @Override
    public String getLinkInDocumentsApp(String nodePath, DriveData drive) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        ManageableRepository repository = this.repoService.getCurrentRepository();
        Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        Node node = (Node)session.getItem(nodePath);
        return this.getLinkInDocumentsAppByIdentifier(((NodeImpl)node).getIdentifier(), drive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getLinkInDocumentsAppByIdentifier(String nodeIdentifier, DriveData drive) throws Exception {
        if (nodeIdentifier == null) {
            return null;
        }
        String containerName = this.portalContainerInfo.getContainerName();
        StringBuilder url = new StringBuilder();
        url.append("/").append(containerName);
        if (drive == null) {
            SiteKey siteKey = this.getDefaultSiteKey();
            url.append("/").append(siteKey.getName()).append("/").append(DOCUMENTS_APP_NAVIGATION_NODE_NAME).append(DOCUMENT_NOT_FOUND);
            return url.toString();
        }
        if (drive.getName().startsWith(".spaces")) {
            String groupId = drive.getParameters().get("groupId");
            if (groupId == null) throw new Exception("Cannot get group id from node path " + nodeIdentifier);
            String rootNavigation = this.getSpaceRootNavigationNodeURI(groupId.replace(".", "/"));
            String groupPageName = rootNavigation + "/documents";
            url.append("/g/").append(groupId.replace("/", ":")).append("/").append(groupPageName);
            return url.append("?documentPreviewId=").append(nodeIdentifier).toString();
        } else {
            SiteKey siteKey = this.getDefaultSiteKey();
            url.append("/").append(siteKey.getName()).append("/").append(DOCUMENTS_APP_NAVIGATION_NODE_NAME);
        }
        return url.append("?documentPreviewId=").append(nodeIdentifier).toString();
    }

    protected String getSpaceRootNavigationNodeURI(String spaceGroupId) throws Exception {
        org.gatein.api.navigation.Node navigationRootNode;
        String navigationName = null;
        Navigation spaceNavigation = this.portal.getNavigation(new SiteId(SiteType.SPACE, spaceGroupId));
        if (spaceNavigation != null && (navigationRootNode = spaceNavigation.getRootNode(Nodes.visitChildren())) != null && navigationRootNode.iterator().hasNext()) {
            org.gatein.api.navigation.Node node = (org.gatein.api.navigation.Node)navigationRootNode.iterator().next();
            navigationName = node.getName();
        }
        return navigationName;
    }

    @Override
    public DriveData getDriveOfNode(String nodePath) throws Exception {
        if (ConversationState.getCurrent() == null) {
            return null;
        }
        return this.getDriveOfNode(nodePath, ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
    }

    @Override
    public DriveData getDriveOfNodeByIdentifier(String nodeIdentifier) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        ManageableRepository repository = this.repoService.getCurrentRepository();
        Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        Node node = session.getNodeByUUID(nodeIdentifier);
        if (ConversationState.getCurrent() == null) {
            return null;
        }
        return this.getDriveOfNode(node.getPath(), ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
    }

    @Override
    public DriveData getDriveOfNode(String nodePath, String userId, List<String> memberships) throws Exception {
        int groupDocumentsRootNodeName;
        DriveData nodeDrive = null;
        List<DriveData> drives = this.manageDriveService.getDriveByUserRoles(userId, memberships);
        String[] splitedPath = nodePath.split("/");
        if (splitedPath != null && splitedPath.length >= 6 && splitedPath[1].equals("Users") && (nodeDrive = splitedPath[5].equals(userId) ? this.manageDriveService.getDriveByName("Personal Documents") : this.manageDriveService.getDriveByName("User Documents")) != null) {
            nodeDrive = nodeDrive.clone();
            nodeDrive.getParameters().put("userId", splitedPath[2] + "/" + splitedPath[3] + "/" + splitedPath[4] + "/" + splitedPath[5]);
        }
        if (splitedPath != null && splitedPath.length >= 2 && splitedPath[1].equals("Groups") && (groupDocumentsRootNodeName = nodePath.indexOf("/Documents")) >= 0) {
            String groupId = nodePath.substring("Groups".length() + 1, groupDocumentsRootNodeName);
            nodeDrive = this.manageDriveService.getDriveByName(groupId.replaceAll("/", "."));
        }
        if (nodeDrive == null) {
            for (DriveData drive : drives) {
                if (!nodePath.startsWith(drive.getResolvedHomePath()) || nodeDrive != null && nodeDrive.getResolvedHomePath().length() >= drive.getResolvedHomePath().length()) continue;
                nodeDrive = drive;
            }
        }
        return nodeDrive;
    }

    protected UserPortalConfig getDefaultUserPortalConfig() throws Exception {
        UserPortalConfigService userPortalConfigSer = WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        return userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
    }

    protected SiteKey getDefaultSiteKey() throws Exception {
        UserPortalConfig prc = this.getDefaultUserPortalConfig();
        if (prc == null) {
            return null;
        }
        return SiteKey.portal((String)prc.getPortalConfig().getName());
    }

    private String getPrivatePath(String user) {
        return "/" + user.substring(0, 1) + "___/" + user.substring(0, 2) + "___/" + user.substring(0, 3) + "___/" + user + "/Private";
    }

    private String getSharedLink(Node currentNode, Node rootNode) {
        Node shared = null;
        Node link = null;
        try {
            rootNode = rootNode.getNode(DOCUMENTS_NODE);
            shared = !rootNode.hasNode(SHARED_NODE) ? rootNode.addNode(SHARED_NODE) : rootNode.getNode(SHARED_NODE);
            if (currentNode.isNodeType(EXO_SYMLINK)) {
                currentNode = this.linkManager.getTarget(currentNode);
            }
            String currentNodeWorkspaceName = currentNode.getSession().getWorkspace().getName();
            List<Node> nodes = this.linkManager.getNodeSymlinksUnderFolder(((ExtendedNode)currentNode).getIdentifier(), shared.getPath(), currentNodeWorkspaceName);
            if (!nodes.isEmpty()) {
                link = nodes.get(0);
            }
            if (link == null && currentNode.isNodeType(NT_FILE)) {
                link = currentNode;
            }
            return CommonsUtils.getCurrentDomain() + this.getShortLinkInDocumentsApp(link.getSession().getWorkspace().getName(), ((NodeImpl)link).getInternalIdentifier());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public void addDocumentTemplatePlugin(ComponentPlugin plugin) {
        Class<NewDocumentTemplatePlugin> pclass = NewDocumentTemplatePlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            NewDocumentTemplatePlugin newPlugin = (NewDocumentTemplatePlugin)pclass.cast(plugin);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding NewDocumentTemplatePlugin [{}]", new Object[]{newPlugin.toString()});
            }
            this.templateProviders.add(new NewDocumentTemplateProviderImpl(newPlugin, this));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered NewDocumentTemplatePlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The NewDocumentTemplatePlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    @Override
    public void addDocumentEditorPlugin(ComponentPlugin plugin) {
        Class<DocumentEditor> pclass = DocumentEditor.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            DocumentEditor editor = (DocumentEditor)pclass.cast(plugin);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding DocumentEditor [{}]", new Object[]{editor.toString()});
            }
            this.editorProviders.add(new DocumentEditorProviderImpl(editor, this.settingService, this.identityManager, this.organizationService));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered DocumentEditor instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The DocumentEditor plugin is not an instance of " + pclass.getName()));
        }
    }

    @Override
    public Node createDocumentFromTemplate(Node currentNode, String title, NewDocumentTemplate template) throws Exception {
        String cleanedName;
        Node addedNode;
        InputStream data = new ByteArrayInputStream(new byte[0]);
        if (template.getPath() != null && !template.getPath().trim().isEmpty()) {
            data = this.configurationManager.getInputStream(template.getPath());
            DocumentMetadataPlugin metadataPlugin = this.metadataPlugins.get(template.getExtension());
            if (metadataPlugin != null && metadataPlugin.isExtensionSupported(template.getExtension())) {
                try {
                    String userId = ConversationState.getCurrent().getIdentity().getUserId();
                    data = metadataPlugin.updateMetadata(template.getExtension(), data, new Date(), this.getCurrentUserDisplayName(userId), this.getCurrentUserLanguage(userId));
                }
                catch (DocumentExtensionNotSupportedException e) {
                    LOG.error((Object)"Document extension is not supported by metadata plugin.", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)"Couldn't add metadata to the document from template.", (Throwable)e);
                }
            } else {
                LOG.warn("Couldn't find appropriate metadata plugin for the {} extension.", new Object[]{template.getExtension()});
            }
        }
        if (!(addedNode = currentNode.addNode((cleanedName = Utils.cleanName(Utils.cleanNameWithAccents(title))).toLowerCase(), NT_FILE)).hasProperty(EXO_TITLE_PROP)) {
            addedNode.addMixin(EXO_RSS_ENABLE_PROP);
        }
        if (addedNode.canAddMixin(MIX_VERSIONABLE)) {
            addedNode.addMixin(MIX_VERSIONABLE);
        }
        addedNode.setProperty(EXO_TITLE_PROP, title);
        Node content = addedNode.addNode(JCR_CONTENT, NT_RESOURCE);
        content.setProperty(JCR_DATA, data);
        content.setProperty(JCR_MIME_TYPE, template.getMimeType());
        content.setProperty(JCR_LAST_MODIFIED_PROP, (Calendar)new GregorianCalendar());
        ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
        listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)addedNode);
        currentNode.save();
        data.close();
        AutoVersionService autoVersionService = WCMCoreUtils.getService(AutoVersionService.class);
        if (autoVersionService != null) {
            autoVersionService.autoVersion(addedNode);
        }
        return addedNode;
    }

    @Override
    public List<NewDocumentTemplateProvider> getNewDocumentTemplateProviders() {
        return this.unmodifiebleTemplateProviders;
    }

    @Override
    public void addDocumentMetadataPlugin(ComponentPlugin plugin) {
        Class<DocumentMetadataPlugin> pclass = DocumentMetadataPlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            DocumentMetadataPlugin newPlugin = (DocumentMetadataPlugin)pclass.cast(plugin);
            LOG.info("Adding DocumentMetadataPlugin [{}]", new Object[]{plugin.toString()});
            newPlugin.getSupportedExtensions().forEach(ext -> this.metadataPlugins.put((String)ext, newPlugin));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered DocumentMetadataPlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The DocumentMetadataPlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    @Override
    public void setCommonEditorPlugin(ComponentPlugin plugin) {
        Class<CommonEditorPlugin> pclass = CommonEditorPlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            CommonEditorPlugin commonPlugin = (CommonEditorPlugin)pclass.cast(plugin);
            LOG.info("Setting CommonEditorPlugin [{}]", new Object[]{plugin.toString()});
            this.commonEditorPlugin = commonPlugin;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered CommonEditorPlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The CommonEditorPlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    @Override
    public void savePreferredEditor(String userId, String provider, String uuid, String workspace) throws RepositoryException {
        Node targetNode = this.nodeByUUID(uuid, workspace);
        this.invokeWithLockToken(targetNode, node -> {
            if (node.canAddMixin(EXO_DOCUMENT)) {
                node.addMixin(EXO_DOCUMENT);
            }
            Node userPreferences = !node.hasNode(userId) ? node.addNode(userId, EXO_USER_PREFFERENCES) : node.getNode(userId);
            userPreferences.setProperty(EXO_PREFFERED_EDITOR, provider);
            node.save();
        });
    }

    @Override
    public String getPreferredEditor(String userId, String uuid, String workspace) throws RepositoryException {
        Node userPreferences;
        Node node = this.nodeByUUID(uuid, workspace);
        if (node.hasNode(userId) && (userPreferences = node.getNode(userId)).hasProperty(EXO_PREFFERED_EDITOR)) {
            return userPreferences.getProperty(EXO_PREFFERED_EDITOR).getString();
        }
        return null;
    }

    @Override
    public List<DocumentEditorProvider> getDocumentEditorProviders() {
        return this.unmodifiebleEditorProviders;
    }

    @Override
    public void saveCurrentDocumentProvider(String uuid, String workspace, String provider) throws RepositoryException {
        Session systemSession = this.repoService.getCurrentRepository().getSystemSession(workspace);
        Node systemNode = systemSession.getNodeByUUID(uuid);
        if (systemNode.isNodeType(EXO_SYMLINK)) {
            systemNode = this.linkManager.getTarget(systemNode, true);
        }
        String userId = systemNode.getProperty(EXO_LAST_MODIFIER_PROP).getString();
        WCMCoreUtils.invokeUserSession(userId, sessionProvider -> {
            Session session = sessionProvider.getSession(workspace, this.repoService.getCurrentRepository());
            Node targetNode = session.getNodeByUUID(uuid);
            if (targetNode.isNodeType(EXO_SYMLINK)) {
                targetNode = this.linkManager.getTarget(targetNode);
            }
            this.invokeWithLockToken(targetNode, node -> {
                if (node.canAddMixin(EXO_DOCUMENT)) {
                    node.addMixin(EXO_DOCUMENT);
                }
                String previousProvider = null;
                if (node.hasProperty(EXO_CURRENT_PROVIDER)) {
                    previousProvider = node.getProperty(EXO_CURRENT_PROVIDER).getString();
                }
                node.setProperty(EXO_CURRENT_PROVIDER, provider);
                node.setProperty(EXO_EDITORS_RUNTIME_ID, this.editorsRuntimeId);
                node.save();
                if (previousProvider != null && provider == null) {
                    try {
                        DocumentEditorProvider editorProvider = this.getEditorProvider(previousProvider);
                        editorProvider.onLastEditorClosed(node.getUUID(), workspace);
                    }
                    catch (DocumentEditorProviderNotFoundException e) {
                        LOG.error("Cannot find {} editor provider. {}", new Object[]{previousProvider, e.getMessage()});
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot execute last editor closed handler", (Throwable)e);
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentDocumentProvider(String uuid, String workspace) throws RepositoryException {
        Session systemSession = null;
        try {
            String currentRuntimeId;
            systemSession = this.repoService.getCurrentRepository().getSystemSession(workspace);
            ExtendedSession extendedSessionSession = (ExtendedSession)systemSession;
            Node node = extendedSessionSession.getNodeByIdentifier(uuid);
            if (node.isNodeType(EXO_SYMLINK)) {
                node = this.linkManager.getTarget(node, true);
            }
            String provider = node.hasProperty(EXO_CURRENT_PROVIDER) ? node.getProperty(EXO_CURRENT_PROVIDER).getString() : null;
            String string = currentRuntimeId = node.hasProperty(EXO_EDITORS_RUNTIME_ID) ? node.getProperty(EXO_EDITORS_RUNTIME_ID).getString() : null;
            if (currentRuntimeId != null && this.editorsRuntimeId.equals(currentRuntimeId)) {
                String string2 = provider;
                return string2;
            }
            String userId = node.getProperty(EXO_LAST_MODIFIER_PROP).getString();
            WCMCoreUtils.invokeUserSession(userId, sessionProvider -> {
                try {
                    Node tagetNode = extendedSessionSession.getNodeByIdentifier(uuid);
                    if (tagetNode.isNodeType(EXO_SYMLINK)) {
                        tagetNode = this.linkManager.getTarget(tagetNode);
                    }
                    this.invokeWithLockToken(tagetNode, document -> {
                        if (document.canAddMixin(EXO_DOCUMENT)) {
                            document.addMixin(EXO_DOCUMENT);
                        }
                        document.setProperty(EXO_CURRENT_PROVIDER, (String)null);
                        document.setProperty(EXO_EDITORS_RUNTIME_ID, this.editorsRuntimeId);
                        document.save();
                    });
                }
                finally {
                    sessionProvider.close();
                }
            });
            String string3 = null;
            return string3;
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    @Override
    public DocumentEditorProvider getEditorProvider(String provider) throws DocumentEditorProviderNotFoundException {
        return this.getDocumentEditorProviders().stream().filter(editorProvider -> editorProvider.getProviderName().equals(provider)).findFirst().orElseThrow(DocumentEditorProviderNotFoundException::new);
    }

    @Override
    public long getEditorsIdleTimeout() {
        return this.commonEditorPlugin != null ? this.commonEditorPlugin.getIdleTimeout() : 1800000L;
    }

    @Override
    public List<Document> getDocumentsByFolder(String folder, String condition, long limit) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        if (folder != null) {
            folder = DocumentServiceImpl.escapeSQLString(folder);
            String query = "select * from nt:base where jcr:path like '" + folder + "/%' and (exo:primaryType = 'nt:file' or jcr:primaryType = 'nt:file') and (exo:fileType like '%pdf%' or exo:fileType like '%text%' or exo:fileType like '%opendocument%' or exo:fileType like '%odt%' or exo:fileType like '%officedocument%' or exo:fileType like '%ms%') and not (jcr:mixinTypes like '%exo:exoDlpItem%' )" + (condition != null ? condition : "") + " order by exo:dateModified DESC";
            return this.getDocumentsByQuery(query, limit);
        }
        return documents;
    }

    private static String escapeSQLString(String value) {
        int length;
        int newLength = length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                    continue block9;
                }
            }
        }
        if (length == newLength) {
            return value;
        }
        StringBuilder sb = new StringBuilder(newLength);
        block10: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\0");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public List<Document> getDocumentsByQuery(String query, long limit) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        if (query != null) {
            ManageableRepository manageableRepository = this.repoService.getCurrentRepository();
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryImpl documentsQuery = (QueryImpl)queryManager.createQuery(query, "sql");
            documentsQuery.setLimit(limit);
            QueryResult queryResult = documentsQuery.execute();
            NodeIterator documentsIterator = queryResult.getNodes();
            while (documentsIterator.hasNext()) {
                Node documentNode;
                Node originalDocumentNode = documentNode = documentsIterator.nextNode();
                if (documentNode.isNodeType(EXO_SYMLINK)) {
                    originalDocumentNode = this.linkManager.getTarget(documentNode);
                }
                String documentNodePath = originalDocumentNode.getPath();
                Document document = new Document(originalDocumentNode.getUUID(), Utils.getTitle(originalDocumentNode), documentNodePath, Utils.getSearchDocumentDrive(documentNode), Utils.getFileType(originalDocumentNode), Utils.getDate(documentNode).getTime().getTime(), this.getFilePreviewBreadCrumb(documentNode), this.getLinkInDocumentsApp(documentNode.getPath()), this.getDownloadUri(originalDocumentNode), VersionHistoryUtils.getVersion(originalDocumentNode), Utils.fileSize(originalDocumentNode), this.getDocLastModifier(originalDocumentNode));
                documents.add(document);
            }
            session.logout();
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> getFavoriteDocuments(String userId, int limit) throws Exception {
        try (SessionProvider sessionProvider = this.getUserSessionProvider(userId);){
            ArrayList<Document> documents = new ArrayList<Document>();
            List<Node> nodes = this.favoriteService.getAllFavoriteNodesByUser(userId, limit);
            for (Node node : nodes) {
                Document document = new Document(node.getUUID(), Utils.getTitle(node), node.getPath(), Utils.getSearchDocumentDrive(node), Utils.getFileType(node), Utils.getDate(node).getTime().getTime(), this.getFilePreviewBreadCrumb(node), this.getLinkInDocumentsApp(node.getPath()), this.getDownloadUri(node), VersionHistoryUtils.getVersion(node), Utils.fileSize(node), this.getDocLastModifier(node));
                documents.add(document);
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> getSharedDocuments(String userId, int limit) throws Exception {
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userId);
            Node userPrivateNode = userNode.getNode("Private");
            Node userDocumentsNode = userPrivateNode.getNode(DOCUMENTS_NODE);
            String sharedFolder = null;
            if (userDocumentsNode.hasNode(SHARED_NODE)) {
                sharedFolder = userDocumentsNode.getNode(SHARED_NODE).getPath();
            }
            List<Document> list = this.getDocumentsByFolder(sharedFolder, null, limit);
            return list;
        }
    }

    protected String getCurrentUserDisplayName(String userId) {
        try {
            return this.organizationService.getUserHandler().findUserByName(userId).getDisplayName();
        }
        catch (Exception e) {
            LOG.error((Object)("Error searching user " + userId), (Throwable)e);
            return userId;
        }
    }

    protected String getCurrentUserLanguage(String userId) {
        try {
            LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
            LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
            String lang = null;
            if (localePolicy != null) {
                Locale locale = localePolicy.determineLocale(localeCtx);
                lang = locale.toString();
            }
            return lang;
        }
        catch (Exception e) {
            LOG.error((Object)("Error searching user " + userId), (Throwable)e);
            return null;
        }
    }

    protected Node nodeByUUID(String uuid, String workspace) throws RepositoryException {
        if (workspace == null) {
            workspace = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        ExtendedSession extendedSession = (ExtendedSession)sp.getSession(workspace, this.repoService.getCurrentRepository());
        return extendedSession.getNodeByIdentifier(uuid);
    }

    @Override
    public LinkedHashMap<String, String> getFilePreviewBreadCrumb(Node fileNode) {
        LinkedHashMap<String, String> fileBreadCrumb = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> docFolderBreadCrumb = this.getDocFolderRelativePathWithLinks(fileNode);
        if (docFolderBreadCrumb != null) {
            int breadCrumbSize = docFolderBreadCrumb.size();
            int folderIndex = 0;
            for (String folderName : docFolderBreadCrumb.keySet()) {
                String folderPath = docFolderBreadCrumb.get(folderName);
                folderName = folderName.replaceAll("_" + (breadCrumbSize - folderIndex - 1) + "$", "");
                folderPath = folderPath.replace("%27", "\\'");
                fileBreadCrumb.put(folderName, folderPath);
                ++folderIndex;
            }
        }
        return fileBreadCrumb;
    }

    private LinkedHashMap<String, String> getDocFolderRelativePathWithLinks(Node fileNode) {
        LinkedHashMap<Object, String> reversedFolderPathWithLinks;
        block23: {
            reversedFolderPathWithLinks = new LinkedHashMap<Object, String>();
            try {
                String parentPath;
                String driveName;
                DriveData drive;
                block24: {
                    drive = this.getDriveOfNode(fileNode.getPath());
                    if (drive == null) break block23;
                    Map<String, String> parameters = drive.getParameters();
                    driveName = drive.getName();
                    if (parameters != null) {
                        String userId;
                        if (parameters.containsKey("groupId")) {
                            String groupId = parameters.get("groupId");
                            if (StringUtils.isNotBlank((CharSequence)groupId)) {
                                try {
                                    groupId = groupId.replaceAll("\\.", "/");
                                    if (groupId.startsWith("/spaces")) {
                                        SpaceService spaceService = WCMCoreUtils.getService(SpaceService.class);
                                        Space space = spaceService.getSpaceByGroupId(groupId);
                                        if (space != null) {
                                            driveName = space.getDisplayName();
                                        }
                                        break block24;
                                    }
                                    Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
                                    driveName = group == null ? driveName : group.getLabel();
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)("Can't get drive name for group with id '" + groupId + "'"), (Throwable)e);
                                }
                            }
                        } else if (parameters.containsKey("userId") && StringUtils.isNotBlank((CharSequence)(userId = parameters.get("userId")))) {
                            try {
                                userId = userId.indexOf("/") >= 0 ? userId.substring(userId.lastIndexOf("/") + 1) : userId;
                                User user = this.organizationService.getUserHandler().findUserByName(userId);
                                if (user != null) {
                                    driveName = user.getDisplayName();
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("Can't get drive name for user with id '" + userId + "'"), (Throwable)e);
                            }
                        }
                    }
                }
                String driveHomePath = drive.getResolvedHomePath();
                String drivePublicFolderHomePath = null;
                if ("Personal Documents".equals(drive.getName())) {
                    drivePublicFolderHomePath = driveHomePath.replace("/Private", "/Public");
                }
                for (Node parentContentNode = fileNode.getParent(); parentContentNode != null && (parentPath = parentContentNode.getPath()).contains(driveHomePath) && (driveHomePath.equals("/") || !parentPath.equals("/")); parentContentNode = parentContentNode.getParent()) {
                    if (drivePublicFolderHomePath != null && parentPath.equals(drivePublicFolderHomePath)) {
                        reversedFolderPathWithLinks.put("Public", this.getDocOpenUri(parentContentNode));
                    } else {
                        String nodeName = parentPath.equals(driveHomePath) ? driveName : (parentContentNode.hasProperty(EXO_TITLE_PROP) ? parentContentNode.getProperty(EXO_TITLE_PROP).getString() : parentContentNode.getName());
                        reversedFolderPathWithLinks.put(nodeName + "_" + reversedFolderPathWithLinks.size(), this.getDocOpenUri(parentContentNode));
                        if (!parentPath.equals("/") && !parentPath.equals(driveHomePath)) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (AccessDeniedException ade) {
                LOG.warn((Object)ade.getMessage());
            }
            catch (Exception re) {
                LOG.error((Object)("Cannot retrieve path of doc " + re.getMessage()), (Throwable)re);
            }
        }
        LinkedHashMap<String, String> fileNodePathWithLinks = new LinkedHashMap<String, String>();
        if (reversedFolderPathWithLinks.size() > 1) {
            ArrayList entries = new ArrayList(reversedFolderPathWithLinks.entrySet());
            for (int j = entries.size() - 1; j >= 0; --j) {
                Map.Entry entry = (Map.Entry)entries.get(j);
                fileNodePathWithLinks.put(StringEscapeUtils.escapeHtml4((String)((String)entry.getKey())), (String)entry.getValue());
            }
        } else {
            fileNodePathWithLinks = reversedFolderPathWithLinks;
        }
        return fileNodePathWithLinks;
    }

    private String getDocOpenUri(Node fileNode) throws Exception {
        String uri = "";
        String nodePath = fileNode.getPath();
        if (nodePath != null) {
            try {
                if (nodePath.endsWith("/")) {
                    nodePath = nodePath.replaceAll("/$", "");
                }
                uri = this.getLinkInDocumentsApp(nodePath, this.getDriveOfNode(nodePath));
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot get document open URI of node " + nodePath + " : " + e.getMessage()), (Throwable)e);
                uri = "";
            }
        }
        return uri;
    }

    private String getDownloadUri(Node fileNode) throws Exception {
        StringBuffer downloadUrl = new StringBuffer();
        String restContextName = WCMCoreUtils.getRestContextName();
        String workspaceName = fileNode.getSession().getWorkspace().getName();
        downloadUrl.append('/').append(restContextName).append("/jcr/").append(WCMCoreUtils.getRepository().getConfiguration().getName()).append('/').append(workspaceName).append(fileNode.getPath());
        return downloadUrl.toString().replaceFirst(fileNode.getName(), URLEncoder.encode(fileNode.getName(), "UTF-8"));
    }

    private String getDocLastModifier(Node node) {
        String docLastModifier = "";
        try {
            if (node.isNodeType(EXO_SYMLINK)) {
                String uuid = node.getProperty("exo:uuid").getString();
                node = node.getSession().getNodeByUUID(uuid);
            }
            if (node != null && node.hasProperty(EXO_LAST_MODIFIER_PROP)) {
                String docLastModifierUsername = node.getProperty(EXO_LAST_MODIFIER_PROP).getString();
                docLastModifier = this.getUserFullName(docLastModifierUsername);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get document last modifier : " + e.getMessage()), (Throwable)e);
        }
        return docLastModifier;
    }

    private String getUserFullName(String userId) {
        User user;
        String currentUser;
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ConversationState currentUserState = ConversationState.getCurrent();
        Identity currentUserIdentity = currentUserState.getIdentity();
        if (currentUserIdentity != null && (currentUser = currentUserIdentity.getUserId()) != null && currentUser.equals(userId) && (user = (User)currentUserState.getAttribute("UserProfile")) != null) {
            return user.getDisplayName();
        }
        try {
            User user2 = this.organizationService.getUserHandler().findUserByName(userId);
            if (user2 != null) {
                return user2.getDisplayName();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get information of user " + userId + " : " + e.getMessage()), (Throwable)e);
        }
        return "";
    }

    protected void invokeWithLockToken(Node node, RepositoryConsumer<Node> handler) throws RepositoryException {
        String lockToken = null;
        if (node.isLocked()) {
            String lockOwner = node.getLock().getLockOwner();
            try {
                lockToken = LockUtil.getLockTokenOfUser(node, lockOwner);
            }
            catch (Exception e) {
                LOG.error("Cannot get lock token for node {}, {} ", new Object[]{node.getUUID(), e.getMessage()});
            }
            if (lockToken == null) {
                throw new IllegalStateException("Cannot get lock token for node: " + node.getUUID());
            }
            node.getSession().addLockToken(lockToken);
        }
        handler.accept(node);
        if (lockToken != null) {
            node.getSession().removeLockToken(lockToken);
        }
    }

    private SessionProvider getUserSessionProvider(String username) {
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                aclIdentity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving user ACL identity with name : " + username, e);
            }
        }
        SessionProvider sessionProvider = new SessionProvider(new ConversationState(aclIdentity));
        try {
            ManageableRepository repository = this.repoService.getCurrentRepository();
            String workspace = repository.getConfiguration().getDefaultWorkspaceName();
            sessionProvider.setCurrentRepository(repository);
            sessionProvider.setCurrentWorkspace(workspace);
            return sessionProvider;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Can't build a SessionProvider", e);
        }
    }
}

