/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.listener.analytics;

import javax.jcr.Node;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AnalyticsDocumentsListener
extends Listener<String, Node> {
    private static final String UPLOAD_DOCUMENT_NEW_APP_OPERATION_NAME = "documentUploadedNewApp";
    private static final String UPLOAD_DOCUMENT_OLD_APP_OPERATION_NAME = "documentUploadedOldApp";
    private static final String GROUPS_SPACES_PARENT_FOLDER = "/Groups/spaces/";
    private IdentityManager identityManager;
    private SpaceService spaceService;

    public void onEvent(Event<String, Node> event) throws Exception {
        Node data = (Node)event.getData();
        String operation = event.getEventName().equals("exo.upload.doc.newApp") ? UPLOAD_DOCUMENT_NEW_APP_OPERATION_NAME : UPLOAD_DOCUMENT_OLD_APP_OPERATION_NAME;
        long userId = 0L;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", (String)event.getSource());
        if (identity != null) {
            userId = Long.parseLong(identity.getId());
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("documents");
        statisticData.setSubModule("event");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter("documentsName", (Object)data.getName());
        statisticData.addParameter("documentsPath", (Object)data.getPath());
        statisticData.addParameter("documentsOwner", (Object)((NodeImpl)data).getACL().getOwner());
        String nodePath = data.getPath();
        this.addSpaceStatistic(statisticData, nodePath);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private void addSpaceStatistic(StatisticData statisticData, String nodePath) {
        String[] nodePathParts;
        if (nodePath.startsWith(GROUPS_SPACES_PARENT_FOLDER) && (nodePathParts = nodePath.split("/")).length > 3) {
            String groupId = "/spaces/" + nodePathParts[3];
            Space space = this.getSpaceService().getSpaceByGroupId(groupId);
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
    }
}

