/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIWhoHasAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/ecm/social-integration/share-document/UIShareDocuments.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={TextChangeActionListener.class}), @EventConfig(listeners={ChangeActionListener.class}), @EventConfig(listeners={ChangePermissionActionListener.class})})
public class UIShareDocuments
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UIShareDocuments.class);
    private static final String SHARECONTENT_BUNDLE_LOCATION = "locale.extension.SocialIntegration";
    private static final String SHARE_OPTION_CANVEW = "UIShareDocuments.label.option.read";
    private static final String SHARE_OPTION_CANMODIFY = "UIShareDocuments.label.option.modify";
    private static final String SHARE_PERMISSION_VIEW = "read";
    private static final String SHARE_PERMISSION_MODIFY = "modify";
    private static final String SPACE_PREFIX1 = "space::";
    private static final String SPACE_PREFIX2 = "*:/spaces/";
    private static final String LOGIN_INITIALURI = "/login?initialURI=/";
    private String permission = "read";
    private boolean permDropDown = false;
    List<String> entries = new ArrayList<String>();
    public String comment = "";
    private NodeLocation node;
    private static final String USER_SUGGESTER = "userSuggester";
    private Map<String, String> permissions;

    public boolean hasPermissionDropDown() {
        return this.permDropDown;
    }

    public void setPermissionDropDown(boolean permDropDown) {
        this.permDropDown = permDropDown;
    }

    public void removePermission(String id) {
        this.permissions.remove(id);
        if (this.entries.contains(id)) {
            this.entries.remove(id);
        }
    }

    public void updatePermission(String id, String permission) {
        this.permissions.put(id, permission);
    }

    public boolean isGroupType(String name) {
        return name != null && name.startsWith("*:/") && !name.startsWith(SPACE_PREFIX2);
    }

    public static String getPortalLoginRedirectURL() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(portal).append(LOGIN_INITIALURI).append(portal).append("/").toString();
    }

    public void addPermission() throws Exception {
        List<String> entries = this.entries;
        UIFormStringInput input = this.getUIStringInput(USER_SUGGESTER);
        String value = (String)input.getValue();
        if (value != null && !value.trim().isEmpty()) {
            input.setValue(null);
            String[] selectedIdentities = value.split(",");
            String name = null;
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (this.hasPermissionDropDown() && (this.canEdit(identity) || this.isOwner(identity.getUserId()))) {
                String permission = this.getPermission();
                LinkedList<String> notFound = new LinkedList<String>();
                boolean i = false;
                if (selectedIdentities != null) {
                    for (int idx = 0; idx < selectedIdentities.length; ++idx) {
                        name = selectedIdentities[idx].trim();
                        if (name.length() <= 0) continue;
                        if (UIShareDocuments.isExisting(name) && !this.isOwner(name)) {
                            if (name.startsWith(SPACE_PREFIX1)) {
                                name = name.replace(SPACE_PREFIX1, SPACE_PREFIX2);
                            }
                            if (this.hasPermission(name, permission)) continue;
                            this.updatePermission(name, permission);
                            ((UIWhoHasAccess)this.getChild(UIWhoHasAccess.class)).update(name, permission);
                            if (entries.contains(name)) continue;
                            entries.add(name);
                            continue;
                        }
                        if (this.isOwner(name)) {
                            throw new PermissionException(PermissionException.Code.INVALID_OWNER);
                        }
                        notFound.add(name);
                    }
                }
                WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                requestContext.addUIComponentToUpdateByAjax((UIComponent)this);
                requestContext.getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedEntry('" + entries + "');");
                if (notFound.size() > 0) {
                    throw new PermissionException(PermissionException.Code.NOT_FOUND, ((Object)notFound).toString());
                }
            } else {
                throw new PermissionException(PermissionException.Code.NO_PERMISSION);
            }
        }
    }

    private void setPermission(String permission) {
        this.permission = permission;
    }

    private String getPermission() {
        return this.permission;
    }

    private static boolean isExisting(String name) {
        if (name.contains(SPACE_PREFIX1)) {
            SpaceService service = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
            return service.getSpaceByPrettyName(name.split("::")[1]) != null;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateIdentity("organization", name, true) != null;
    }

    private boolean hasPermission(String name, String permission) {
        if (this.permissions.containsKey(name)) {
            return this.permissions.get(name).equals(permission);
        }
        return false;
    }

    public String getValue() {
        return (String)this.getUIStringInput(USER_SUGGESTER).getValue();
    }

    public void init() {
        block2: {
            try {
                this.addChild(UIWhoHasAccess.class, null, null);
                ((UIWhoHasAccess)this.getChild(UIWhoHasAccess.class)).init();
                this.addChild((UIComponent)new UIFormTextAreaInput("textAreaInput", "textAreaInput", ""));
                ExtendedNode currentNode = this.getNode();
                ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(SHARECONTENT_BUNDLE_LOCATION, Util.getPortalRequestContext().getLocale());
                String canView = resourceBundle.getString(SHARE_OPTION_CANVEW);
                String canModify = resourceBundle.getString(SHARE_OPTION_CANMODIFY);
                this.setPermissionDropDown(PermissionUtil.canSetProperty((Node)currentNode));
                this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_SUGGESTER, null, null));
                this.permissions = this.getAllPermissions();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public ExtendedNode getNode() {
        ExtendedNode node = (ExtendedNode)NodeLocation.getNodeByLocation((NodeLocation)this.node);
        try {
            if (node.isNodeType("exo:symlink") && node.hasProperty("exo:uuid")) {
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                return (ExtendedNode)linkManager.getTarget((Node)node);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return node;
    }

    public String getIconURL() {
        try {
            return Utils.getNodeTypeIcon((Node)this.getNode(), (String)"uiIcon24x24");
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public void setSelectedNode(NodeLocation node) {
        this.node = node;
    }

    public Set<String> getWhoHasAccess() {
        HashSet<String> set = new HashSet<String>();
        try {
            for (AccessControlEntry t : this.getNode().getACL().getPermissionEntries()) {
                set.add(t.getIdentity());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return set;
    }

    public boolean canEdit(String username) {
        try {
            AccessControlList controlList = this.getNode().getACL();
            return controlList.getPermissions(username).contains("add_node") && controlList.getPermissions(username).contains("set_property");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean canEdit(Identity identity) {
        try {
            AccessManager accessManager = ((SessionImpl)this.getNode().getSession()).getAccessManager();
            return accessManager.hasPermission(this.getNode().getACL(), new String[]{"add_node", "set_property"}, identity);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getPermission(String name) {
        return this.canEdit(name) ? SHARE_PERMISSION_MODIFY : SHARE_PERMISSION_VIEW;
    }

    public boolean isOwner(String username) {
        try {
            return username.equals(this.getNode().getACL().getOwner());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getOwner() {
        try {
            return this.getNode().getACL().getOwner();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getAllPermissions() {
        return this.getWhoHasAccess().stream().filter(identity -> !IdentityConstants.ANY.equals(identity) && !IdentityConstants.SYSTEM.equals(identity) && !this.isOwner((String)identity)).filter(identity -> !this.isGroupType((String)identity)).collect(Collectors.toMap(Function.identity(), identity -> this.getPermission((String)identity)));
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class PermissionException
    extends Exception {
        private Code error;
        private String data;

        public PermissionException(Code error) {
            this(error, null);
        }

        public PermissionException(Code error, String data) {
            this.error = error;
            this.data = data;
        }

        public Code getError() {
            return this.error;
        }

        public String getData() {
            return this.data;
        }

        public static enum Code {
            NOT_FOUND,
            NO_PERMISSION,
            INVALID_OWNER;

        }
    }

    public static class ChangePermissionActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uicomponent = (UIShareDocuments)((Object)event.getSource());
            if (uicomponent.getPermission().equals(UIShareDocuments.SHARE_PERMISSION_MODIFY)) {
                uicomponent.setPermission(UIShareDocuments.SHARE_PERMISSION_VIEW);
            } else {
                uicomponent.setPermission(UIShareDocuments.SHARE_PERMISSION_MODIFY);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicomponent);
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedEntry('" + uicomponent.entries + "');");
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            IShareDocumentService service = (IShareDocumentService)WCMCoreUtils.getService(IShareDocumentService.class);
            UIApplication uiApp = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
            try {
                uiform.addPermission();
            }
            catch (PermissionException ex) {
                switch (ex.getError()) {
                    case INVALID_OWNER: {
                        uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.InvalidOwner", null, 1));
                        break;
                    }
                    case NOT_FOUND: {
                        uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.Invalid", (Object[])new String[]{ex.getData().replace("[", "").replace("]", "")}, 1));
                        break;
                    }
                    case NO_PERMISSION: {
                        uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoPermission", null, 1));
                        break;
                    }
                    default: {
                        uiApp.addMessage(new ApplicationMessage("Error during add permission", null, 1));
                    }
                }
                return;
            }
            List<String> entries = uiform.entries;
            Map<String, String> permissions = uiform.permissions;
            Set<String> accessList = uiform.getWhoHasAccess();
            ExtendedNode node = uiform.getNode();
            String message = "";
            Identity identity = ConversationState.getCurrent().getIdentity();
            boolean isShared = false;
            if (uiform.isOwner(identity.getUserId()) || uiform.canEdit(identity)) {
                String perm;
                if (((UIFormTextAreaInput)uiform.getChild(UIFormTextAreaInput.class)).getValue() != null) {
                    message = (String)((UIFormTextAreaInput)uiform.getChild(UIFormTextAreaInput.class)).getValue();
                }
                for (String name : accessList) {
                    if (permissions.containsKey(name)) {
                        perm = permissions.get(name);
                        if (!name.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                            service.unpublishDocumentToUser(name, node);
                            service.publishDocumentToUser(name, (Node)node, message, perm);
                        } else {
                            String groupId = name.substring("*:".length());
                            service.unpublishDocumentToSpace(groupId, node);
                            service.publishDocumentToSpace(groupId, (Node)node, message, perm);
                        }
                        isShared = true;
                        continue;
                    }
                    if (!name.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                        service.unpublishDocumentToUser(name, node);
                        continue;
                    }
                    String groupId = name.substring("*:".length());
                    service.unpublishDocumentToSpace(groupId, node);
                }
                if (entries.size() > 0) {
                    for (String entry : entries) {
                        if (entry.equals("") || uiform.isOwner(entry)) continue;
                        perm = permissions.get(entry);
                        if (entry.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                            isShared = true;
                            continue;
                        }
                        service.publishDocumentToUser(entry, (Node)node, message, perm);
                        isShared = true;
                    }
                }
                if (isShared) {
                    uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.success", null, 2));
                }
                ((UIJCRExplorer)uiform.getAncestorOfType(UIJCRExplorer.class)).cancelAction();
            } else {
                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoPermission", null, 1));
            }
        }
    }

    public static class TextChangeActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            uiform.comment = (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class));
        }
    }

    public static class CancelActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            ((UIJCRExplorer)((UIShareDocuments)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    public static class ChangeActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            String permission = UIShareDocuments.SHARE_PERMISSION_VIEW;
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            if (((String)((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).getValue()).equals(UIShareDocuments.SHARE_PERMISSION_MODIFY)) {
                ((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).setValue(UIShareDocuments.SHARE_PERMISSION_VIEW);
            } else {
                ((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).setValue(UIShareDocuments.SHARE_PERMISSION_MODIFY);
                permission = UIShareDocuments.SHARE_PERMISSION_MODIFY;
            }
            UIWhoHasAccess uiWhoHasAccess = (UIWhoHasAccess)uiform.getParent();
            uiWhoHasAccess.updateEntry(uiform.getId(), permission);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiform);
        }
    }
}

