/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeOptionList;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UIChildNodeDefinitionForm
extends UIFormInputSetWithAction {
    public static final String NAMESPACE = "childNamespace";
    public static final String CHILD_NAME = "childNodename";
    public static final String REQUIRED_PRIMARY_TYPE = "requiredPrimaryType";
    public static final String MULTIPLE = "childMultiple";
    public static final String MANDATORY = "childMandatory";
    public static final String AUTOCREATED = "childAutocreated";
    public static final String PROTECTED = "childProtected";
    public static final String PARENTVERSION = "childParentversion";
    public static final String DEFAULT_PRIMARY_TYPE = "defaultPrimaryType";
    public static final String SAME_NAME = "sameNameSiblings";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ACTION_UPDATE_CHILD = "UpdateChild";
    public static final String ACTION_CANCEL_CHILD = "CancelChild";

    public UIChildNodeDefinitionForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> sameNameListItem = new ArrayList<SelectItemOption>();
        sameNameListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        sameNameListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NAMESPACE, NAMESPACE, this.getNamespaces()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CHILD_NAME, CHILD_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DEFAULT_PRIMARY_TYPE, DEFAULT_PRIMARY_TYPE, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(AUTOCREATED, AUTOCREATED, autoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MANDATORY, MANDATORY, mandoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PARENTVERSION, PARENTVERSION, this.getParentVersions()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PROTECTED, PROTECTED, protectedItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SAME_NAME, SAME_NAME, sameNameListItem));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(REQUIRED_PRIMARY_TYPE, REQUIRED_PRIMARY_TYPE, null));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private List<SelectItemOption<String>> getParentVersions() {
        ArrayList<SelectItemOption<String>> versionItem = new ArrayList<SelectItemOption<String>>();
        versionItem.add(new SelectItemOption("COPY", (Object)"1"));
        versionItem.add(new SelectItemOption("VERSION", (Object)"2"));
        versionItem.add(new SelectItemOption("INITIALIZE", (Object)"3"));
        versionItem.add(new SelectItemOption("COMPUTE", (Object)"4"));
        versionItem.add(new SelectItemOption("IGNORE", (Object)"5"));
        versionItem.add(new SelectItemOption("ABORT", (Object)"6"));
        return versionItem;
    }

    private List<SelectItemOption<String>> getNamespaces() throws Exception {
        ArrayList<SelectItemOption<String>> namespacesOptions = new ArrayList<SelectItemOption<String>>();
        String[] namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < namespaces.length; ++i) {
            namespacesOptions.add((SelectItemOption<String>)new SelectItemOption(namespaces[i], (Object)namespaces[i]));
        }
        return namespacesOptions;
    }

    public void refresh() throws Exception {
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> sameNameListItem = new ArrayList<SelectItemOption>();
        sameNameListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        sameNameListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.getUIFormSelectBox(NAMESPACE).setOptions(this.getNamespaces()).setDisabled(false);
        this.getUIStringInput(CHILD_NAME).setReadOnly(false).setValue(null);
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setReadOnly(false).setValue(null);
        this.getUIFormSelectBox(AUTOCREATED).setOptions(autoListItem).setDisabled(false);
        this.getUIFormSelectBox(MANDATORY).setOptions(mandoListItem).setDisabled(false);
        this.getUIFormSelectBox(PARENTVERSION).setOptions(this.getParentVersions()).setDisabled(false);
        this.getUIFormSelectBox(PROTECTED).setOptions(protectedItem).setDisabled(false);
        this.getUIFormSelectBox(SAME_NAME).setOptions(sameNameListItem).setDisabled(false);
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setReadOnly(false).setValue(null);
        UINodeTypeForm uiForm = (UINodeTypeForm)this.getParent();
        UIFormInputSetWithAction uiChildTab = (UIFormInputSetWithAction)uiForm.getChildById("childNodeDefinition");
        uiForm.setActionInTab(uiChildTab);
    }

    public void update(NodeType nodeType, String childNodeName) throws Exception {
        if (childNodeName != null) {
            NodeDefinition[] nodeDefinitions = nodeType.getChildNodeDefinitions();
            for (int i = 0; i < nodeDefinitions.length; ++i) {
                String name = nodeDefinitions[i].getName();
                if (!name.equals(childNodeName)) continue;
                if (childNodeName.indexOf(":") > -1) {
                    String[] arr = childNodeName.split(":");
                    this.getUIFormSelectBox(NAMESPACE).setValue(arr[0].trim());
                    this.getUIStringInput(CHILD_NAME).setValue((Object)arr[1].trim());
                } else {
                    this.getUIFormSelectBox(NAMESPACE).setValue("");
                    this.getUIStringInput(CHILD_NAME).setValue((Object)childNodeName);
                }
                NodeType defaultNodeType = nodeDefinitions[i].getDefaultPrimaryType();
                if (defaultNodeType != null) {
                    this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setValue((Object)defaultNodeType.getName());
                }
                String sameName = String.valueOf(nodeDefinitions[i].allowsSameNameSiblings());
                this.getUIFormSelectBox(SAME_NAME).setValue(sameName);
                this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(nodeDefinitions[i].isMandatory()));
                this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(nodeDefinitions[i].isAutoCreated()));
                this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(nodeDefinitions[i].isProtected()));
                String parentVersion = Integer.toString(nodeDefinitions[i].getOnParentVersion());
                this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
                StringBuilder requiredType = new StringBuilder();
                NodeType[] requiredPrimaryType = nodeDefinitions[i].getRequiredPrimaryTypes();
                for (int j = 0; j < requiredPrimaryType.length; ++j) {
                    if (requiredType.length() > 0) {
                        requiredType.append(" , ");
                    }
                    requiredType.append(requiredPrimaryType[j].getName());
                }
                this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setValue((Object)requiredType.toString());
                break;
            }
        }
        this.getUIFormSelectBox(NAMESPACE).setDisabled(true);
        this.getUIStringInput(CHILD_NAME).setReadOnly(true);
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setReadOnly(true);
        this.getUIFormSelectBox(AUTOCREATED).setDisabled(true);
        this.getUIFormSelectBox(MANDATORY).setDisabled(true);
        this.getUIFormSelectBox(PARENTVERSION).setDisabled(true);
        this.getUIFormSelectBox(PROTECTED).setDisabled(true);
        this.getUIFormSelectBox(SAME_NAME).setDisabled(true);
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setReadOnly(true);
    }

    private void setValues(NodeDefinitionValue node) {
        String childNodeName = node.getName();
        if (childNodeName.indexOf(":") > -1) {
            String[] arr = childNodeName.split(":");
            this.getUIFormSelectBox(NAMESPACE).setValue(arr[0].trim());
            this.getUIStringInput(CHILD_NAME).setValue((Object)arr[1].trim());
        } else {
            this.getUIFormSelectBox(NAMESPACE).setValue("");
            this.getUIStringInput(CHILD_NAME).setValue((Object)childNodeName);
        }
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setValue((Object)node.getDefaultNodeTypeName());
        this.getUIFormSelectBox(SAME_NAME).setValue(String.valueOf(node.isSameNameSiblings()));
        this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(node.isMandatory()));
        this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(node.isAutoCreate()));
        this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(node.isReadOnly()));
        String parentVersion = Integer.toString(node.getOnVersion());
        this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
        List requiredPrimaryType = node.getRequiredNodeTypeNames();
        StringBuilder listRequired = new StringBuilder();
        for (int j = 0; j < requiredPrimaryType.size(); ++j) {
            if (listRequired.length() < 1) {
                listRequired.append((String)requiredPrimaryType.get(j));
                continue;
            }
            listRequired.append(",").append((String)requiredPrimaryType.get(j));
        }
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setValue((Object)listRequired.toString());
    }

    private NodeDefinitionValue getChildNodeByName(String nodeName, List<NodeDefinitionValue> listNode) {
        for (NodeDefinitionValue node : listNode) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public static class CancelChildActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIChildNodeDefinitionForm uiChildNodeForm = (UIChildNodeDefinitionForm)uiForm.getChild(UIChildNodeDefinitionForm.class);
            uiChildNodeForm.refresh();
            UIFormInputSetWithAction childTab = (UIFormInputSetWithAction)uiForm.getChildById("childNodeDefinition");
            childTab.setActions(new String[]{"AddChild"}, null);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class AddRequiredTypeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UINodeTypeOptionList requiredPrimaryTypeTab = new UINodeTypeOptionList("RequiredTypeTab");
            uiForm.removeChildTabs(new String[]{"superTypeTab", "DefaultTypeTab"});
            if (requiredPrimaryTypeTab.isRendered()) {
                uiForm.removeChildById("RequiredTypeTab");
            }
            String[] actionNames = new String[]{"AddType", "CancelTab"};
            String[] fieldNames = new String[]{UIChildNodeDefinitionForm.REQUIRED_PRIMARY_TYPE, "RequiredTypeTab"};
            requiredPrimaryTypeTab.setActions(actionNames, fieldNames);
            uiForm.addUIComponentInput((UIComponent)requiredPrimaryTypeTab);
            uiForm.setTabRender("RequiredTypeTab");
            UINodeTypeOptionList uiOptionList = (UINodeTypeOptionList)uiForm.getChild(UINodeTypeOptionList.class);
            String requiredTypeValue = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.REQUIRED_PRIMARY_TYPE).getValue();
            uiOptionList.update(requiredTypeValue);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class AddDefaultTypeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UINodeTypeOptionList defaultPrimaryTypeTab = new UINodeTypeOptionList("DefaultTypeTab");
            uiForm.removeChildTabs(new String[]{"superTypeTab", "RequiredTypeTab"});
            if (defaultPrimaryTypeTab.isRendered()) {
                uiForm.removeChildById("DefaultTypeTab");
            }
            String[] actionNames = new String[]{"AddType", "CancelTab"};
            String[] fieldNames = new String[]{UIChildNodeDefinitionForm.DEFAULT_PRIMARY_TYPE, "DefaultTypeTab"};
            defaultPrimaryTypeTab.setActions(actionNames, fieldNames);
            uiForm.addUIComponentInput((UIComponent)defaultPrimaryTypeTab);
            uiForm.setTabRender("DefaultTypeTab");
            UINodeTypeOptionList uiOptionList = (UINodeTypeOptionList)uiForm.getChild(UINodeTypeOptionList.class);
            String defaultTypeValue = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.DEFAULT_PRIMARY_TYPE).getValue();
            uiOptionList.update(defaultTypeValue);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class AddChildActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            NodeDefinitionValue nodeTypeValue = new NodeDefinitionValue();
            String prefix = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.NAMESPACE).getValue();
            String childNodeName = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.CHILD_NAME).getValue();
            if (childNodeName == null || childNodeName.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-name", null));
                return;
            }
            for (int i = 0; i < childNodeName.length(); ++i) {
                char c = childNodeName.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '.' || c == ':' || c == '@' || c == '^' || c == '[' || c == ']' || c == ',' || childNodeName.equals("*")) continue;
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-invalid", null, 1));
                return;
            }
            if (prefix != null && prefix.length() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(prefix).append(":").append(childNodeName);
                childNodeName = sb.toString();
            }
            nodeTypeValue.setName(childNodeName);
            String defaultType = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.DEFAULT_PRIMARY_TYPE).getValue();
            if (defaultType == null || defaultType.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                ApplicationMessage message = new ApplicationMessage("UIChildNodeDefinitionForm.msg.defaultPrimaryType", null);
                uiApp.addMessage(message);
                return;
            }
            nodeTypeValue.setDefaultNodeTypeName(defaultType);
            String isSameName = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.SAME_NAME).getValue();
            nodeTypeValue.setSameNameSiblings(Boolean.parseBoolean(isSameName));
            String madatory = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.MANDATORY).getValue();
            nodeTypeValue.setMandatory(Boolean.parseBoolean(madatory));
            String autoCreate = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.AUTOCREATED).getValue();
            nodeTypeValue.setAutoCreate(Boolean.parseBoolean(autoCreate));
            String isProtected = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.PROTECTED).getValue();
            nodeTypeValue.setReadOnly(Boolean.parseBoolean(isProtected));
            String parentVer = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.PARENTVERSION).getValue();
            nodeTypeValue.setOnVersion(Integer.parseInt(parentVer));
            String requiredType = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.REQUIRED_PRIMARY_TYPE).getValue();
            if (requiredType == null || requiredType.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                ApplicationMessage message = new ApplicationMessage("UIChildNodeDefinitionForm.msg.requiredPrimaryType", null);
                uiApp.addMessage(message);
                return;
            }
            String[] types = requiredType.split(",");
            ArrayList<String> reqList = new ArrayList<String>();
            for (int i = 0; i < types.length; ++i) {
                reqList.add(types[i].trim());
            }
            nodeTypeValue.setRequiredNodeTypeNames(reqList);
            uiForm.addedChildDef_.add(nodeTypeValue);
            uiForm.setChildValue(uiForm.addedChildDef_);
            UIChildNodeDefinitionForm uiChildNodeForm = (UIChildNodeDefinitionForm)uiForm.getChild(UIChildNodeDefinitionForm.class);
            uiChildNodeForm.refresh();
            uiForm.setTabRender("nodeTypeDefinition");
            UIFormInputSetWithAction nodeTypeTab = (UIFormInputSetWithAction)uiForm.getChildById("nodeTypeDefinition");
            nodeTypeTab.setIsView(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class UpdateChildActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIChildNodeDefinitionForm uiChildNodeForm = (UIChildNodeDefinitionForm)uiForm.getChild(UIChildNodeDefinitionForm.class);
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            NodeDefinitionValue nodeTypeValue = uiChildNodeForm.getChildNodeByName(nodeName, uiForm.addedChildDef_);
            String prefix = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.NAMESPACE).getValue();
            String childNodeName = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.CHILD_NAME).getValue();
            if (childNodeName == null || childNodeName.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-name", null));
                return;
            }
            for (int i = 0; i < childNodeName.length(); ++i) {
                char c = childNodeName.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '.' || c == ':' || c == '@' || c == '^' || c == '[' || c == ']' || c == ',' || childNodeName.equals("*")) continue;
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-invalid", null, 1));
                return;
            }
            if (prefix != null && prefix.length() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(prefix).append(":").append(childNodeName);
                childNodeName = sb.toString();
            }
            if (nodeTypeValue == null) {
                nodeTypeValue = new NodeDefinitionValue();
            }
            nodeTypeValue.setName(childNodeName);
            String defaultType = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.DEFAULT_PRIMARY_TYPE).getValue();
            if (defaultType == null || defaultType.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                ApplicationMessage message = new ApplicationMessage("UIChildNodeDefinitionForm.msg.defaultPrimaryType", null);
                uiApp.addMessage(message);
                return;
            }
            nodeTypeValue.setDefaultNodeTypeName(defaultType);
            String isSameName = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.SAME_NAME).getValue();
            nodeTypeValue.setSameNameSiblings(Boolean.parseBoolean(isSameName));
            String isMandatory = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.MANDATORY).getValue();
            nodeTypeValue.setMandatory(Boolean.parseBoolean(isMandatory));
            String autoCreate = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.AUTOCREATED).getValue();
            nodeTypeValue.setAutoCreate(Boolean.parseBoolean(autoCreate));
            String isProtected = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.PROTECTED).getValue();
            nodeTypeValue.setReadOnly(Boolean.parseBoolean(isProtected));
            String parentVer = (String)uiForm.getUIFormSelectBox(UIChildNodeDefinitionForm.PARENTVERSION).getValue();
            nodeTypeValue.setOnVersion(Integer.parseInt(parentVer));
            String requiredType = (String)uiForm.getUIStringInput(UIChildNodeDefinitionForm.REQUIRED_PRIMARY_TYPE).getValue();
            if (requiredType == null || requiredType.length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                ApplicationMessage message = new ApplicationMessage("UIChildNodeDefinitionForm.msg.requiredPrimaryType", null);
                uiApp.addMessage(message);
                return;
            }
            String[] types = requiredType.split(",");
            ArrayList<String> reqList = new ArrayList<String>();
            for (int i = 0; i < types.length; ++i) {
                reqList.add(types[i].trim());
            }
            nodeTypeValue.setRequiredNodeTypeNames(reqList);
            uiForm.setChildValue(uiForm.addedChildDef_);
            uiChildNodeForm.refresh();
            UIFormInputSetWithAction childTab = (UIFormInputSetWithAction)uiForm.getChildById("childNodeDefinition");
            childTab.setActions(new String[]{"AddChild"}, null);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class EditChildNodeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIChildNodeDefinitionForm uiChildNodeForm = (UIChildNodeDefinitionForm)uiForm.getChild(UIChildNodeDefinitionForm.class);
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (nodeName == null || nodeName.trim().length() == 0) {
                uiForm.setTabRender("childNodeDefinition");
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-name", null));
                return;
            }
            for (int i = 0; i < nodeName.length(); ++i) {
                char c = nodeName.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '.' || c == ':' || c == '@' || c == '^' || c == '[' || c == ']' || c == ',' || nodeName.equals("*")) continue;
                uiApp.addMessage(new ApplicationMessage("UIChildNodeDefinitionForm.msg.child-invalid", null, 1));
                return;
            }
            NodeDefinitionValue nodeDefValue = uiChildNodeForm.getChildNodeByName(nodeName, uiForm.addedChildDef_);
            uiChildNodeForm.setValues(nodeDefValue);
            UIFormInputSetWithAction childTab = (UIFormInputSetWithAction)uiForm.getChildById("childNodeDefinition");
            String[] actionNames = new String[]{UIChildNodeDefinitionForm.ACTION_UPDATE_CHILD, UIChildNodeDefinitionForm.ACTION_CANCEL_CHILD};
            String[] fieldNames = new String[]{nodeName, null};
            childTab.setActions(actionNames, fieldNames);
            uiForm.setTabRender("childNodeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class RemoveChildNodeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            for (NodeDefinitionValue node : uiForm.addedChildDef_) {
                if (!node.getName().equals(nodeName)) continue;
                uiForm.addedChildDef_.remove(node);
                break;
            }
            uiForm.setChildValue(uiForm.addedChildDef_);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

