/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIViewMetadataContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIViewMetadataManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

@ComponentConfig(events={@EventConfig(listeners={EditPropertyActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIViewMetadataTemplate
extends UIContainer {
    private String documentType_;
    private static final Log LOG = ExoLogger.getLogger((String)UIViewMetadataTemplate.class.getName());

    public void setTemplateType(String type) {
        this.documentType_ = type;
    }

    public String getViewTemplatePath() {
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        try {
            return metadataService.getMetadataPath(this.documentType_, false);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return null;
        }
    }

    public String getTemplate() {
        return this.getViewTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).newJCRTemplateResourceResolver();
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public Node getViewNode(String nodeType) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getViewNode(nodeType);
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getMultiValues(node, name);
    }

    public static class CancelActionListener
    extends EventListener<UIViewMetadataTemplate> {
        public void execute(Event<UIViewMetadataTemplate> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIViewMetadataTemplate)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class EditPropertyActionListener
    extends EventListener<UIViewMetadataTemplate> {
        public void execute(Event<UIViewMetadataTemplate> event) throws Exception {
            UIViewMetadataTemplate uiViewTemplate = (UIViewMetadataTemplate)((Object)event.getSource());
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            UIViewMetadataManager uiMetaManager = (UIViewMetadataManager)uiViewTemplate.getAncestorOfType(UIViewMetadataManager.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiViewTemplate.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiViewTemplate.getAncestorOfType(UIApplication.class);
            Node currentNode = uiExplorer.getCurrentNode();
            if (!PermissionUtil.canSetProperty((Node)currentNode)) {
                throw new MessageException(new ApplicationMessage("UIViewMetadataTemplate.msg.access-denied", null, 1));
            }
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
                return;
            }
            uiMetaManager.initMetadataFormPopup(nodeType);
            UIViewMetadataContainer uiContainer = (UIViewMetadataContainer)uiViewTemplate.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiContainer.getParent());
        }
    }
}

