/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.thumbnail;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/thumbnail/UIThumbnailForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveThumbnailActionListener.class}, confirm="UIThumbnailForm.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={PreviewActionListener.class})}), @ComponentConfig(id="mediumSize", type=UIUploadInput.class, template="app:/groovy/webui/component/explorer/thumbnail/UIFormUploadInput.gtmpl")})
public class UIThumbnailForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIThumbnailForm.class.getName());
    private static final String THUMBNAIL_FIELD = "mediumSize";
    private UploadResource currentUploadResource;
    private BufferedImage currentUploadImage;
    private String currentPreviewLink;

    public UIThumbnailForm() throws Exception {
        this.initForm();
    }

    private void initForm() throws Exception {
        this.currentUploadResource = null;
        this.currentUploadImage = null;
        this.currentPreviewLink = null;
        this.setMultiPart(true);
        UIUploadInput uiInput = new UIUploadInput(THUMBNAIL_FIELD, THUMBNAIL_FIELD);
        this.removeChild(UIUploadInput.class);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    public String getThumbnailImage(Node node) throws Exception {
        return Utils.getThumbnailImage((Node)node, (String)"exo:mediumSize");
    }

    public String getPreviewImage() throws Exception {
        String uploadId;
        UIUploadInput input = (UIUploadInput)this.getUIInput(THUMBNAIL_FIELD);
        if (input.getUploadResource(uploadId = input.getUploadIds()[0]) == null) {
            return null;
        }
        return Utils.getThumbnailImage((InputStream)input.getUploadDataAsStream(uploadId), (String)input.getUploadResource(uploadId).getFileName());
    }

    public Node getSelectedNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRealCurrentNode();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Node currentRealNode = this.getSelectedNode();
        if (this.getThumbnailImage(currentRealNode) == null) {
            this.setActions(new String[]{"Save", "Cancel"});
        } else {
            this.setActions(new String[]{"RemoveThumbnail", "Cancel"});
        }
        super.processRender(context);
    }

    public Node getThumbnailNode(Node node) throws Exception {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        return thumbnailService.getThumbnailNode(node);
    }

    public BufferedImage getCurrentUploadImage() {
        return this.currentUploadImage;
    }

    public void setCurrentUploadImage(BufferedImage currentUploadImage) {
        this.currentUploadImage = currentUploadImage;
    }

    public UploadResource getCurrentUploadResource() {
        return this.currentUploadResource;
    }

    public void setCurrentUploadResource(UploadResource currentUploadResource) {
        this.currentUploadResource = currentUploadResource;
    }

    public void setCurrentPreviewLink(String currentPreviewLink) {
        this.currentPreviewLink = currentPreviewLink;
    }

    public String getCurrentPreviewLink() {
        return this.currentPreviewLink;
    }

    public String getThumbnailModifiedTime(Node node) throws Exception {
        boolean hasLastModifiedProperty = node.hasProperty("exo:thumbnailLastModified");
        if (hasLastModifiedProperty) {
            return node.getProperty("exo:thumbnailLastModified").getDate().getTime().toString();
        }
        LOG.warn((Object)("Thumbnail last modified property of the node " + node.getPath() + " doesn't exist."));
        return null;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIThumbnailForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class RemoveThumbnailActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIThumbnailForm uiForm = (UIThumbnailForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = uiExplorer.getRealCurrentNode();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            uiExplorer.addLockToken(selectedNode);
            ThumbnailService thumbnailService = (ThumbnailService)uiForm.getApplicationComponent(ThumbnailService.class);
            Node thumbnailNode = thumbnailService.getThumbnailNode(selectedNode);
            if (thumbnailNode != null) {
                try {
                    thumbnailNode.remove();
                    selectedNode.getSession().save();
                    uiForm.initForm();
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                }
                catch (LockException lock) {
                    Object[] arg = new Object[]{selectedNode.getPath()};
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
                    uiExplorer.updateAjax(event);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                    }
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                }
            }
        }
    }

    public static class PreviewActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            String uploadId;
            UIThumbnailForm uiForm = (UIThumbnailForm)((Object)event.getSource());
            UIUploadInput input = (UIUploadInput)uiForm.getUIInput(UIThumbnailForm.THUMBNAIL_FIELD);
            if (input.getUploadDataAsStream(uploadId = input.getUploadIds()[0]) != null) {
                uiForm.setCurrentPreviewLink(uiForm.getPreviewImage());
                uiForm.setCurrentUploadImage(ImageIO.read(input.getUploadDataAsStream(uploadId)));
                uiForm.setCurrentUploadResource(input.getUploadResource(uploadId));
            } else {
                uiForm.setCurrentPreviewLink(null);
                uiForm.setCurrentUploadImage(null);
                uiForm.setCurrentUploadResource(null);
            }
        }
    }

    public static class SaveActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIThumbnailForm uiForm = (UIThumbnailForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            if (uiForm.getCurrentUploadResource() == null) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.fileName-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            String fileName = uiForm.getCurrentUploadResource().getFileName();
            DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
            String mimeType = mimeTypeSolver.getMimeType(fileName);
            if (!mimeType.startsWith("image")) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.mimetype-incorrect", null, 1));
                return;
            }
            Node selectedNode = uiExplorer.getRealCurrentNode();
            uiExplorer.addLockToken(selectedNode);
            ThumbnailService thumbnailService = (ThumbnailService)WCMCoreUtils.getService(ThumbnailService.class);
            try {
                thumbnailService.createThumbnailImage(selectedNode, uiForm.getCurrentUploadImage(), mimeType);
                selectedNode.getSession().save();
                uiExplorer.updateAjax(event);
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.access-denied", null, 1));
            }
            catch (VersionException ver) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.is-checked-in", null, 1));
            }
            catch (LockException lock) {
                Object[] arg = new Object[]{selectedNode.getPath()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
    }
}

