/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.publication.NotInWCMPublicationException;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class WCMPublicationServiceImpl
implements WCMPublicationService,
Startable {
    private static final String SIMPLE_LIFECYCLE_NAME = "Simple publication";
    public static final String STATEVERSION_LIFECYCLE_NAME = "States and versions based publication";
    private HashMap<String, WebpagePublicationPlugin> publicationPlugins = new HashMap();
    protected PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
    protected ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
    protected CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);

    @Override
    public void addPublicationPlugin(WebpagePublicationPlugin p) {
        this.publicationPlugins.put(p.getLifecycleName(), p);
        this.publicationService.addPublicationPlugin((PublicationPlugin)((Object)PublicationPlugin.class.cast((Object)p)));
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String lifecycleName) throws Exception {
        this.publicationService.enrollNodeInLifecycle(node, lifecycleName);
    }

    @Override
    public void unsubcribeLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        this.publicationService.unsubcribeLifecycle(node);
    }

    @Override
    public Map<String, WebpagePublicationPlugin> getWebpagePublicationPlugins() {
        return this.publicationPlugins;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public boolean isEnrolledInWCMLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            return false;
        }
        String lifecyleName = this.publicationService.getNodeLifecycleName(node);
        if (this.publicationPlugins.containsKey(lifecyleName)) {
            return true;
        }
        throw new NotInWCMPublicationException();
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String siteName, String remoteUser) throws Exception {
        if ("test".equals(siteName)) {
            this.enrollNodeInLifecycle(node, SIMPLE_LIFECYCLE_NAME);
        } else {
            this.enrollNodeInLifecycle(node, STATEVERSION_LIFECYCLE_NAME);
        }
    }

    @Override
    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, siteName, remoteUser, null);
    }

    @Override
    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser, String newState) throws Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            this.enrollNodeInLifecycle(node, siteName, remoteUser);
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(node);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        boolean hasState = false;
        if (newState != null) {
            String[] states;
            for (String state : states = publicationPlugin.getPossibleStates()) {
                if (!state.equals(newState)) continue;
                hasState = true;
            }
        }
        if (hasState) {
            publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser, newState);
        } else {
            publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser);
        }
        this.listenerService.broadcast("WCMPublicationService.event.updateState", (Object)this.cmsService, (Object)node);
    }

    @Override
    public String getContentState(Node node) throws Exception {
        String currentState = null;
        if (node.hasProperty("publication:currentState")) {
            currentState = node.getProperty("publication:currentState").getString();
        }
        return currentState;
    }
}

