/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockHolderContainer;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockNodeList;
import org.exoplatform.ecm.webui.component.admin.unlock.UIUnLockManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/unlock/UILockHolderList.gtmpl", events={@EventConfig(listeners={DeleteLockActionListener.class})})
public class UILockHolderList
extends UIPagingGridDecorator {
    public static final String[] ACTIONS = new String[0];
    public static final String ST_EDIT = "EditUnLockForm";

    public UILockHolderList() throws Exception {
        this.getUIPageIterator().setId("LockHolderListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        ListAccessImpl groupsAndUsersForLockList = new ListAccessImpl(String.class, this.getAllGroupsOrUsersForLock());
        LazyPageList pageList = new LazyPageList((ListAccess)groupsAndUsersForLockList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public List getGroupsOrUsersForLock() throws Exception {
        return this.getUIPageIterator().getCurrentPageData();
    }

    public List<String> getAllGroupsOrUsersForLock() throws Exception {
        LockService lockService = (LockService)this.getApplicationComponent(LockService.class);
        return lockService.getAllGroupsOrUsersForLock();
    }

    public static class DeleteLockActionListener
    extends EventListener<UILockHolderList> {
        public void execute(Event<UILockHolderList> event) throws Exception {
            UILockHolderList uiLockHolderList = (UILockHolderList)((Object)event.getSource());
            UILockHolderContainer uiLockHolderContainer = (UILockHolderContainer)uiLockHolderList.getAncestorOfType(UILockHolderContainer.class);
            String removedLockSetting = event.getRequestContext().getRequestParameter("objectId");
            LockService lockService = (LockService)uiLockHolderContainer.getApplicationComponent(LockService.class);
            if (!lockService.getPreSettingLockList().contains(removedLockSetting)) {
                lockService.removeGroupsOrUsersForLock(removedLockSetting);
                ArrayList<String> ignoredList = new ArrayList<String>();
                if (removedLockSetting.startsWith("*")) {
                    String groupOfRemovedLockSetting = StringUtils.substringAfter((String)removedLockSetting, (String)":");
                    List allLockSettings = lockService.getAllGroupsOrUsersForLock();
                    for (String lockSetting : allLockSettings) {
                        if (!groupOfRemovedLockSetting.equals(StringUtils.substringAfter((String)lockSetting, (String)":"))) continue;
                        ignoredList.add(lockSetting);
                    }
                }
                LockUtil.removeLockCache((String)removedLockSetting, ignoredList);
            } else {
                Object[] args = new Object[]{removedLockSetting};
                UIApplication uiApp = (UIApplication)uiLockHolderList.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UILockHolderList.msg.can-not-delete-lock-holder", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax(uiLockHolderContainer.getParent());
            }
            UILockHolderList uiHolderList = (UILockHolderList)uiLockHolderContainer.getChild(UILockHolderList.class);
            uiHolderList.refresh(uiHolderList.getUIPageIterator().getCurrentPage());
            UIUnLockManager uiUnLockManager = (UIUnLockManager)uiLockHolderContainer.getParent();
            ((UILockNodeList)uiUnLockManager.getChild(UILockNodeList.class)).setRendered(false);
            uiLockHolderContainer.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiLockHolderContainer.getParent());
        }
    }
}

