/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.SoftLRUCache;

public class LazyObjectLoader {
    private static final Logger logger = Logger.getLogger(LazyObjectLoader.class.toString());
    private Library library;
    private SeekableInput seekableInput;
    private CrossReference crossReference;
    protected SoftLRUCache<Reference, ObjectStream> leastRecentlyUsed;
    private final Object leastRectlyUsedLock = new Object();
    private final Object streamLock = new Object();

    public LazyObjectLoader(Library lib, SeekableInput seekableInput, CrossReference xref) {
        this.library = lib;
        this.seekableInput = seekableInput;
        this.crossReference = xref;
        this.leastRecentlyUsed = new SoftLRUCache(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object loadObject(Reference reference) {
        if (reference == null || this.library == null || this.crossReference == null) {
            return null;
        }
        int objNum = reference.getObjectNumber();
        CrossReference.Entry entry = this.crossReference.getEntryForObject(objNum);
        if (entry == null) {
            return null;
        }
        if (entry instanceof CrossReference.UsedEntry) {
            try {
                if (this.seekableInput == null) return null;
                Object object = this.streamLock;
                synchronized (object) {
                    try {
                        CrossReference.UsedEntry usedEntry = (CrossReference.UsedEntry)entry;
                        long position = usedEntry.getFilePositionOfObject();
                        this.seekableInput.beginThreadAccess();
                        long savedPosition = this.seekableInput.getAbsolutePosition();
                        this.seekableInput.seekAbsolute(position);
                        Parser parser = new Parser(this.seekableInput);
                        Object ob = parser.getObject(this.library);
                        this.seekableInput.seekAbsolute(savedPosition);
                        Object object2 = ob;
                        return object2;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error loading object instance: " + reference.toString(), e);
                            return null;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
            }
            finally {
                if (this.seekableInput != null) {
                    this.seekableInput.endThreadAccess();
                }
            }
        }
        if (!(entry instanceof CrossReference.CompressedEntry)) return null;
        try {
            ObjectStream objectStream;
            CrossReference.CompressedEntry compressedEntry = (CrossReference.CompressedEntry)entry;
            int objectStreamsObjectNumber = compressedEntry.getObjectNumberOfContainingObjectStream();
            int objectIndex = compressedEntry.getIndexWithinObjectStream();
            Reference objectStreamRef = new Reference(objectStreamsObjectNumber, 0);
            Object object = this.leastRectlyUsedLock;
            synchronized (object) {
                objectStream = this.leastRecentlyUsed.get(objectStreamRef);
            }
            if (objectStream == null) {
                object = this.streamLock;
                synchronized (object) {
                    objectStream = (ObjectStream)this.library.getObject(objectStreamRef);
                }
                if (objectStream != null) {
                    object = this.leastRectlyUsedLock;
                    synchronized (object) {
                        this.leastRecentlyUsed.put(objectStreamRef, objectStream);
                    }
                }
            }
            if (objectStream == null) return null;
            object = this.streamLock;
            synchronized (object) {
                return objectStream.loadObject(this.library, objectIndex);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading object instance: " + reference.toString(), e);
        }
        return null;
    }

    public boolean haveEntry(Reference reference) {
        if (reference == null || this.crossReference == null) {
            return false;
        }
        int objNum = reference.getObjectNumber();
        CrossReference.Entry entry = this.crossReference.getEntryForObject(objNum);
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTrailer loadTrailer(long position) {
        PTrailer trailer = null;
        try {
            if (this.seekableInput != null) {
                this.seekableInput.beginThreadAccess();
                long savedPosition = this.seekableInput.getAbsolutePosition();
                this.seekableInput.seekAbsolute(position);
                Parser parser = new Parser(this.seekableInput);
                Object obj = parser.getObject(this.library);
                if (obj instanceof PObject) {
                    obj = ((PObject)obj).getObject();
                }
                if ((trailer = (PTrailer)obj) != null) {
                    trailer.setPosition(position);
                }
                this.seekableInput.seekAbsolute(savedPosition);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error loading PTrailer instance: " + position, e);
        }
        finally {
            if (this.seekableInput != null) {
                this.seekableInput.endThreadAccess();
            }
        }
        return trailer;
    }

    public Library getLibrary() {
        return this.library;
    }
}

