/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.queries.impl.NewUserConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Asynchronous
public class UserCMSQueryInitListener
extends Listener<OrganizationService, String> {
    private static final Log LOG = ExoLogger.getLogger(UserCMSQueryInitListener.class);
    private NewUserConfig config_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repositoryService_;
    private String relativePath_;
    private ExoContainer container;

    public UserCMSQueryInitListener(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, ExoContainer container, InitParams params) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.container = container;
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
        this.relativePath_ = params.getValueParam("relativePath").getValue();
    }

    public void onEvent(Event<OrganizationService, String> event) throws Exception {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.initSystemData((String)event.getData());
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void initSystemData(String userName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
        if (!userNode.hasNode(this.relativePath_)) {
            Node userQueryHome = userNode.addNode(this.relativePath_);
            userQueryHome.addMixin("exo:searchFolder");
            userQueryHome.addMixin("exo:hiddenable");
            userNode.save();
            return;
        }
        if (this.config_ == null) {
            return;
        }
        if (userNode.hasNode(this.relativePath_)) {
            Node queriesHome = userNode.getNode(this.relativePath_);
            boolean userFound = false;
            NewUserConfig.User templateConfig = null;
            for (NewUserConfig.User userConfig : this.config_.getUsers()) {
                String currentName = userConfig.getUserName();
                if (this.config_.getTemplate().equals(currentName)) {
                    templateConfig = userConfig;
                }
                if (!currentName.equals(userName)) continue;
                List<NewUserConfig.Query> queries = userConfig.getQueries();
                this.importQueries(queriesHome, queries, userNode.getSession().getWorkspace().getName());
                userFound = true;
                break;
            }
            if (!userFound) {
                List<NewUserConfig.Query> queries = templateConfig.getQueries();
                this.importQueries(queriesHome, queries);
            }
        } else {
            LOG.debug((Object)("The userNode " + userNode.getName() + " doesn't have a child node named : " + this.relativePath_ + ". The feature 'StoredQueries' will be ignored "));
        }
    }

    private void importQueries(Node queriesHome, List<NewUserConfig.Query> queries) throws Exception {
        this.importQueries(queriesHome, queries, queriesHome.getSession().getWorkspace().getName());
    }

    private void importQueries(Node queriesHome, List<NewUserConfig.Query> queries, String workspaceName) throws Exception {
        QueryManager manager = this.getSession(workspaceName).getWorkspace().getQueryManager();
        for (NewUserConfig.Query query : queries) {
            String queryName = query.getQueryName();
            String language = query.getLanguage();
            String statement = query.getQuery();
            Query queryNode = manager.createQuery(statement, language);
            String absPath = queriesHome.getPath() + "/" + queryName;
            if (queriesHome.getSession().itemExists(absPath)) continue;
            Node node = queryNode.storeAsNode(absPath);
            if (!node.isNodeType("exo:datetime")) {
                node.addMixin("exo:datetime");
            }
            if (!node.isNodeType("exo:hiddenable")) {
                node.addMixin("exo:hiddenable");
            }
            if (!node.isNodeType("exo:owneable")) {
                node.addMixin("exo:owneable");
            }
            node.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
            node.getSession().save();
        }
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return sessionProvider.getSession(workspaceName, this.repositoryService_.getCurrentRepository());
    }
}

