/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.ItemExistsException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.services.attachments.model.ActivityFileAttachment;
import org.exoplatform.services.attachments.model.ActivityFilesDownloadResource;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.rest.model.AttachmentEntity;
import org.exoplatform.services.attachments.service.AttachmentService;
import org.exoplatform.services.attachments.utils.EntityBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/attachments")
@Tag(name="/attachments", description="Managing attachments")
public class AttachmentsRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)AttachmentsRestService.class.getName());
    protected AttachmentService attachmentService;
    protected IdentityManager identityManager;
    protected DownloadService downloadService;

    public AttachmentsRestService(AttachmentService attachmentService, IdentityManager identityManager, DownloadService downloadService) {
        this.attachmentService = attachmentService;
        this.identityManager = identityManager;
        this.downloadService = downloadService;
    }

    @POST
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Link an attachment to an entity", description="Link an existing attachment to the given entity (Event, Task, Wiki,...)", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response linkAttachmentToEntity(@Parameter(description="entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="entity type", required=true) @PathParam(value="entityType") String entityType, @Parameter(description="file uuid stored in jcr to be attached to the provided entity", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment id must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        Attachment attachment = new Attachment();
        try {
            attachment = this.attachmentService.linkAttachmentToEntity(userIdentityId, entityId, entityType, attachmentId);
        }
        catch (Exception e) {
            LOG.error("Error when trying to link attachments to entity with type {} and id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)attachment).build();
    }

    @PUT
    @Path(value="{entityType}/{entityId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update entity's attachments list", method="PUT", description="Update entity's attachments list")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateAttachmentsLinkedToContext(@Parameter(description="entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="entity type", required=true) @PathParam(value="entityType") String entityType, @Parameter(description="list of files uuid stored in jcr attached to the provided entity", required=true) @FormParam(value="attachmentId") List<String> attachmentIds) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            this.attachmentService.updateEntityAttachments(userIdentityId, entityId, entityType, attachmentIds);
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to update attachments of entity type {} with id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="{entityType}/{entityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get list of attachments linked to an entity", method="GET", description="Get the list of attachments linked to the given entity")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAttachmentsByEntity(@Parameter(description="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="Entity type", required=true) @PathParam(value="entityType") String entityType) throws Exception {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity identifier must be a positive integer").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            List<Attachment> attachments = this.attachmentService.getAttachmentsByEntity(userIdentityId, entityId, entityType);
            List<Object> attachmentsEntities = new ArrayList();
            if (!attachments.isEmpty()) {
                attachmentsEntities = attachments.stream().map(attachment -> EntityBuilder.fromAttachment(this.identityManager, attachment)).filter(attachmentEntity -> attachmentEntity.getAcl().isCanView()).toList();
            }
            return Response.ok(attachmentsEntities).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachments of entity type {} with id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get list of attachments linked to the given entity", method="GET", description="Get the list of attachments linked to the given entity")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAttachmentByIdByEntity(@Parameter(description="Attachment technical identifier", required=true) @PathParam(value="attachmentId") String attachmentId, @Parameter(description="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="Entity type", required=true) @PathParam(value="entityType") String entityType) throws Exception {
        if (StringUtils.isBlank((CharSequence)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment identifier is mandatory").build();
        }
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity identifier must be a positive integer").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            Attachment attachment = this.attachmentService.getAttachmentByIdByEntity(entityType, entityId, attachmentId, userIdentityId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachment with id {}: ", new Object[]{attachmentId, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{attachmentId}")
    @Produces(value={"application/json"})
    @Operation(summary="Get an attachment with its jcr uuid", method="GET", description="Get an attachment with its jcr uuid")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAttachmentById(@Parameter(description="Attachment technical identifier", required=true) @PathParam(value="attachmentId") String attachmentId) throws Exception {
        if (StringUtils.isBlank((CharSequence)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment identifier is mandatory").build();
        }
        try {
            Attachment attachment = this.attachmentService.getAttachmentById(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachment with id {}: ", new Object[]{attachmentId, e});
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{entityType}/{entityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete a list of attachments", description="Delete the list of attachments linked to the given entity", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteAttachmentsByEntity(@Parameter(description="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="Entity type", required=true) @PathParam(value="entityType") String entityType) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            this.attachmentService.deleteAllEntityAttachments(userIdentityId, entityId, entityType);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error("Error when trying to delete all attachments from entity with type {} and with id '{}' ", new Object[]{entityType, entityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AttachmentContext not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized {} entity with id {}", new Object[]{userIdentityId, entityType, entityId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @DELETE
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete an attachment linked to the given entity", method="DELETE", description="Delete an attachment linked to the given entity and returns the deleted attachment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteEntityAttachment(@Parameter(description="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @Parameter(description="Entity type", required=true) @PathParam(value="entityType") String entityType, @Parameter(description="Attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            AttachmentEntity attachmentEntity = EntityBuilder.fromAttachment(this.identityManager, this.attachmentService.getAttachmentByIdByEntity(entityType, entityId, attachmentId, userIdentityId));
            this.attachmentService.deleteAttachmentItemById(userIdentityId, entityId, entityType, attachmentId);
            return Response.ok((Object)attachmentEntity).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error("Error when trying to delete the attachment with id '{}' from entity with type {} and id '{}'", new Object[]{attachmentId, entityType, entityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AttachmentContext not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized {} entity with id {}", new Object[]{userIdentityId, entityType, entityId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @POST
    @Path(value="/downloadByPath")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Downloads a list of attachments by it paths", method="POST", description="redirects to download URL of binary that contains the list of attachments in a Zip file if multiple, else the selected file")
    @ApiResponses(value={@ApiResponse(responseCode="303", description="Request Redirect"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response downloadActivityAttachments(@Parameter(description="Filename to use for download", required=true) @QueryParam(value="fileName") String fileName, @RequestBody(description="List of file attachments to download", required=true) List<ActivityFileAttachment> activityFileAttachments) throws URISyntaxException {
        if (activityFileAttachments == null || activityFileAttachments.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attachments param is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"fileName param is mandatory").build();
        }
        String downloadLink = this.getDownloadLink(activityFileAttachments, fileName);
        URI location = new URI(downloadLink);
        return Response.seeOther((URI)location).build();
    }

    @POST
    @Path(value="/{attachmentId}/move")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Move an attachment to a destination path", method="POST", description="Move an attachment to a destination path and returns empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response moveAttachmentToNewPath(@Parameter(description="New path", required=true) @FormParam(value="newPath") String newPath, @Parameter(description="New destination path's drive", required=true) @FormParam(value="newPathDrive") String newPathDrive, @Parameter(description="New destination path's drive", required=true) @FormParam(value="entityType") String entityType, @Parameter(description="Entity technical identifier", required=true) @FormParam(value="entityId") long entityId, @Parameter(description="Entity type", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (StringUtils.isEmpty((CharSequence)newPathDrive)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New destination path's drive is mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment id is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            Attachment attachment = this.attachmentService.moveAttachmentToNewPath(userIdentityId, attachmentId, newPathDrive, newPath, entityType, entityId);
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to move attachment with id {} to new destination path {} ", new Object[]{attachmentId, newPath, e});
            return Response.serverError().entity((Object)("Error when trying to move attachment with id " + attachmentId + " to new destination path {} " + newPath)).build();
        }
    }

    @POST
    @Path(value="/newDoc")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="create new document", method="POST", description="create new document and returns a new created document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response createNewDocument(@Parameter(description="title") @Schema(defaultValue="20") @FormParam(value="title") String title, @Parameter(description="path of new document", required=true) @FormParam(value="path") String path, @Parameter(description="New destination path's drive", required=true) @FormParam(value="pathDrive") String pathDrive, @Parameter(description="template name of new document") @Schema(defaultValue="20") @FormParam(value="templateName") String templateName) throws Exception {
        if (StringUtils.isEmpty((CharSequence)title)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document title is mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document template name is mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document path is mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)pathDrive)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New destination path's drive is mandatory").build();
        }
        try {
            Identity userIdentity = this.getCurrentUserIdentity();
            Attachment attachment = this.attachmentService.createNewDocument(userIdentity, title, path, pathDrive, templateName);
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unauthorized to create a new document").build();
        }
        catch (ItemExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Document with the same name already exist in this current path").build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to a new document with type ", new Object[]{templateName, e});
            return Response.serverError().entity((Object)("Error when trying to a new document with type " + templateName)).build();
        }
    }

    public Identity getCurrentUserIdentity() {
        return ConversationState.getCurrent().getIdentity();
    }

    public long getCurrentUserIdentityId() {
        String currentUser = this.getCurrentUserIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    @PATCH
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/viewed/{nodeId}")
    @Operation(summary="Download a given document", method="GET", description="Download a given document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response markAsViewed(@Parameter(description="node id", required=true) @PathParam(value="nodeId") String nodeId, @Parameter(description="viewer username", required=true) @QueryParam(value="viewer") String viewer) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"nodeId is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)viewer)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"viewer is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        if (userIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            long views = this.attachmentService.markAttachmentAsViewed(nodeId, viewer);
            return Response.ok((Object)String.valueOf(views)).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public String getDownloadLink(List<ActivityFileAttachment> activityFileAttachments, String fileName) {
        NodeLocation[] nodeLocations = new NodeLocation[activityFileAttachments.size()];
        for (int i = 0; i < activityFileAttachments.size(); ++i) {
            ActivityFileAttachment activityFileAttachment = activityFileAttachments.get(i);
            nodeLocations[i] = new NodeLocation(activityFileAttachment.getRepository(), activityFileAttachment.getWorkspace(), activityFileAttachment.getDocPath(), activityFileAttachment.getId(), false);
        }
        ActivityFilesDownloadResource dresource = new ActivityFilesDownloadResource(nodeLocations);
        dresource.setDownloadName(fileName);
        String downloadResource = this.downloadService.addDownloadResource((DownloadResource)dresource);
        return this.downloadService.getDownloadLink(downloadResource);
    }
}

