/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWithTree;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.optionblocks.UIOptionBlockPanel;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDocumentTabPane.gtmpl", events={@EventConfig(listeners={ChangeTabActionListener.class})})
public class UIDocumentContainer
extends UIContainer {
    private String OPTION_BLOCK_EXTENSION_TYPE = "org.exoplatform.ecm.dms.UIOptionBlockPanel";
    private List<UIComponent> listExtenstion = new ArrayList<UIComponent>();
    private boolean isDisplayOptionPanel = false;

    public UIDocumentContainer() throws Exception {
        this.addChild(UIDocumentWithTree.class, null, null);
        this.addChild(UIDocumentInfo.class, null, null);
        this.initOptionBlockPanel();
    }

    public boolean isShowViewFile() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isShowViewFile();
    }

    public boolean isJcrEnable() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getPreference().isJcrEnable();
    }

    public boolean isDocumentNode() {
        try {
            Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
            TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
            List documentNodeTypes = templateService.getAllDocumentNodeTypes();
            return documentNodeTypes.contains(currentNode.getPrimaryNodeType().getName());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void addOptionBlockPanel() throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(this.OPTION_BLOCK_EXTENSION_TYPE);
        for (UIExtension extension : extensions) {
            UIComponent uicomp = manager.addUIExtension(extension, null, (UIContainer)this);
            uicomp.setRendered(false);
            this.listExtenstion.add(uicomp);
        }
    }

    public boolean isHasOptionBlockPanel() {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(this.OPTION_BLOCK_EXTENSION_TYPE);
        return extensions != null;
    }

    public void setDisplayOptionBlockPanel(boolean display) {
        for (UIComponent uicomp : this.listExtenstion) {
            uicomp.setRendered(display);
        }
        this.isDisplayOptionPanel = display;
    }

    public boolean isDisplayOptionBlockPanel() {
        return this.isDisplayOptionPanel;
    }

    public void initOptionBlockPanel() throws Exception {
        if (this.isHasOptionBlockPanel()) {
            this.addOptionBlockPanel();
            UIOptionBlockPanel optionBlockPanel = (UIOptionBlockPanel)this.getChild(UIOptionBlockPanel.class);
            if (optionBlockPanel.isHasOptionBlockExtension()) {
                optionBlockPanel.addOptionBlockExtension();
                this.setDisplayOptionBlockPanel(true);
            }
        }
    }

    public static class ChangeTabActionListener
    extends EventListener<UIDocumentContainer> {
        public void execute(Event<UIDocumentContainer> event) throws Exception {
            UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)((Object)event.getSource());
            String selectedTabName = event.getRequestContext().getRequestParameter("objectId");
            UIDocumentWithTree uiDocTree = (UIDocumentWithTree)uiDocumentContainer.getChild(UIDocumentWithTree.class);
            uiDocTree.setRendered(uiDocTree.getId().equals(selectedTabName));
            UIDocumentInfo uiDocInfo = (UIDocumentInfo)uiDocumentContainer.getChildById(UIDocumentInfo.class.getSimpleName());
            uiDocInfo.setRendered(uiDocInfo.getId().equals(selectedTabName));
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentContainer.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setShowDocumentViewForFile(uiDocInfo.getId().equals(selectedTabName));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentContainer);
            uiExplorer.updateAjax(event);
        }
    }
}

