/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.listener;

import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NoteAttachmentUpdateListener
extends Listener<String, Map<String, Object>> {
    private final String WIKI_DRAFT_PAGES = "WIKI_DRAFT_PAGES";
    private final String WIKI_PAGE_VERSIONS = "WIKI_PAGE_VERSIONS";
    private static final Log LOG = ExoLogger.getLogger(NoteAttachmentUpdateListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event) throws Exception {
        if (event.getData() != null) {
            try (SessionProvider sessionProvider = null;){
                sessionProvider = SessionProvider.createSystemProvider();
                SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getService(SessionProviderService.class);
                sessionProviderService.setSessionProvider(null, sessionProvider);
                Map data = (Map)event.getData();
                String draftPageId = (String)data.get("draftPageId");
                String pageVersionId = (String)data.get("pageVersionId");
                String draftForExistingPageId = (String)data.get("draftForExistingPageId");
                if (draftPageId != null && pageVersionId != null) {
                    this.moveAttachments(draftPageId, pageVersionId, "WIKI_DRAFT_PAGES", "WIKI_PAGE_VERSIONS");
                }
                if (draftForExistingPageId != null && pageVersionId != null) {
                    this.copyAttachments(pageVersionId, draftForExistingPageId, "WIKI_PAGE_VERSIONS", "WIKI_DRAFT_PAGES");
                }
            }
        }
    }

    private void moveAttachments(String sourceId, String targetId, String sourceEntityType, String targetEntityType) throws Exception {
        AttachmentStorage attachmentService = (AttachmentStorage)ExoContainerContext.getService(AttachmentStorage.class);
        List<Attachment> attachmentList = attachmentService.getAttachmentsByEntity(Long.parseLong(sourceId), sourceEntityType);
        if (attachmentList != null && !attachmentList.isEmpty()) {
            for (Attachment attachment : attachmentList) {
                attachmentService.linkAttachmentToEntity(Long.parseLong(targetId), targetEntityType, attachment.getId());
                attachmentService.deleteAttachmentItemByIdByEntity(Long.parseLong(sourceId), sourceEntityType, attachment.getId());
            }
        }
    }

    private void copyAttachments(String sourceId, String targetId, String sourceEntityType, String targetEntityType) throws Exception {
        AttachmentStorage attachmentService = (AttachmentStorage)ExoContainerContext.getService(AttachmentStorage.class);
        List<Attachment> attachmentList = attachmentService.getAttachmentsByEntity(Long.parseLong(sourceId), sourceEntityType);
        if (attachmentList != null && !attachmentList.isEmpty()) {
            for (Attachment attachment : attachmentList) {
                attachmentService.linkAttachmentToEntity(Long.parseLong(targetId), targetEntityType, attachment.getId());
            }
        }
    }
}

