/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;

public class ArrayNodePageList<E>
extends AbstractPageList<E> {
    private static final Log LOG = ExoLogger.getLogger((String)ArrayNodePageList.class.getName());
    protected List<E> dataList;

    public ArrayNodePageList(int pageSize) {
        super(pageSize);
        this.removeRedundantPages(0);
    }

    public ArrayNodePageList(List<E> results, int pageSize) {
        super(pageSize);
        this.dataList = results;
        this.setAvailablePage(this.dataList.size());
        this.removeRedundantPages(this.dataList.size() / pageSize);
        this.currentListPage_ = null;
        this.loadedAllData_ = true;
    }

    public ArrayNodePageList(List<Node> nodes, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        block4: {
            super(pageSize, filter, dataCreator);
            this.dataList = new ArrayList();
            try {
                for (Node node : nodes) {
                    Object data;
                    if (filter != null) {
                        node = filter.filterNodeToDisplay(node);
                    }
                    if (this.searchDataCreator == null || node == null || (data = this.searchDataCreator.createData(node, null, null)) == null) continue;
                    this.dataList.add(data);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage());
            }
        }
        this.setAvailablePage(this.dataList.size());
        this.removeRedundantPages(this.dataList.size() / pageSize);
        this.currentListPage_ = null;
    }

    public List<E> getDataList() {
        return this.dataList;
    }

    public List<E> getAll() throws Exception {
        return this.getDataList();
    }

    protected void populateCurrentPage(int page) throws Exception {
        this.currentListPage_ = new ArrayList();
        int count = 0;
        if (this.dataList != null) {
            for (int i = (page - 1) * this.getPageSize(); i < this.dataList.size(); ++i) {
                this.currentListPage_.add(this.dataList.get(i));
                if (++count == this.getPageSize()) break;
            }
        }
        this.currentPage_ = page;
    }

    @Override
    public void sortData() {
        block3: {
            if (this.comparator != null) {
                Collections.sort(this.dataList, this.comparator);
                try {
                    this.populateCurrentPage(this.currentPage_);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public List<E> getPageWithOffsetCare(int page) throws Exception {
        return this.getPage(page);
    }
}

