/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public final class LinkUtils {
    public static String evaluatePath(String path) {
        int index;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        while ((index = path.indexOf("/..")) != -1) {
            if (index == 0) {
                path = path.substring(3);
                continue;
            }
            if ((path = LinkUtils.createPath(LinkUtils.getParentPath(path.substring(0, index)), path.substring(index + 3))).endsWith("/")) continue;
            path = path.concat("/");
        }
        while ((index = path.indexOf("/./")) != -1) {
            if (index == 0) {
                path = path.substring(2);
                continue;
            }
            path = LinkUtils.createPath(path.substring(0, index), path.substring(index + 2));
        }
        return (path = LinkUtils.cleanPath(path)).length() == 0 ? "/" : path;
    }

    public static String getItemName(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static String createPath(String parentPath, String relativePath) {
        if (!parentPath.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + parentPath + "' must be an absolute path");
        }
        parentPath = LinkUtils.cleanPath(parentPath);
        if ((relativePath = LinkUtils.cleanPath(relativePath)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringBuilder path = new StringBuilder(128);
        path.append(parentPath);
        if (relativePath.length() > 0) {
            if (!parentPath.equals("/")) {
                path.append('/');
            }
            path.append(relativePath);
        }
        return path.toString();
    }

    public static int getDepth(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        if ((path = LinkUtils.cleanPath(path)).equals("/")) {
            return 0;
        }
        return path.substring(1).split("/").length;
    }

    public static String getAncestorPath(String path, int depth) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        path = LinkUtils.cleanPath(path);
        if (depth == 0) {
            return "/";
        }
        String[] subpath = path.substring(1).split("/");
        StringBuilder result = new StringBuilder(128);
        for (int i = 0; i < depth; ++i) {
            result.append('/');
            result.append(subpath[i]);
        }
        return result.toString();
    }

    public static String getParentPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + path + "' must be an absolute path");
        }
        if ((path = LinkUtils.cleanPath(path)).equals("/")) {
            return "/";
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return "/";
        }
        return path.substring(0, index);
    }

    public static NodeFinder getNodeFinder() {
        ExoContainer context = ExoContainerContext.getCurrentContainer();
        return (NodeFinder)context.getComponentInstance(NodeFinder.class);
    }

    public static LinkManager getLinkManager() {
        return WCMCoreUtils.getService(LinkManager.class);
    }

    public static String getExistPath(Node node, String path) throws RepositoryException {
        int deep = LinkUtils.getDepth(path);
        if (deep == 0) {
            path = LinkUtils.getAncestorPath(path, 0);
        } else {
            Session session = node.getSession();
            for (int i = deep; i > 0 && !session.itemExists(path); --i) {
                path = LinkUtils.getParentPath(path);
            }
        }
        return path;
    }

    private static String cleanPath(String path) {
        if (!(path = path.replaceAll("/+", "/")).contains("/./") && path.length() > 1 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

