/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.core.UIPermissionInfoBase;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={UIPermissionInfoBase.EditActionListener.class})})
public class UIPermissionInfo
extends UIPermissionInfoBase {
    private static final Log LOG = ExoLogger.getLogger((String)UIPermissionInfo.class.getName());

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public static class DeleteActionListener
    extends EventListener<UIPermissionInfo> {
        public void execute(Event<UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uicomp = (UIPermissionInfo)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiJCRExplorer.getCurrentNode();
            uiJCRExplorer.addLockToken(currentNode);
            ExtendedNode node = (ExtendedNode)currentNode;
            String owner = IdentityConstants.SYSTEM;
            int iSystemOwner = 0;
            if (uicomp.getExoOwner((Node)node) != null) {
                owner = uicomp.getExoOwner((Node)node);
            }
            if (owner.equals(IdentityConstants.SYSTEM)) {
                iSystemOwner = -1;
            }
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            if (uicomp.getSizeOfListPermission() < 2 + iSystemOwner) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                return;
            }
            String name = event.getRequestContext().getRequestParameter("objectId");
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            String nodeOwner = Utils.getNodeOwner((Node)node);
            if (name.equals(nodeOwner)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                return;
            }
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission(nodeOwner, PermissionType.ALL);
                }
                try {
                    node.removePermission(name);
                    node.save();
                }
                catch (AccessDeniedException ace) {
                    node.getSession().refresh(false);
                    uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.access-denied", null, 1));
                    return;
                }
                if (uiJCRExplorer.getRootNode().equals((Object)node) && !PermissionUtil.canRead((Node)currentNode)) {
                    ((UIJCRExplorerPortlet)uiJCRExplorer.getAncestorOfType(UIJCRExplorerPortlet.class)).reloadWhenBroken(uiJCRExplorer);
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-tochange", null, 1));
                return;
            }
            node.getSession().save();
            UIPopupContainer uiPopup = (UIPopupContainer)uicomp.getAncestorOfType(UIPopupContainer.class);
            if (!PermissionUtil.canRead((Node)node)) {
                uiJCRExplorer.setSelectNode(LinkUtils.getParentPath((String)uiJCRExplorer.getCurrentPath()));
                uiPopup.deActivate();
            } else {
                uicomp.updateGrid(((UIGrid)uicomp.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp.getParent());
            }
            Node realNode = uiJCRExplorer.getRealCurrentNode();
            LinkManager linkManager = (LinkManager)uiJCRExplorer.getApplicationComponent(LinkManager.class);
            if (linkManager.isLink((Item)realNode)) {
                linkManager.updateLink(realNode, currentNode);
            }
            if (currentNode.isNodeType("mix:referenceable")) {
                List symlinks = linkManager.getAllLinks(currentNode, "exo:symlink");
                for (Node symlink : symlinks) {
                    try {
                        linkManager.updateLink(symlink, currentNode);
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getMessage());
                    }
                }
            }
            currentNode.getSession().save();
            uiJCRExplorer.setIsHidePopup(true);
            if (!PermissionUtil.canRead((Node)currentNode)) {
                uiPopup.cancelPopupAction();
                uiJCRExplorer.refreshExplorer(currentNode.getSession().getRootNode(), true);
            } else {
                uiJCRExplorer.refreshExplorer(currentNode, false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiJCRExplorer);
        }
    }
}

