/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferencesInfo;

public class TrashServiceImpl
implements TrashService {
    private static final String FILE_EXPLORER_PORTLET = "FileExplorerPortlet";
    public static final String EXO_TOTAL = "exo:total";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String UUID = "exo:uuid";
    public static final String SYMLINK = "exo:symlink";
    public static final String EXO_WORKSPACE = "exo:workspace";
    public static final String EXO_TARGETWS = "exo:targetWorkspace";
    public static final String EXO_TARGETPATH = "exo:targetPath";
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private String trashWorkspace_;
    private String trashHome_;
    private ExoCache<String, Object> cache;
    private static final Log LOG = ExoLogger.getLogger((String)TrashServiceImpl.class.getName());

    public TrashServiceImpl(RepositoryService repositoryService, LinkManager linkManager, InitParams initParams) throws Exception {
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
        this.trashWorkspace_ = initParams.getValueParam("trashWorkspace").getValue();
        this.trashHome_ = initParams.getValueParam("trashHomeNodePath").getValue();
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        if (portletInvoker != null) {
            Set portlets = portletInvoker.getPortlets();
            for (Portlet portlet : portlets) {
                PortletInfo info = portlet.getInfo();
                String portletName = info.getName();
                if (!FILE_EXPLORER_PORTLET.equalsIgnoreCase(portletName)) continue;
                PreferencesInfo prefs = info.getPreferences();
                String trashWorkspace = (String)prefs.getPreference("trashWorkspace").getDefaultValue().get(0);
                String trashHome = (String)prefs.getPreference("trashHomeNodePath").getDefaultValue().get(0);
                if (trashWorkspace != null && !trashWorkspace.equals(this.trashWorkspace_)) {
                    this.trashWorkspace_ = trashWorkspace;
                }
                if (trashHome == null || trashHome.equals(this.trashHome_)) break;
                this.trashHome_ = trashHome;
                break;
            }
        }
    }

    @Override
    public String moveToTrash(Node node, SessionProvider sessionProvider) throws Exception {
        return this.moveToTrash(node, sessionProvider, 0);
    }

    @Override
    public String moveToTrash(Node node, SessionProvider sessionProvider, int deep) throws Exception {
        Session nodeSession;
        String nodeName;
        String trashId;
        block9: {
            ((SessionImpl)node.getSession()).getActionHandler().preRemoveItem((ItemImpl)node);
            trashId = "-1";
            nodeName = node.getName();
            nodeSession = node.getSession();
            nodeSession.checkPermission(node.getPath(), "remove");
            if (deep == 0 && !node.isNodeType(SYMLINK)) {
                try {
                    Utils.removeDeadSymlinks(node);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block9;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
        if (node.getPrimaryNodeType().getName().equals("nt:file") || node.isNodeType(SYMLINK)) {
            ActivityCommonService activityService = WCMCoreUtils.getService(ActivityCommonService.class);
            if (activityService.isBroadcastNTFileEvents(node)) {
                listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, null, (Object)node);
            }
        } else {
            listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, null, (Object)node);
        }
        String nodeWorkspaceName = nodeSession.getWorkspace().getName();
        if (!node.isNodeType("exo:restoreLocation")) {
            String restorePath = this.fixRestorePath(node.getPath());
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session trashSession = WCMCoreUtils.getSystemSessionProvider().getSession(this.trashWorkspace_, manageableRepository);
            String actualTrashPath = this.trashHome_ + (this.trashHome_.endsWith("/") ? "" : "/") + this.fixRestorePath(nodeName);
            if (trashSession.getWorkspace().getName().equals(nodeSession.getWorkspace().getName())) {
                trashSession.getWorkspace().move(node.getPath(), actualTrashPath);
            } else {
                trashSession.getWorkspace().clone(nodeWorkspaceName, node.getPath(), actualTrashPath, true);
                node.remove();
            }
            trashId = this.addRestorePathInfo(nodeName, restorePath, nodeWorkspaceName);
            trashSession.save();
        }
        return trashId;
    }

    private String addRestorePathInfo(String nodeName, String restorePath, String nodeWs) throws Exception {
        String restoreId = java.util.UUID.randomUUID().toString();
        NodeIterator nodes = this.getTrashHomeNode().getNodes(nodeName);
        Node node = null;
        while (nodes.hasNext()) {
            Node currentNode = nodes.nextNode();
            if (node == null) {
                node = currentNode;
                continue;
            }
            if (node.getIndex() >= currentNode.getIndex()) continue;
            node = currentNode;
        }
        if (node != null) {
            node.addMixin("exo:restoreLocation");
            node.setProperty("exo:restorePath", restorePath);
            node.setProperty("exo:restoreWorkspace", nodeWs);
            node.setProperty("exo:trashId", restoreId);
            node.save();
        }
        return restoreId;
    }

    @Override
    public void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider) throws Exception {
        Node trashHomeNode = this.getTrashHomeNode();
        Session trashNodeSession = trashHomeNode.getSession();
        Node trashNode = (Node)trashNodeSession.getItem(trashNodePath);
        String trashWorkspace = trashNodeSession.getWorkspace().getName();
        String restoreWorkspace = trashNode.getProperty("exo:restoreWorkspace").getString();
        String restorePath = trashNode.getProperty("exo:restorePath").getString();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session restoreSession = sessionProvider.getSession(restoreWorkspace, manageableRepository);
        if (restoreWorkspace.equals(trashWorkspace)) {
            trashNodeSession.getWorkspace().move(trashNodePath, restorePath);
        } else {
            restoreSession.getWorkspace().clone(trashWorkspace, trashNodePath, restorePath, true);
            trashNodeSession.getItem(trashNodePath).remove();
        }
        this.removeMixinEXO_RESTORE_LOCATION(restoreSession, restorePath);
        trashNodeSession.save();
        restoreSession.save();
    }

    @Override
    public List<Node> getAllNodeInTrash(SessionProvider sessionProvider) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL");
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    @Override
    public List<Node> getAllNodeInTrashByUser(SessionProvider sessionProvider, String userName) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL AND exo:lastModifier='").append(userName).append("'");
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    @Override
    public void removeRelations(Node node, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        String[] workspaces = manageableRepository.getWorkspaceNames();
        String queryString = "SELECT * FROM exo:relationable WHERE exo:relation IS NOT NULL";
        boolean error = false;
        for (String ws : workspaces) {
            Session session = sessionProvider.getSession(ws, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                try {
                    iter.nextNode().removeMixin("exo:relationable");
                    session.save();
                }
                catch (Exception e) {
                    error = true;
                }
            }
        }
        if (error) {
            throw new Exception("Can't remove exo:relationable of all related nodes");
        }
    }

    @Override
    public boolean isInTrash(Node node) throws RepositoryException {
        return node.getPath().startsWith(this.trashHome_) && !node.getPath().equals(this.trashHome_);
    }

    @Override
    public Node getTrashHomeNode() {
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.trashWorkspace_, this.repositoryService.getCurrentRepository());
            return (Node)session.getItem(this.trashHome_);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Node getNodeByTrashId(String trashId) throws RepositoryException {
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.trashWorkspace_, this.repositoryService.getCurrentRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * from exo:restoreLocation WHERE exo:trashId = '").append(trashId).append("'");
        QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
        query.setLimit(1L);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        if (iter.hasNext()) {
            return iter.nextNode();
        }
        return null;
    }

    private List<Node> selectNodesByQuery(SessionProvider sessionProvider, String queryString, String language) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.trashWorkspace_, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString, language);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        return ret;
    }

    private String fixRestorePath(String path) {
        int leftBracket = path.lastIndexOf(91);
        int rightBracket = path.lastIndexOf(93);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(leftBracket + 1, rightBracket));
        }
        catch (Exception ex) {
            return path;
        }
        return path.substring(0, leftBracket);
    }

    private void removeMixinEXO_RESTORE_LOCATION(Session session, String restorePath) throws Exception {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType("exo:restoreLocation")) continue;
            node.removeMixin("exo:restoreLocation");
        }
    }
}

