/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="wcm"), @Property(key="type", value="content")})
@ManagedDescription(value="WCM Service")
@RESTEndpoint(path="wcmservice")
public class WCMServiceImpl
implements WCMService {
    @Override
    public Node getReferencedContent(SessionProvider sessionProvider, String workspace, String nodeIdentifier) throws Exception {
        if (workspace == null || nodeIdentifier == null) {
            throw new ItemNotFoundException();
        }
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node content = null;
        try {
            content = session.getNodeByUUID(nodeIdentifier);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            try {
                content = (Node)session.getItem(nodeIdentifier);
            }
            catch (Exception exception) {
                content = null;
            }
        }
        return content;
    }
}

