/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.Utils;
import org.exoplatform.social.plugin.doc.UIBaseNodePresentation;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={DownloadActionListener.class})})
public class UIDocViewer
extends UIBaseNodePresentation {
    private static final String UIDocViewerPopup = "UIDocViewerPopup";
    private static final Log LOG = ExoLogger.getLogger(UIDocViewer.class);
    protected Node originalNode;
    public String docPath;
    public String repository;
    public String workspace;

    public UIDocViewer() {
        this.setTemplate("war:/groovy/social/plugin/doc/UIDocViewer.gtmpl");
    }

    public void setOriginalNode(Node originalNode) {
        this.originalNode = originalNode;
    }

    @Override
    public Node getOriginalNode() throws Exception {
        return this.getNode();
    }

    @Override
    public Node getNode() throws Exception {
        NodeLocation nodeLocation = new NodeLocation(this.repository, this.workspace, this.docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    @Override
    public void setNode(Node node) {
        this.originalNode = node;
    }

    @Override
    public String getNodeType() {
        return null;
    }

    @Override
    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    @Override
    public String getRepositoryName() {
        return "repository";
    }

    public static class DownloadActionListener
    extends EventListener<UIDocViewer> {
        public void execute(Event<UIDocViewer> event) throws Exception {
            UIDocViewer uiComp = (UIDocViewer)event.getSource();
            String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
            JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
            downloadLink = downloadLink.replaceAll("&amp;", "&");
            jsManager.addJavascript((CharSequence)("window.location.href = " + downloadLink + ";"));
        }
    }
}

