/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class SeekableByteArrayInputStream
extends ByteArrayInputStream
implements SeekableInput {
    private static final Logger log = Logger.getLogger(SeekableByteArrayInputStream.class.toString());
    private int m_iBeginningOffset;
    private final ReentrantLock lock = new ReentrantLock();

    public SeekableByteArrayInputStream(byte[] buf) {
        super(buf);
        this.m_iBeginningOffset = 0;
    }

    public SeekableByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.m_iBeginningOffset = offset;
    }

    public void seekAbsolute(long absolutePosition) {
        int absPos = (int)(absolutePosition & 0xFFFFFFFFFFFFFFFFL);
        this.pos = this.m_iBeginningOffset + absPos;
    }

    public void seekRelative(long relativeOffset) {
        int relOff = (int)(relativeOffset & 0xFFFFFFFFFFFFFFFFL);
        int currPos = this.pos + relOff;
        if (currPos < this.m_iBeginningOffset) {
            currPos = this.m_iBeginningOffset;
        }
        this.pos = currPos;
    }

    public void seekEnd() {
        this.seekAbsolute(this.getLength());
    }

    public long getAbsolutePosition() {
        int absPos = this.pos - this.m_iBeginningOffset;
        return (long)absPos & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getLength() {
        int len = this.count - this.m_iBeginningOffset;
        return (long)len & 0xFFFFFFFFFFFFFFFFL;
    }

    public InputStream getInputStream() {
        return this;
    }

    public void beginThreadAccess() {
        this.lock.lock();
    }

    public void endThreadAccess() {
        this.lock.unlock();
    }
}

