/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public class ItemLocation {
    private static final Log LOG = ExoLogger.getLogger(ItemLocation.class);
    protected String repository;
    protected String workspace;
    protected String path;
    protected String uuid;
    protected boolean isSystemSession;

    public ItemLocation() {
    }

    public ItemLocation(String repository, String workspace, String path, String uuid, boolean isSystem) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
        this.uuid = uuid;
        this.isSystemSession = isSystem;
    }

    public ItemLocation(String repository, String workspace, String path, String uuid) {
        this(repository, workspace, path, uuid, false);
    }

    public ItemLocation(String repository, String workspace, String path) {
        this(repository, workspace, path, null, false);
    }

    public ItemLocation(ItemLocation itemLocation) {
        this(itemLocation.repository, itemLocation.workspace, itemLocation.path, itemLocation.uuid, itemLocation.isSystemSession);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setSystemSession(boolean value) {
        this.isSystemSession = value;
    }

    public boolean isSystemSession() {
        return this.isSystemSession;
    }

    public static final ItemLocation getItemLocationByItem(Item item) {
        Session session = null;
        try {
            session = item.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = item.getPath();
            String uuid = null;
            try {
                if (item instanceof Node) {
                    uuid = ((Node)item).getUUID();
                }
            }
            catch (RepositoryException e) {
                uuid = null;
            }
            boolean isSystemSession = IdentityConstants.SYSTEM.equals(session.getUserID());
            return new ItemLocation(repository, workspace, path, uuid, isSystemSession);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static final Item getItemByLocation(ItemLocation itemLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

