/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class FlateDecode
extends ChunkingInputStream {
    private static int DEFAULT_BUFFER_SIZE = Defs.sysPropertyInt("org.icepdf.core.flateDecode.bufferSize", 16384);
    public static final Name DECODE_PARMS_VALUE = new Name("DecodeParms");
    public static final Name PREDICTOR_VALUE = new Name("Predictor");
    public static final Name WIDTH_VALUE = new Name("Width");
    public static final Name COLUMNS_VALUE = new Name("Columns");
    public static final Name COLORS_VALUE = new Name("Colors");
    public static final Name BITS_PER_COMPONENT_VALUE = new Name("BitsPerComponent");
    private InputStream originalInputKeptSolelyForDebugging;
    private int width;
    private int numComponents;
    private int bitsPerComponent;
    private int bpp = 1;
    private int predictor;

    public FlateDecode(Library library, HashMap props, InputStream input) {
        this.originalInputKeptSolelyForDebugging = input;
        this.width = 0;
        this.numComponents = 0;
        this.bitsPerComponent = 0;
        this.bpp = 1;
        int intermediateBufferSize = DEFAULT_BUFFER_SIZE;
        HashMap decodeParmsDictionary = library.getDictionary(props, DECODE_PARMS_VALUE);
        this.predictor = library.getInt(decodeParmsDictionary, PREDICTOR_VALUE);
        if (this.predictor != 1 && this.predictor != 2 && this.predictor != 10 && this.predictor != 11 && this.predictor != 12 && this.predictor != 13 && this.predictor != 14 && this.predictor != 15) {
            this.predictor = 1;
        }
        if (this.predictor != 1) {
            Object bitsPerComponentDecodeParmsObj;
            Number widthNumber = library.getNumber(props, WIDTH_VALUE);
            this.width = widthNumber != null ? widthNumber.intValue() : library.getInt(decodeParmsDictionary, COLUMNS_VALUE);
            this.numComponents = 1;
            this.bitsPerComponent = 8;
            Object numComponentsDecodeParmsObj = library.getObject(decodeParmsDictionary, COLORS_VALUE);
            if (numComponentsDecodeParmsObj instanceof Number) {
                this.numComponents = ((Number)numComponentsDecodeParmsObj).intValue();
            }
            if ((bitsPerComponentDecodeParmsObj = library.getObject(decodeParmsDictionary, BITS_PER_COMPONENT_VALUE)) instanceof Number) {
                this.bitsPerComponent = ((Number)bitsPerComponentDecodeParmsObj).intValue();
            }
            this.bpp = Math.max(1, Utils.numBytesToHoldBits(this.numComponents * this.bitsPerComponent));
            intermediateBufferSize = Utils.numBytesToHoldBits(this.width * this.numComponents * this.bitsPerComponent);
        }
        this.setInputStream(new InflaterInputStream(input));
        this.setBufferSize(intermediateBufferSize);
    }

    protected int fillInternalBuffer() throws IOException {
        if (this.predictor == 1) {
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            return numRead;
        }
        if (this.predictor == 2) {
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            if (this.bitsPerComponent == 8) {
                for (int i = 0; i < numRead; ++i) {
                    int prevIndex = i - this.numComponents;
                    if (prevIndex < 0) continue;
                    int n = i;
                    this.buffer[n] = (byte)(this.buffer[n] + this.buffer[prevIndex]);
                }
            }
            return numRead;
        }
        if (this.predictor >= 10 && this.predictor <= 15) {
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            return numRead;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", orig: ");
        if (this.originalInputKeptSolelyForDebugging == null) {
            sb.append("null");
        } else {
            sb.append(this.originalInputKeptSolelyForDebugging.toString());
        }
        return sb.toString();
    }
}

