/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.utils.permission;

import java.security.AccessControlException;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;

public class PermissionUtil {
    public static boolean canRead(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "read");
    }

    public static boolean canAddNode(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "add_node");
    }

    public static boolean canChangePermission(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "add_node,set_property,remove");
    }

    public static boolean canAnyAccess(Node node) throws RepositoryException {
        return PermissionUtil.hasPermissions(node, IdentityConstants.ANY, PermissionType.DEFAULT_AC);
    }

    public static boolean canSetProperty(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "set_property");
    }

    public static boolean canRemoveNode(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "remove");
    }

    public static boolean hasPermissions(Node node, String identity, String[] permissions) throws RepositoryException {
        if (ExtendedNode.class.isAssignableFrom(node.getClass())) {
            ExtendedNode extNode = (ExtendedNode)ExtendedNode.class.cast(node);
            MembershipEntry identityMembership = MembershipEntry.parse((String)identity);
            HashSet<String> identityPermissions = new HashSet<String>();
            for (AccessControlEntry ace : extNode.getACL().getPermissionEntries()) {
                if (identityMembership != null && ace.getMembershipEntry() != null) {
                    MembershipEntry me = ace.getMembershipEntry();
                    if (!identityMembership.getGroup().equals(me.getGroup()) || !me.getMembershipType().equals(identityMembership.getMembershipType()) && !me.getMembershipType().equals("*")) continue;
                    identityPermissions.add(ace.getPermission());
                    continue;
                }
                if (ace.getIdentity().equals(identity)) {
                    identityPermissions.add(ace.getPermission());
                    continue;
                }
                if (!ace.getIdentity().equals(IdentityConstants.ANY)) continue;
                identityPermissions.add(ace.getPermission());
            }
            if (!identityPermissions.isEmpty()) {
                int checks = permissions.length;
                for (String p : permissions) {
                    if (!identityPermissions.contains(p)) continue;
                    --checks;
                }
                identityPermissions.clear();
                return checks == 0;
            }
        }
        return false;
    }

    private static boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

